---
name: cargo-policy-analyzer
description: 搜索并分析中国各省航空货运落地最新优惠政策，进行多维度对比，生成综合性分析报告。当用户需要了解航空货运政策、对比不同省份政策优势、获取投资选址参考时触发此技能。
---

# 航空货运政策分析器

对中国各省航空货运落地优惠政策进行搜索、分析和对比，生成专业报告。

## 功能定位

- **政策爬取**：搜索各省市航空货运、货运补贴、航线支持相关政策
- **多维对比**：从补贴力度、覆盖范围、申请条件、时效性等维度对比
- **报告生成**：输出综合性分析报告，包含数据表格和结论建议

## 分析维度

| 维度 | 说明 |
|------|------|
| 补贴力度 | 财政补贴金额、补贴比例、最高限额 |
| 覆盖范围 | 适用航线、货量要求、企业类型 |
| 申请条件 | 资质要求、注册地要求、年限要求 |
| 兑现时效 | 申报周期、发放方式、到账时间 |
| 政策稳定性 | 政策期限、续期情况、调整频率 |
| 产业配套 | 物流设施、通关便利、仓储能力 |

## 工作流程

### Step 1: 政策信息收集

搜索并收集以下省份/城市的航空货运政策：
- 重点省份：上海、江苏、浙江、广东、北京、天津
- 中西部：四川、重庆、陕西、湖北、河南
- 东北：辽宁、黑龙江、吉林
- 其他：山东、福建、海南等

信息来源：
- 省级/市级交通运输厅/局官网
- 商务厅/局官网
- 人民政府官网
- 自由贸易试验区官网
- 临空经济区/航空港经济区官网

### Step 2: 结构化提取

从政策文件中提取关键信息：
- 政策名称和文号
- 发布部门和日期
- 适用区域范围
- 补贴/支持具体内容
- 申请条件和流程
- 有效期限

### Step 3: 多维度对比分析

建立对比表格，横向比较各省份政策优劣。

### Step 4: 报告生成

输出结构化分析报告，包含：
1. 政策总览表
2. 各维度排名
3. 核心结论
4. 适用场景建议

## 输出格式

### 政策汇总表 (Markdown)

```
| 省份 | 政策名称 | 补贴类型 | 补贴标准 | 申请条件 | 有效期 |
|------|----------|----------|----------|----------|--------|
```

### 综合分析报告

1. **政策全景图** - 全国航空货运政策分布
2. **补贴力度排行** - 哪些省份力度最大
3. **性价比分析** - 投入产出比最优选择
4. **投资建议** - 不同场景下的最优选择
5. **风险提示** - 政策稳定性、申报难点等

## 信息源优先级

1. 政府官方文件（带文号）
2. 新闻发布会/官方解读
3. 权威媒体报道
4. 行业研究报告

## 注意事项

- 政策有时效性，标注政策发布/更新时间
- 区分省级政策和市级政策
- 注意政策的适用范围和限制条件
- 对于模糊信息，标注"待核实"

## 默认规则

- 未指定省份：覆盖全国主要省份
- 未指定维度：默认使用上述全部维度
- 未指定时间范围：优先最新政策（2024-2026）
