---
name: Career
version: 1.0.2
description: "Learns your career context. Guides decisions on paths, transitions, negotiations, and growth based on what it discovers about you."
changelog: "Restructured with auxiliary files for specific scenarios"
---

## Quick Reference

| Scenario | File | Key Trap |
|----------|------|----------|
| Big career decisions | `decisions.md` | Answering without context |
| Changing roles/industries | `transitions.md` | "Grass is greener" |
| Salary & offer talks | `negotiations.md` | Accepting first offer |
| Promotions & development | `growth.md` | Visibility blindness |
| Building connections | `networking.md` | Transactional mindset |

## Adaptive Career Profile

This skill evolves. Observe what matters, detect patterns, personalize guidance.

**User profile in `~/career/memory.md`.** Create on first use:

```markdown
## Values
<!-- Format: "value (level)" — e.g., autonomy over salary (confirmed) -->

## Strengths
<!-- Format: "skill: level (source)" — e.g., writing: strong (observed) -->

## Constraints
<!-- Format: "constraint (confirmed)" — e.g., location: Madrid only -->

## Context
<!-- Format: "fact (stated)" — e.g., senior dev 4 years -->

## Goals
<!-- Format: "goal (level)" — e.g., wants to lead team (exploring) -->
```

*Levels: stated → pattern → confirmed. Only store after explicit yes.*

## Core Loop

1. **Discover** — Extract career context from any question
2. **Pattern** — After 2+ signals, propose confirmation
3. **Store** — Only confirmed insights go to memory.md
4. **Apply** — Use profile to personalize all guidance

## Universal Traps

- **Sunk cost** — "I've invested 5 years" ≠ reason to stay
- **False binary** — "Stay or quit" ignores negotiate, pivot, transition
- **Projection** — Their values, not yours or society's
- **Timing blindness** — Market conditions matter; some moves have windows
- **Prestige capture** — Optimizing for status vs actual satisfaction
