# Car Maintenance Guide

## Maintenance Schedule

Follow your owner's manual, but these are typical intervals:

| Service | Interval | DIY Difficulty |
|---------|----------|----------------|
| Oil change | 5,000-10,000 mi (check manual) | Easy |
| Tire rotation | 5,000-7,500 mi | Easy |
| Air filter | 15,000-30,000 mi | Very easy |
| Cabin filter | 15,000-25,000 mi | Easy |
| Brake inspection | 20,000-30,000 mi | Medium |
| Transmission fluid | 30,000-60,000 mi | Leave to shop |
| Spark plugs | 30,000-100,000 mi (varies) | Medium |
| Coolant flush | 30,000-50,000 mi | Medium |
| Timing belt | 60,000-100,000 mi | Hard — shop job |
| Brake fluid | Every 2-3 years | Medium |

**Severe use adjustments:** City driving, towing, extreme temps = more frequent service.

---

## DIY vs Mechanic Decision

**Do it yourself:**
- Air filter replacement (5 min, $15-30 part)
- Cabin air filter (10 min, $15-25)
- Wiper blade replacement (5 min, $20-40)
- Battery replacement (15 min, $100-200)
- Tire pressure check and inflate (5 min, free)
- Oil change (30 min, $30-50 in materials)

**Needs some skill:**
- Brake pad replacement ($50-100 parts, saves $100-200 labor)
- Spark plug replacement (varies by access)
- Battery terminal cleaning

**Leave to professionals:**
- Timing belt/chain
- Transmission work
- AC system (requires certification)
- Suspension work
- Engine diagnostics with codes

---

## Symptom Diagnosis

**Noises:**
| Sound | Likely Cause | Urgency |
|-------|--------------|---------|
| Squealing when braking | Brake pads worn | Get checked this week |
| Grinding when braking | Pads completely gone, rotors damaged | Stop driving, fix now |
| Clicking when turning | CV joint | Fix within weeks |
| Rumbling/humming at speed | Wheel bearing | Fix within weeks |
| Knocking from engine | Low oil, timing issue | Stop and check oil now |
| Hissing under hood | Vacuum leak or coolant leak | Check soon |

**Behaviors:**
| Symptom | Likely Cause |
|---------|--------------|
| Pulls to one side | Alignment, tire pressure, brake issue |
| Vibration at highway speed | Tire balance, wheel alignment, warped rotor |
| Hard to start | Battery, starter, fuel pump |
| Stalling | Fuel delivery, ignition, sensors |
| Poor fuel economy | Tire pressure, air filter, O2 sensor |

---

## Mechanic Red Flags

**Signs of an honest shop:**
- Explains issues clearly without jargon pressure
- Shows you the worn/broken part
- Provides written estimate before work
- Doesn't push unnecessary services
- Has visible certifications (ASE)

**Red flags:**
- "Everything needs replacing" on routine visit
- Won't let you see old parts
- Vague verbal estimates, detailed invoice later
- Pressure tactics: "This is unsafe to drive"
- Recommends "fuel system cleaning" or "engine flush" every visit

**Protect yourself:**
1. Get everything in writing before authorizing
2. Ask: "What happens if I don't fix this now?"
3. For major repairs ($500+), get second opinion
4. Check reviews specific to your car make

---

## Seasonal Prep

**Before winter:**
- [ ] Battery test (cold kills weak batteries)
- [ ] Antifreeze level and strength
- [ ] Tire tread depth (minimum 4/32" for snow)
- [ ] Wiper blades and washer fluid (winter formula)
- [ ] Emergency kit: blanket, flashlight, snacks, phone charger

**Before summer:**
- [ ] AC system working
- [ ] Coolant level and condition
- [ ] Tire pressure (heat increases pressure)
- [ ] Check belts for cracks

---

## OBD-II Codes

When check engine light comes on:
1. Get code read (free at auto parts stores)
2. Write down exact code (e.g., P0420)
3. Search "[code] + [your car model]"
4. Common codes are often cheap fixes; rare codes need diagnosis

**Common codes:**
- P0420: Catalytic converter efficiency (often O2 sensor first)
- P0300-P0308: Misfire (spark plugs, coils, injectors)
- P0171/P0174: System lean (vacuum leak, MAF sensor)
- P0440-P0449: EVAP system (often gas cap loose)
