# Car Emergencies Guide

## Breakdown: First 5 Minutes

1. **Turn on hazard lights immediately**
2. **Get off the road if possible** — coast to shoulder, parking lot, exit ramp
3. **If stuck in traffic:** Stay in car with seatbelt on until safe to exit
4. **Exit on the side AWAY from traffic** (right side on highways)
5. **Set up warning triangles** — 50-100 meters behind car if you have them
6. **Stand well away from the vehicle** — other cars may not see you

---

## Who to Call (In Order)

**If anyone is injured or it's dangerous:**
1. Emergency services (911 US, 112 EU)

**If safe but stranded:**
1. Roadside assistance (check insurance card, AAA, manufacturer program)
2. Insurance company (they often coordinate towing)
3. Trusted local tow company (if you know one)
4. Friend/family for pickup if needed

**Know these numbers BEFORE you need them:**
- Your insurance's roadside number
- AAA or local equivalent
- A mechanic you trust

---

## Flat Tire: Quick Steps

1. Pull to safe, flat location away from traffic
2. Apply parking brake
3. Get spare, jack, lug wrench from trunk
4. Loosen lug nuts slightly BEFORE jacking up
5. Jack car at designated point (check manual)
6. Remove lugs, swap tire
7. Hand-tighten lugs in star pattern
8. Lower car, then fully tighten lugs
9. Check spare pressure ASAP — spares lose air sitting

**If you can't change it:** Call roadside assistance. No shame.

---

## Car Accident: Immediate Steps

**At the scene:**
1. Check yourself and passengers for injuries
2. Call emergency services if anyone hurt
3. Move vehicles to side of road if safe and drivable
4. Exchange with other driver:
   - Name, phone, address
   - Insurance company and policy number
   - Driver's license number
   - License plate numbers
   - Car make/model/color

**Document everything:**
- [ ] Photos of all vehicle damage (all angles)
- [ ] Photos of the scene (road, signs, conditions)
- [ ] Photos of other car's license plate
- [ ] Names and contacts of witnesses
- [ ] Screenshot of location (GPS coordinates)

**Do NOT:**
- Admit fault or apologize (even if you think it's your fault)
- Accept cash to "settle it here" — always go through insurance
- Leave the scene before documenting

---

## Insurance Claim Process

**Same day:**
1. File claim with YOUR insurance (even if other driver at fault)
2. Provide all documentation: photos, police report number, other driver info
3. Ask about rental car coverage

**Next steps:**
- Insurance assigns adjuster
- Adjuster inspects damage or reviews photos
- Get repair estimate (you can choose your shop)
- Insurance negotiates if other party's fault

**If car is totaled:**
- Insurance pays "actual cash value" (ACV)
- Research your car's value on KBB, Edmunds before accepting
- You can negotiate if their offer is low
- Gap insurance covers difference between ACV and loan balance

---

## Roadside Emergency Kit

**Essentials:**
- Jumper cables or jump starter pack
- Flashlight + extra batteries
- Basic first aid kit
- Warning triangles or flares
- Tire pressure gauge
- Work gloves
- Phone charger (car and portable battery)

**Extended kit:**
- Duct tape
- Zip ties
- Basic tool kit (screwdrivers, pliers, wrench)
- Tow strap
- Blanket
- Water bottle
- Non-perishable snacks
- Rain poncho

**Winter additions:**
- Ice scraper / snow brush
- Small shovel
- Cat litter or sand (for traction)
- Extra warm clothes / blanket

---

## Tow Truck Tips

- **Know where you want to go** — have a mechanic in mind
- **Get price estimate before they load** — distance, hook-up fee
- **Watch for "lowball then upcharge"** — confirm total price
- **Flatbed preferred** for AWD/4WD or low cars
- **Document mileage and car condition** before they tow
- **Keep keys and valuables with you**

---

## Common Roadside Fixes

**Dead battery:**
- Jump start with cables (red to dead positive, red to live positive, black to live negative, black to dead car's ground/metal)
- Let run 15-20 min to charge
- If dies again, battery likely needs replacement

**Overheating:**
- Pull over immediately, turn off AC, turn ON heat (pulls heat from engine)
- Let cool 15-30 min before opening hood
- Check coolant level WHEN COOL — never open hot radiator
- Top up coolant or water if low
- If keeps overheating, do not drive — call tow

**Out of gas:**
- Call roadside for fuel delivery
- Or walk to station with approved gas can
- Put in just enough to reach station
