---
name: Car
description: Buy, maintain, and handle car emergencies with cost estimates, maintenance schedules, and roadside problem-solving.
---

## Decision Tree

| Situation | Action |
|-----------|--------|
| Buying a car | Check `buying.md` for price negotiation, inspection checklist, financing |
| Maintenance due or warning light | Check `maintenance.md` for schedules, DIY vs mechanic, symptom diagnosis |
| Breakdown or accident | Check `emergencies.md` for immediate steps, who to call, documentation |
| Road trip planning | Pre-trip checklist below, then `emergencies.md` for kit and what-ifs |

---

## Pre-Trip Checklist

Before any long drive:
- [ ] Tire pressure (including spare) at recommended PSI
- [ ] Oil level between min/max marks
- [ ] Coolant reservoir at proper level
- [ ] All lights working (headlights, brake, turn signals)
- [ ] Windshield washer fluid filled
- [ ] Wiper blades not streaking
- [ ] Phone charger and emergency contact numbers accessible

---

## Warning Lights — Quick Reference

| Light | Severity | Action |
|-------|----------|--------|
| Check engine (steady) | Medium | Safe to drive, diagnose within days |
| Check engine (flashing) | Critical | Stop driving, call tow |
| Oil pressure | Critical | Stop immediately, check oil level |
| Temperature/coolant | Critical | Pull over, let engine cool, check coolant |
| Battery | Medium | Drive to shop, may have 30-60 min before stall |
| ABS | Low | Brakes work, but ABS disabled — drive carefully |
| Tire pressure | Low | Check and inflate soon |

---

## Cost Sanity Check

Before approving any repair, verify the quote:
1. Get the exact repair name (not "fix the engine")
2. Search "[repair name] + [car model] + cost" for typical range
3. Labor: $80-150/hr is normal; over $200/hr is premium/dealer
4. If quote is 50%+ above average, get a second opinion

Common repairs (USD):
- Oil change: $30-75
- Brake pads (pair): $150-300 installed
- Battery replacement: $150-250
- Alternator: $400-600
- Timing belt: $500-1000

---

## Fuel Efficiency Tips

- Optimal highway speed: 55-65 mph (above 65, efficiency drops ~15%)
- Tire pressure: check monthly, underinflation costs 0.2% per PSI
- AC vs windows: AC more efficient above 45 mph
- Remove roof racks when not in use (5% drag penalty)
- Avoid idling more than 30 seconds

---

## When to Load More

| Situation | Reference |
|-----------|-----------|
| Buying new or used, financing, negotiation | `buying.md` |
| Maintenance schedules, DIY repairs, diagnostics | `maintenance.md` |
| Accidents, breakdowns, insurance claims | `emergencies.md` |
