# Rent vs Lease vs Buy — Car Rental

## Decision Framework

### When to Rent (days to weeks)

**Best for:**
- Travel and vacations
- Occasional car needs
- Testing before buying
- Car in the shop temporarily
- Special occasions (weddings, road trips)

**Advantages:**
- Maximum flexibility
- No commitment
- Insurance included (usually)
- Different car each time
- No maintenance concerns

**Disadvantages:**
- Highest daily cost
- Paperwork each time
- Age restrictions
- Credit card holds

### When to Lease (months to years)

**Best for:**
- Temporary relocation (3-24 months)
- Business use with tax benefits
- Testing a car/lifestyle before buying
- Don't want maintenance responsibility
- Prefer predictable monthly cost
- Want new car every few years

**Advantages:**
- Lower monthly cost than renting
- Maintenance often included
- Newer vehicles
- Predictable expenses
- Gap coverage typically included

**Disadvantages:**
- Mileage limits (usually 10-15k km/year)
- Early termination fees
- No ownership at end
- Wear-and-tear charges
- Must maintain good condition

### When to Buy

**Best for:**
- Permanent car need
- High mileage usage
- Want to customize
- Plan to keep 5+ years
- Build equity

**Advantages:**
- No mileage limits
- Own the asset
- Customize freely
- No payments after payoff
- Can sell anytime

**Disadvantages:**
- Highest upfront cost
- Depreciation risk
- Maintenance responsibility
- Insurance your problem
- Tied to one vehicle

## Break-even Calculations

### Rental vs Lease Break-even

**General rule:** If you need a car for more than 2-3 months continuously, leasing becomes cheaper.

**Example calculation:**
- Rental: €40/day = €1,200/month
- Lease: €400/month + €1,000 deposit
- Break-even: ~2 months

**But factor in:**
- Rental insurance often included
- Lease might require separate insurance
- Lease deposit opportunity cost
- Rental flexibility value

### Lease vs Buy Break-even

**General rule:** If keeping 5+ years, buying is usually cheaper total cost.

**3-year comparison example (mid-size sedan):**
| Option | 3-Year Total |
|--------|-------------|
| Lease | €400 x 36 = €14,400 |
| Buy (financed) | €25,000 - €12,000 resale = €13,000 + interest |
| Buy (cash) | €25,000 - €12,000 resale = €13,000 |

**But factor in:**
- Maintenance costs (owned car)
- Depreciation uncertainty
- Opportunity cost of capital
- Flexibility value

## Special Situations

### Company Car (Business Use)

Often lease is tax-advantageous:
- Payments deductible (check local rules)
- VAT recovery possible
- No asset on balance sheet
- Predictable fleet costs

### Expat/Relocation

Consider:
- Lease for known duration
- Subscription for uncertainty
- Local vs international company
- Re-export complications

### Testing Before Buying

Strategy:
1. Rent the exact model for a weekend
2. If interested, lease for 3-6 months
3. Then buy with confidence

### Seasonal Needs

If you only need a car part of the year:
- Summer cottage: rent each visit
- Winter car: consider 6-month lease
- Calculate annual cost both ways
