# 자동차/보험 플레이북

> 공통 Phase 구조: [`../common/playbook_base.md`](../common/playbook_base.md)

---

## Phase 1: 인텐트 분류 & 파라미터 확인

1. 사용자 요청을 [`references/intent_router.md`](references/intent_router.md)로 분류
2. **초보자 모드 감지**: "쉽게", "기초", "처음인데" 키워드 확인
3. 필수 파라미터:
   - **Car Tax Calc**: 차종 + 배기량(cc) / 차명으로 추정 가능
   - **Car Price Check**: 차명 + 연식
   - **Insurance Claim**: 사고 유형
4. 파라미터 부족 시:
   ```
   예: "어떤 차 세금이 궁금하세요? 배기량(cc)이나 차명 알려주세요"
   예: "단독사고인가요, 상대방 차량과 충돌인가요?"
   ```

---

## Phase 2: 데이터 수집

### 2-1. 자동차세 계산 (내장 세율표 → 즉시 계산)
법령 조회 없이 아래 Phase 3 세율표로 직접 계산. 차명 입력 시 배기량 추정.

### 2-2. 중고차 시세 (웹 검색)
```
web_search: "[차명] [연식] 중고차 시세 엔카"
web_search: "[차명] [연식] KB차차차 중고 가격"
```

### 2-3. 보험료 참고 (보험개발원 공시 / 웹)
```
web_search: "자동차보험 [차종] [나이] 보험료 2026"
web_search: "보험다모아 [차종] 보험료"
```
- 보험개발원 공시 API: `apis.data.go.kr` (data.go.kr 등록, 키 필요 시 신청)

### 2-4. 교통위반 기준 (내장 조견표 → 즉시 응답)
법령 조회 없이 아래 Phase 3 조견표로 직접 응답. 신규 기준 변경 시 web_search 보강.

### 2-5. 법령 조회 (심층 질문 시)
```bash
bash skills/law-search/scripts/law_search.sh "지방세법 자동차세" 3
bash skills/law-search/scripts/law_search.sh "도로교통법 과태료" 3
```

---

## Phase 3: 분석 레퍼런스

### 자동차세 세율 (지방세법 제127조, 2025년 기준)

**승용차 (배기량 기준)**
| 배기량 | cc당 세율 |
|--------|---------|
| 1,000cc 이하 | 80원 |
| 1,600cc 이하 | 140원 |
| 1,600cc 초과 | 200원 |

**연식별 경감율**
| 차령 | 경감율 |
|------|-------|
| 3년 | 5% |
| 4년 | 10% |
| 5년 | 15% |
| 6년 | 20% |
| 7년 | 25% |
| 8년 | 30% |
| 9년 | 35% |
| 10년↑ | 50% (최대) |

**계산 예시**
```
2,000cc 승용차, 7년 차령
→ 연세액 = 2,000 × 200 = 400,000원
→ 25% 경감 = 300,000원
→ 지방교육세(연세액의 30%) = 90,000원 포함 시 390,000원
```

**기타 차종**
| 차종 | 세율 |
|------|------|
| 승합 (7인 이하) | 65,000원/년 |
| 승합 (8~10인) | 100,000원/년 |
| 승합 (11~15인) | 130,000원/년 |
| 화물 (1t 이하) | 28,500원/년 |
| 화물 (1t~2.5t) | 34,500원/년 |
| 이륜차 (125cc 이하) | 18,000원/년 |
| 이륜차 (125cc↑) | 배기량×0.8원 / 최대 72,000원 |

### 의무보험 최저 한도 (자동차손해배상보장법)
| 담보 | 의무 한도 |
|------|---------|
| 대인배상I (사망) | 최대 1억5천만원 |
| 대인배상I (부상) | 최대 3천만원 |
| 대물배상 | 최대 2천만원 |
| 미가입 과태료 | 1일 1만원 (최대 300만원) |

### 보험료 주요 영향 요인
1. **차량 요인**: 차종·차령·차량가액·도난위험도
2. **운전자 요인**: 나이·성별·운전 경력·사고 이력
3. **특약**: 담보 범위(자차 포함 여부)·면책금액
4. **할인**: 무사고 할인·마일리지 특약·블랙박스 특약

### 중고차 구매 체크리스트
**서류 확인**
- [ ] 자동차등록증 (차대번호 일치 여부)
- [ ] 성능·상태 점검기록부 (판매자 의무 제공)
- [ ] 카히스토리 조회 (carhistory.or.kr, 사고·침수·압류 이력)
- [ ] 국토부 자동차 이력 조회 (자동차민원 대국민포털)

**차량 실물 확인**
- [ ] 차체 이음새 균일 여부 (사고 판금 흔적)
- [ ] 도어·트렁크 개폐 원활 여부
- [ ] 엔진룸 오일 누유·부식 여부
- [ ] 실내 냄새 (침수 시 곰팡이·흙냄새)
- [ ] OBD2 진단 (정비소 방문 권장)

---

## Phase 4: 출력

[`references/output_templates.md`](references/output_templates.md) 템플릿 적용:
- **Flash Layer**: 항상 출력
- **Deep-Dive**: 요청 시 or Insurance Claim / Maintenance Cost / Used Car Check

### 면책 문구 (모든 응답 필수)
> ⚠️ 자동차세 계산은 공시 기준이며 실제 고지서와 차이가 있을 수 있습니다.
> 보험료는 참고치이며, 실제 보험료는 가입 조건에 따라 다릅니다.
