---
name: capacities
description: Manage Capacities notes, daily entries, and weblinks.
metadata:
  {
    "openclaw":
      {
        "emoji": "🧠",
        "requires": { "env": ["CAPACITIES_API_TOKEN"] },
        "primaryEnv": "CAPACITIES_API_TOKEN",
      },
  }
---

# Capacities Skill

Use this skill to interact with your Capacities "Second Brain".

## Requirements
- `CAPACITIES_API_TOKEN`: Obtain from Settings > Capacities API in the desktop app.
- `CAPACITIES_SPACE_ID`: (Optional) If not provided, the first available space will be used.

## Usage

### Daily Notes
To add a thought, task, or note to today's daily note:
`curl -X POST https://api.capacities.io/save-to-daily-note -H "Authorization: Bearer $CAPACITIES_API_TOKEN" -H "Content-Type: application/json" -d '{"spaceId": "$CAPACITIES_SPACE_ID", "mdText": "Your note here"}'`

### Web Links
To save a URL to your space:
`curl -X POST https://api.capacities.io/save-weblink -H "Authorization: Bearer $CAPACITIES_API_TOKEN" -H "Content-Type: application/json" -d '{"spaceId": "$CAPACITIES_SPACE_ID", "url": "https://example.com"}'`

### Search / Lookup
To find an object's ID:
`curl -X POST https://api.capacities.io/lookup -H "Authorization: Bearer $CAPACITIES_API_TOKEN" -H "Content-Type: application/json" -d '{"spaceId": "$CAPACITIES_SPACE_ID", "searchTerm": "My Note"}'`

### Space Info
To get all object types and structures:
`curl -X GET "https://api.capacities.io/space-info?spaceid=$CAPACITIES_SPACE_ID" -H "Authorization: Bearer $CAPACITIES_API_TOKEN"`
