#!/bin/bash
# Canvas-OS: Open an app on Canvas
# Usage: ./open-app.sh <app-name> [port] [node-name]

APP_NAME="${1:-my-app}"
PORT="${2:-9876}"
NODE="${3:-$(openclaw nodes status --json 2>/dev/null | jq -r '.nodes[0].displayName' 2>/dev/null)}"
APPS_DIR="${CANVAS_APPS_DIR:-$HOME/.openclaw/workspace/apps}"

if [ -z "$NODE" ] || [ "$NODE" = "null" ]; then
  echo "❌ No node found. Run: openclaw nodes status"
  exit 1
fi

echo "🚀 Opening $APP_NAME on port $PORT (node: $NODE)..."

# Kill any existing server on this port
lsof -ti:$PORT 2>/dev/null | xargs kill -9 2>/dev/null

# Check app exists
if [ ! -d "$APPS_DIR/$APP_NAME" ]; then
  echo "❌ App not found: $APPS_DIR/$APP_NAME"
  exit 1
fi

# Start server
cd "$APPS_DIR/$APP_NAME"
python3 -m http.server $PORT > /dev/null 2>&1 &
SERVER_PID=$!
echo "📡 Server started (PID: $SERVER_PID)"

# Wait for server
sleep 1

# Check server is running
if ! curl -s "http://localhost:$PORT/" > /dev/null 2>&1; then
  echo "❌ Server failed to start"
  exit 1
fi

# Navigate Canvas
openclaw nodes canvas navigate --node "$NODE" "http://localhost:$PORT/"
echo "✅ Canvas navigated to $APP_NAME"

# Save PID for later cleanup
echo $SERVER_PID > "/tmp/canvas-app-$APP_NAME.pid"
