#!/bin/bash
# Canvas-OS: Close an app and stop its server
# Usage: ./close-app.sh <app-name> [node-name]

APP_NAME="${1:-my-app}"
NODE="${2:-$(openclaw nodes status --json 2>/dev/null | jq -r '.nodes[0].displayName' 2>/dev/null)}"

echo "🛑 Closing $APP_NAME..."

# Kill server if PID file exists
PID_FILE="/tmp/canvas-app-$APP_NAME.pid"
if [ -f "$PID_FILE" ]; then
  PID=$(cat "$PID_FILE")
  kill -9 $PID 2>/dev/null && echo "📡 Server stopped (PID: $PID)"
  rm "$PID_FILE"
else
  echo "⚠️ No PID file found for $APP_NAME"
fi

# Hide Canvas (optional)
if [ -n "$NODE" ] && [ "$NODE" != "null" ]; then
  openclaw nodes canvas hide --node "$NODE" 2>/dev/null
fi

echo "✅ Done"
