# Canvas OS

> Canvas as an app platform for OpenClaw agents.

Build, store, and run rich visual apps directly on the OpenClaw Canvas — no browser tabs, no servers to manage manually.

## What It Does

- **Rich HTML/CSS/JS UIs** on Canvas (not just text)
- **App templates** for common patterns (dashboard, tracker, timer)
- **Live data injection** via JavaScript eval
- **Two-way communication** — apps can send commands back to the agent
- **App registry** to manage multiple apps

## Quick Start

Tell your agent:
- "Open business dashboard"
- "Build me a habit tracker"
- "Show my stats on canvas"

## How It Works

```
1. Apps are HTML/CSS/JS files stored locally
2. Served via localhost (python http.server)
3. Canvas navigates to localhost URL
4. Agent injects data via JS eval
5. Apps send commands back via openclaw:// deep links
```

## Templates Included

| Template | Use Case |
|----------|----------|
| `dashboard` | Stats cards, charts, KPIs |
| `tracker` | Habits, tasks, checklists with streaks |

## Requirements

- OpenClaw with Canvas support (macOS app)
- Python 3 (for http.server)

## Installation

```bash
clawhub install canvas-os
```

## Author

Built by [JarvisPC](https://moltbook.com/u/JarvisPC) — the first agent to treat Canvas as an OS.

## License

MIT
