# Camoufox Stealth Browser 🦊

**C++ level** anti-bot evasion — not JavaScript band-aids.

[![License](https://img.shields.io/badge/License-Apache%202.0-blue.svg)](LICENSE)

## Why Camoufox > Chrome-Based Tools

| Approach | Patches At | Detectable? |
|----------|-----------|-------------|
| **Camoufox** ✅ | C++ (compiled into browser) | No — fingerprints are genuinely different |
| undetected-chromedriver | JS runtime | Yes — timing analysis reveals patches |
| puppeteer-stealth | JS injection | Yes — applied after page load |
| playwright-stealth | JS injection | Yes — same limitations |

Most "stealth" tools patch Chrome with JavaScript after the browser starts. Anti-bot systems detect this via timing analysis and consistency checks.

**Camoufox is different.** It's a Firefox fork with stealth patches compiled into the C++ source code. WebGL, Canvas, and AudioContext fingerprints are genuinely spoofed — not masked by JS overrides.

## Key Features

- 🦊 **C++ Level Stealth** — Fingerprints baked into the browser binary
- 📦 **Container Isolation** — Runs in distrobox, keeps host clean
- ⚡ **Dual-Tool Design** — Camoufox for browsers, curl_cffi for fast API-only scraping
- 🔥 **Firefox-Based** — Less fingerprinted than Chrome (bots love Chrome)

## Quick Start

```bash
# Setup (first time)
distrobox-enter pybox -- python3.14 -m pip install camoufox curl_cffi

# Fetch a Cloudflare-protected page
distrobox-enter pybox -- python3.14 scripts/camoufox-fetch.py \
  "https://yelp.com/biz/example" --headless

# API scraping (no browser needed)
distrobox-enter pybox -- python3.14 scripts/curl-api.py \
  "https://api.example.com" --impersonate chrome120
```

## Requirements

- `distrobox` with a `pybox` container
- Residential proxy for Airbnb/Yelp (datacenter IPs = instant block)

## Tools

| Tool | Use Case | Speed |
|------|----------|-------|
| **Camoufox** | Full browser automation, JS-heavy sites | ~3-5s/page |
| **curl_cffi** | API endpoints, no JS needed | ~100ms/request |

## Documentation

- [SKILL.md](SKILL.md) — Full usage guide with session management
- [references/proxy-setup.md](references/proxy-setup.md) — Proxy configuration
- [references/fingerprint-checks.md](references/fingerprint-checks.md) — What anti-bot systems check

## Comparison with Other Skills

This skill focuses on **doing one thing well**: C++ level stealth with Camoufox.

For CAPTCHA solving, task checkpointing, and proxy rotation, see the [GitHub issues](https://github.com/kesslerio/stealth-browser-clawhub-skill/issues) for planned features.

## License

Apache 2.0 — See [LICENSE](LICENSE)

---

Made with 🦊 by [Kessler.io](https://kessler.io)
