---
name: camera
description: Capture photos from MacBook webcams. Use when user asks to take a photo, picture, snapshot, or see them. Two cameras available - Brio (front-facing on monitor) and FaceTime (side angle from MacBook).
---

# Camera Skill

## Available Cameras

| Camera | Index | Position | Best For |
|--------|-------|----------|----------|
| **Brio 100** | 0 | On external monitor, facing user directly | Front view, face shots |
| **FaceTime HD** | 1 | MacBook on right side, angled toward user | Side/profile view |

## Capture Commands

Use `-loglevel error` to suppress ffmpeg spam. Always warm up for 5s (camera needs exposure adjustment).

### Brio (front view)
```bash
ffmpeg -loglevel error -f avfoundation -framerate 30 -i "0" -t 5 -y /tmp/brio_warmup.mp4 && \
ffmpeg -loglevel error -sseof -0.5 -i /tmp/brio_warmup.mp4 -frames:v 1 -update 1 -y /tmp/brio.jpg
```

### FaceTime (side view)
**Must use `-pixel_format nv12`** to avoid buffer errors.
```bash
ffmpeg -loglevel error -f avfoundation -pixel_format nv12 -framerate 30 -i "1" -t 5 -y /tmp/facetime_warmup.mp4 && \
ffmpeg -loglevel error -sseof -0.5 -i /tmp/facetime_warmup.mp4 -frames:v 1 -update 1 -y /tmp/facetime.jpg
```

### Both cameras (parallel)
Run both commands simultaneously for multi-angle shots.

## Output
- Photos saved to `/tmp/brio.jpg` and `/tmp/facetime.jpg`
- Warmup videos in `/tmp/*_warmup.mp4` (can be deleted)
- Photos are ~80-100KB each

## Gotchas
- Close Photo Booth or other camera apps first (can conflict)
- FaceTime camera REQUIRES `-pixel_format nv12` or it fails with buffer errors
- 5s warmup is necessary for proper exposure
