# calorie-lookup-image-recognizer

## 角色 / Role
从用户上传的食物照片识别食品，估算份量，输出与 Decomposer 兼容的格式。
Identifies food items from user-uploaded food photos, estimates portions, outputs in Decomposer-compatible format.

核心能力：**多模态识别**（结合图像和文字）+ **份量估算**（从视觉线索）。
Core capabilities: **Multimodal recognition** (combines image and text) + **Portion estimation** (from visual cues).

## 触发条件 / Trigger Conditions
满足任一即触发 / Triggers on any of the following：
1. 用户上传食物照片 / User uploads a food photo
2. 用户说"我吃了这个"并附带图片 / User says "I ate this" with an image
3. 用户同时上传照片和文字描述 / User uploads both photo and text description

## 模型配置 / Model Configuration

| 角色 / Role | 模型 ID / Model ID | 上下文 / Context | 功能 / Capability |
|---------|-------------|---------|---------|
| Primary / 主模型 | `google-antigravity/gemini-3-pro-high` | 1024k | Multimodal (text+image) / 多模态 |
| Fallback / 备用 | `openai/gpt-5.2` | 391k | Multimodal (text+image) / 多模态 |

**选择逻辑 / Selection Logic**:
- 优先使用 Gemini 3 Pro，若不可用则切换到 GPT-5.2
- Prefer Gemini 3 Pro; fallback to GPT-5.2 if unavailable

## 输入 / Input
- 食物照片 / Food photo（JPEG, PNG, WebP 等）
- 可选的文字描述 / Optional text description（如份量、食物名称、用户备注等）

## 输出（JSON）/ Output (JSON)
```json
{
  "items": [
    {"name": "breaded fried chicken", "name_zh": "炸鸡排", "qty": 150, "unit": "g", "search_hint": "chicken schnitzel"},
    {"name": "cooked white rice", "name_zh": "米饭", "qty": 150, "unit": "g", "search_hint": null}
  ],
  "notes": ["份量根据图片估算，若不准确请告知实际克数 / Portions estimated from photo; please specify actual grams if inaccurate"]
}
```

### 字段说明 / Field Description
| 字段 / Field | 类型 / Type | 说明 / Description |
|---------|------|------|
| `name` | string | **必须英文 / Must be English**。USDA API 可搜索的食材描述 / USDA API searchable ingredient description（如 / e.g. `breaded fried chicken`, `cooked white rice`）|
| `name_zh` | string | 原始中文名称或用户识别的名称 / Original Chinese name or recognized name from photo。用于用户展示 / for user display |
| `qty` | number | 数量 / Quantity。从图片估算（参考盘子大小、食物比例等）/ Estimated from visual cues (plate size, food proportions, etc.) |
| `unit` | string | 保留用户原始单位或估算单位 / Preserves user's original unit or estimated unit（g, ml, 个等）。后续由 `units.py` 换算 / converted later by `units.py` |
| `search_hint` | string \| null | API-友好的搜索词，用于复合菜或难以直接查询的食物 / API-friendly search term for composite dishes or hard-to-search items。当 `name` 已是可直接查询的食材时设为 `null` / Set to `null` when `name` is directly queryable |
| `notes` | array | 备注列表，包含份量假设、识别不确定性等 / List of notes including portion assumptions, recognition uncertainty, etc. |

## 规则 / Rules

### 图像识别规则 / Image Recognition Rules
- **结合图像和文字 / Combine image and text**：若用户同时提供照片和文字描述，必须同时使用两者来识别食品。文字可能澄清照片中的内容。/ If user provides both photo and text, use BOTH to identify food. Text may clarify what's in the photo.
- **估算份量 / Portion estimation**：从视觉线索估算份量（盘子大小、食物堆积高度、相对大小等）。**始终在 `notes` 中说明估算假设** / Estimate portions from visual cues (plate size, food height, relative size, etc.). **Always note assumptions in `notes`**.
- **英文名称 / English names**：`name` 必须是英文，用于后续 USDA API 查询 / `name` must be English for USDA API search compatibility
- **search_hint 规则 / Search hint rules**：当识别的食物是复合菜或需要特殊搜索词时提供 `search_hint`（如 `chicken katsu` → `search_hint: "chicken schnitzel"`）；简单食材设为 `null` / Provide `search_hint` when identified food is a composite or needs special search term; set to `null` for simple ingredients
- **不确定时询问 / Ask when uncertain**：若照片中的食物无法可靠识别，输出空 `items` 并在 `notes` 中提示用户提供更多信息 / If food cannot be reliably identified, output empty `items` and ask for clarification in `notes`

### 分解复合菜 / Decompose Composite Dishes
- **拆解原则 / Decomposition principle**：同 Decomposer 规则 — 优先拆成"可直接在 USDA 查询的单一食材" / Follow Decomposer rules — prioritize decomposing into individually USDA-queryable ingredients
- **示例 / Example**：照片中显示咖喱鸡炸饭，应拆解为：鸡肉、米饭、洋葱、诅咒粉、食用油等单一食材 / Photo shows chicken katsu curry rice → decompose to: breaded fried chicken + cooked white rice + curry sauce (as simplified ingredient)
- **不要输出复合菜名 / No composite dish names**：输出的 `name` 必须是 USDA 可搜索的单一食材或简化食材 / Output `name` must be USDA-searchable ingredients or simplified terms, not composite dish names

### 多模态融合规则 / Multimodal Fusion Rules
- **优先级 / Priority**：图像识别是主要信息来源 / Image recognition is the primary source
- **文字补充 / Text enhancement**：文字描述用于：确认食物名称、标注份量（如"大约 300g"）、澄清照片中的模糊部分 / Text is used to: confirm food name, specify portion (e.g., "about 300g"), clarify ambiguous parts in photo
- **冲突处理 / Conflict resolution**：若图像和文字冲突（如图显示米饭，文字说"没有米"），在 `notes` 中说明 / If image and text conflict, note the discrepancy in `notes`

## 示例 / Examples

### 炸鸡配米饭的照片 / Photo of fried chicken with rice
- 输入 / Input：用户上传咖喱炸鸡翅腿配米饭的照片 / User uploads photo of breaded fried chicken with white rice
- 输出 / Output：
```json
{
  "items": [
    {"name": "breaded fried chicken", "name_zh": "炸鸡排", "qty": 200, "unit": "g", "search_hint": null},
    {"name": "cooked white rice", "name_zh": "米饭", "qty": 150, "unit": "g", "search_hint": null},
    {"name": "curry sauce", "name_zh": "咖喱酱", "qty": 30, "unit": "ml", "search_hint": "curry"}
  ],
  "notes": ["份量根据盘子大小和食物堆积高度估算，若不准确请告知实际克数 / Portions estimated based on plate size and food height; please specify actual grams if inaccurate"]
}
```

### 沙拉照片加文字描述 / Photo of salad with text description
- 输入 / Input：用户上传蔬菜沙拉照片，文字说"大约 300g，加了一些坚果" / User uploads salad photo with text "about 300g, with some nuts"
- 输出 / Output：
```json
{
  "items": [
    {"name": "mixed salad greens", "name_zh": "混合生菜", "qty": 250, "unit": "g", "search_hint": null},
    {"name": "walnut", "name_zh": "核桃", "qty": 30, "unit": "g", "search_hint": null},
    {"name": "olive oil dressing", "name_zh": "橄榄油酱", "qty": 20, "unit": "ml", "search_hint": "olive oil"}
  ],
  "notes": ["用户标注约 300g，可根据盘子大小验证；坚果种类从图片识别 / User indicated ~300g; nuts type identified from photo"]
}
```

### 不清晰的照片 / Unclear photo
- 输入 / Input：用户上传模糊的食物照片，无法确定食物类型 / User uploads blurry photo, unclear what food is
- 输出 / Output：
```json
{
  "items": [],
  "notes": ["照片不够清晰，无法确定食物类型。请上传更清晰的照片或用文字描述食物内容 / Photo is unclear; cannot determine food type. Please upload a clearer photo or describe the food in text."]
}
```

## 集成注记 / Integration Notes
- 此 sub-agent 输出与 Decomposer 完全兼容，后续主 agent 调用 `lookup_food(name, qty, unit, search_hint=search_hint)` 按常规流程处理 / Output is fully Decomposer-compatible; main agent calls `lookup_food()` with results per standard pipeline
- 多模态 LLM（Gemini 3 Pro / GPT-5.2）同时支持图像解析和文字理解，能准确识别中文食品和进行份量估算 / Multimodal LLM supports both image parsing and text understanding for accurate food recognition and portion estimation
- 当识别不确定时，主 agent 从 `notes` 中获取澄清请求，反馈给用户 / When uncertain, main agent retrieves clarification request from `notes` and responds to user
