---
name: calorie-counter
description: Track daily calorie and protein intake, set goals, and log weight. Use when user mentions food they ate, wants to know remaining calories, or needs to track weight. Stores data in SQLite with automatic daily totals.
metadata: { "openclaw": { "emoji": "🍎", "requires": { "python": ">=3.7" } } }
---

# Calorie Counter

Simple, reliable calorie and protein tracking with SQLite database.

## Features

- **Manual Entry**: Add food with calories and protein
- **Protein Tracking**: Monitor daily protein intake
- **Daily Goals**: Set custom calorie targets
- **Weight Tracking**: Log weight in pounds
- **Instant Feedback**: See totals immediately after adding food
- **History**: View past days and trends

## Usage

### Adding Food
```bash
python scripts/calorie_tracker.py add "chicken breast" 165 31
python scripts/calorie_tracker.py add "banana" 100 1
```
Shows immediate feedback with today's totals and remaining calories.

### Viewing Today's Summary
```bash
python scripts/calorie_tracker.py summary
```
Shows:
- All entries for today
- Total calories and protein consumed
- Daily goal and remaining calories
- Progress percentage

### Setting Goals
```bash
python scripts/calorie_tracker.py goal 2000
```
Sets the daily calorie goal (persists).

### Weight Tracking
```bash
python scripts/calorie_tracker.py weight 175
python scripts/calorie_tracker.py weight-history
```
Weight is in pounds (decimals allowed: 175.5).

### Viewing History
```bash
# Last 7 days
python scripts/calorie_tracker.py history

# Last 30 days
python scripts/calorie_tracker.py history 30
```

### Deleting Entries
```bash
# List entries to get ID
python scripts/calorie_tracker.py list

# Delete by ID
python scripts/calorie_tracker.py delete 42
```

## Database

SQLite database: `calorie_data.db`

### Tables

**entries** - Food log
- id (INTEGER) - Auto-increment
- date (TEXT) - YYYY-MM-DD
- food_name (TEXT)
- calories (INTEGER)
- protein (INTEGER)
- created_at (TIMESTAMP) - Automatic

**daily_goal** - Single calorie target
- id (INTEGER) - Always 1
- calorie_goal (INTEGER)

**weight_log** - Weight tracking
- id (INTEGER) - Auto-increment
- date (TEXT) - YYYY-MM-DD
- weight_lbs (REAL) - Pounds with decimals
- created_at (TIMESTAMP) - Automatic

## Agent Instructions

**Important:** The skill is located at `workspace/calorie-counter/` in your agent's workspace. All commands should use this path prefix.

### When user mentions food:
1. Extract food name, calories, and protein (estimate if not provided)
2. Run: `python3 workspace/calorie-counter/scripts/calorie_tracker.py add "food" CALORIES PROTEIN`
3. The command outputs immediate totals (no need to run summary separately)

Example:
- User: "I had a chicken breast for lunch, about 165 calories"
- Estimate protein (chicken is ~30g per 165 cal)
- Run: `python3 workspace/calorie-counter/scripts/calorie_tracker.py add "chicken breast" 165 30`

### When user wants remaining calories:
1. Run: `python3 workspace/calorie-counter/scripts/calorie_tracker.py summary`

### When user sets a goal:
1. Run: `python3 workspace/calorie-counter/scripts/calorie_tracker.py goal CALORIES`

### When user logs weight:
1. Convert to pounds if needed (1 kg ≈ 2.205 lbs)
2. Run: `python3 workspace/calorie-counter/scripts/calorie_tracker.py weight POUNDS`

### When user wants to delete entry:
1. Run: `python3 workspace/calorie-counter/scripts/calorie_tracker.py list` to show IDs
2. Run: `python3 workspace/calorie-counter/scripts/calorie_tracker.py delete ID`

### Protein Estimation Guide
If user doesn't specify protein, estimate based on food type:
- **Lean meats** (chicken, turkey): ~0.30g per calorie
- **Fish**: ~0.25g per calorie
- **Red meat**: ~0.20g per calorie
- **Eggs**: ~0.12g per calorie (1 egg = 70 cal, 6g protein)
- **Greek yogurt**: ~0.10g per calorie
- **Nuts**: ~0.04g per calorie
- **Bread/pasta**: ~0.03g per calorie
- **Fruits**: ~0.01g per calorie or less
- **Vegetables**: ~0.02-0.04g per calorie

When uncertain, estimate conservatively or ask the user.

## Notes

- Calories and protein are integers (no decimals)
- Weight is in pounds (decimals allowed)
- Database created automatically on first use
- All times in local timezone
- Dates in YYYY-MM-DD format
- Time shown in lists is from created_at timestamp (HH:MM format)

## Example Session

```bash
# Set goal
$ python scripts/calorie_tracker.py goal 2000
✓ Set daily goal: 2000 cal

# Add breakfast
$ python scripts/calorie_tracker.py add "oatmeal" 150 5
✓ Added: oatmeal (150 cal, 5g protein)
  Entry ID: 1
  Today: 150 / 2000 cal (remaining: 1850) | Protein today: 5g | Entries: 1

# Add lunch
$ python scripts/calorie_tracker.py add "grilled chicken salad" 350 45
✓ Added: grilled chicken salad (350 cal, 45g protein)
  Entry ID: 2
  Today: 500 / 2000 cal (remaining: 1500) | Protein today: 50g | Entries: 2

# Check summary
$ python scripts/calorie_tracker.py summary
============================================================
DAILY SUMMARY - 2026-02-05
============================================================
Entries: 2
Total consumed: 500 cal | 50g protein
Daily goal: 2000 cal
Remaining: 1500 cal
  25.0% of goal consumed
============================================================

# Log weight
$ python scripts/calorie_tracker.py weight 175.5
✓ Logged weight: 175.5 lbs
```
