# Calorie Counter 🍎

Simple, reliable calorie and protein tracking for OpenClaw agents.

## Features

- **Manual calorie entry** - No unreliable nutrition APIs
- **Protein tracking** - Monitor daily protein intake
- **Weight logging** - Track weight in pounds
- **Instant feedback** - See totals immediately after adding food
- **SQLite database** - Reliable, local storage
- **History & trends** - View past days and progress

## Installation

```bash
clawhub install calorie-counter
```

Or manually clone to your workspace directory.

## Requirements

- Python 3.7+
- No external dependencies (uses only Python stdlib)

## Quick Start

### Set Your Daily Goal
```bash
python scripts/calorie_tracker.py goal 2000
```

### Add Food
```bash
python scripts/calorie_tracker.py add "chicken breast" 165 31
```

### Check Progress
```bash
python scripts/calorie_tracker.py summary
```

### Log Weight
```bash
python scripts/calorie_tracker.py weight 175
```

## Agent Usage

When installed, your agent will automatically use this skill when you mention food or ask about calories.

Example conversation:
```
You: "I just ate a turkey sandwich, about 450 calories and 30g protein"
Agent: [runs add command]
       "✓ Added - you've consumed 450 cal today, 1550 remaining"

You: "How many calories do I have left?"
Agent: [runs summary command]
       "You have 1550 calories remaining (22.5% of goal consumed)"
```

## Database

Data stored in `calorie_data.db` (SQLite):
- **entries** - Food log with calories and protein
- **daily_goal** - Your calorie target
- **weight_log** - Weight measurements in pounds

## Commands

```bash
add <food> <calories> <protein>   # Add food entry
delete <id>                       # Delete entry
list                              # List today's entries
summary                           # Show daily summary
goal <calories>                   # Set daily goal
weight <lbs>                      # Log weight
weight-history [days]             # Show weight history
history [days]                    # Show calorie history
```

## Why This Skill?

**vs. Other calorie trackers:**
- ✅ No API keys or external services
- ✅ Works offline
- ✅ Simple manual entry (you control accuracy)
- ✅ Protein tracking included
- ✅ Instant feedback on food entry
- ✅ Clean, portable SQLite storage
- ✅ No security vulnerabilities

**vs. diet-tracker skill:**
- ✅ Actually works (no broken APIs)
- ✅ Portable (no hardcoded paths)
- ✅ English language
- ✅ Secure (parameterized SQL)
- ✅ Simpler, cleaner code

## Documentation

See `SKILL.md` for full documentation and agent instructions.

## License

MIT

## Author

Built with Claude Code for OpenClaw
