# Calorie Counter - Quick Start 🍎

## Setup Complete! ✓

The skill is installed and ready. Just tell your agent about your food!

## Natural Usage Examples

### Setting Your Goal
```
"Set my daily calorie goal to 2000"
"I want to aim for 1800 calories today"
```

### Logging Food
```
"I had scrambled eggs for breakfast, about 350 calories and 25g protein"
"Just ate a banana, 100 calories"
"Had a turkey sandwich - 450 calories, probably 30g protein"
```

### Checking Progress
```
"How many calories do I have left today?"
"Show me my calorie summary"
"What's my total so far?"
```

### Deleting Mistakes
```
"Show me today's entries"
"Delete entry 5"
```

### Weight Tracking
```
"Log my weight: 175 lbs"
"I weigh 165.5 pounds this morning"
"Show me my weight history"
```

### History
```
"Show me my calorie history for the last week"
"How did I do yesterday?"
```

## Direct Commands

If you want to run commands directly:

```bash
# Set goal
python3 workspace/calorie-counter/scripts/calorie_tracker.py goal 2000

# Add food (calories and protein required)
python3 workspace/calorie-counter/scripts/calorie_tracker.py add "chicken breast" 165 31

# See summary
python3 workspace/calorie-counter/scripts/calorie_tracker.py summary

# List entries
python3 workspace/calorie-counter/scripts/calorie_tracker.py list

# Delete entry
python3 workspace/calorie-counter/scripts/calorie_tracker.py delete 5

# Log weight (pounds)
python3 workspace/calorie-counter/scripts/calorie_tracker.py weight 175.5

# View history
python3 workspace/calorie-counter/scripts/calorie_tracker.py history 7
python3 workspace/calorie-counter/scripts/calorie_tracker.py weight-history
```

## Database Location

All data stored in: `workspace/calorie-counter/calorie_data.db`

- SQLite database (human-readable with any SQLite browser)
- Auto-created on first use
- Excluded from git (.gitignore)
- Easy to backup or export

## What's Different from Other Trackers

| Feature | This Skill | Other Skills |
|---------|-----------|--------------|
| Works offline | ✅ | ❌ (API dependent) |
| Protein tracking | ✅ | ❌ |
| Instant feedback | ✅ | ❌ |
| Secure | ✅ | ⚠️ (vulnerabilities) |
| Portable | ✅ | ❌ (hardcoded paths) |
| Simple | ✅ | ❌ (complex) |

## Database Schema

**entries** (Food log)
- id, date, food_name, calories, protein, created_at

**daily_goal** (Single calorie target)
- id (always 1), calorie_goal

**weight_log** (Weight tracking)
- id, date, weight_lbs, created_at

## Tips

1. **Be specific with portions**: "small apple" vs "large apple"
2. **Protein estimates**: Agent knows common foods, but you can specify
3. **Log weight consistently**: Same time daily (e.g., morning) for accuracy
4. **Set realistic goals**: Use TDEE calculators online for your baseline

## Protein Quick Reference

If you forget protein amounts:
- Chicken breast (4oz): 165 cal, 31g protein
- Egg (1 large): 70 cal, 6g protein
- Greek yogurt (1 cup): 100 cal, 10g protein
- Banana: 100 cal, 1g protein
- Oatmeal (1 cup): 150 cal, 5g protein

## Troubleshooting

If something doesn't work:
```bash
# Check if skill exists
ls -la workspace/calorie-counter/

# Run a test command
python3 workspace/calorie-counter/scripts/calorie_tracker.py summary

# Check the database
sqlite3 workspace/calorie-counter/calorie_data.db ".tables"

# Full documentation
cat workspace/calorie-counter/SKILL.md
```

## Example Day

```
Morning:
> "Set my goal to 2000 calories"
> "I had oatmeal with banana, 250 cal and 6g protein"
  → Shows: 250/2000 cal, 1750 remaining

Lunch:
> "Turkey sandwich, 450 calories, 30g protein"
  → Shows: 700/2000 cal, 1300 remaining

Afternoon:
> "How am I doing?"
  → Shows full summary

Evening:
> "Grilled salmon with rice, 600 cal, 45g protein"
  → Shows: 1300/2000 cal, 700 remaining

Before bed:
> "Log my weight: 175 lbs"
  → Recorded
```

Enjoy tracking! 🎯
