# Call Scripts — Call Center

## Inbound Support Script

### Opening
```
"Thank you for calling [Company], this is [Name]. How can I help you today?"
```

### Verification (if account-related)
```
"For security, may I have your [account number / email / last 4 of phone]?"
```

### Issue Capture
- Listen without interrupting
- Take notes on key points
- Paraphrase: "So if I understand correctly, [issue]. Is that right?"

### Troubleshooting Flow
1. Check known issues list first
2. Try standard resolution steps
3. If unresolved after 2 attempts, consider escalation
4. Document each step tried

### Resolution Confirmation
```
"I've [action taken]. Can you confirm that resolves your issue?"
```

### Closing
```
"Your reference number is [XXX]. Is there anything else I can help with today?
Thank you for calling [Company]. Have a great day."
```

---

## Outbound Sales Script

### Opening
```
"Hi, this is [Name] from [Company]. Am I speaking with [Customer Name]?
I'm calling about [reason]. Do you have a moment?"
```

### Qualification Questions
- Current situation: "How are you currently handling [X]?"
- Pain points: "What challenges do you face with [X]?"
- Decision: "Who else would be involved in a decision like this?"

### Value Presentation
- Lead with benefit, not feature
- Use specific numbers when possible
- Reference similar customers

### Objection Handling
| Objection | Response |
|-----------|----------|
| "Too expensive" | "I understand budget is important. Let me show you the ROI..." |
| "Not now" | "When would be a better time? I can schedule a follow-up." |
| "Using competitor" | "Many of our customers switched from [X]. What made you choose them?" |
| "Need to think" | "Of course. What specific questions can I answer to help your decision?" |

### Close or Next Step
```
"Based on what you've shared, [product/plan] would be the best fit.
Would you like to move forward today, or should we schedule a follow-up?"
```

---

## Complaint Handling Script

### Acknowledge and Apologize
```
"I'm sorry to hear about this experience. I understand how frustrating that must be."
```

### Investigate
- Ask clarifying questions calmly
- Never blame customer or colleague
- Take ownership: "Let me see what I can do"

### Resolve or Escalate
| Situation | Action |
|-----------|--------|
| Within authority | Resolve and confirm |
| Outside authority | "I want to get this resolved properly. Let me connect you with [X]" |
| Unreasonable demand | "I understand what you're asking. Here's what I'm able to offer..." |

### Document
- Full timeline of issue
- Customer's exact request
- Resolution or escalation details
- Any commitments made

---

## Difficult Caller Techniques

### Angry Caller
- Lower your voice (they often mirror)
- Use caller's name
- Focus on solution, not blame
- "I can hear this is frustrating. Let's fix this together."

### Rambling Caller
- Wait for pause
- Summarize: "So the main issue is [X], correct?"
- Redirect: "Let me focus on [X] first"

### Threatening Caller
- Stay calm and professional
- Document exact words used
- "I want to help, but I'm not able to continue if [behavior continues]"
- Escalate to supervisor immediately if threats persist

### Silent Caller
- "Are you still there?"
- "I want to make sure I can help you. What's the best way to proceed?"
- Wait 10 seconds, then offer to call back
