# Escalation Guide — Call Center

## When to Escalate

### Immediate Escalation (No Delay)
- Caller explicitly requests supervisor
- Legal threats or mentions of lawyer
- Media or public exposure threats
- Safety concerns (self-harm, violence)
- Fraud detection
- Regulatory compliance issues

### Standard Escalation (After Reasonable Attempt)
- Issue outside agent authority
- 3+ failed resolution attempts
- Technical issue beyond troubleshooting scope
- Refund or credit above agent limit
- Policy exception needed

### Warm Transfer vs Cold Transfer

| Type | When | How |
|------|------|-----|
| Warm | Preferred default | Brief supervisor on issue BEFORE connecting |
| Cold | Caller insists on immediate transfer | Transfer with notes, apologize for not briefing |

---

## Escalation Process

### Step 1: Acknowledge
```
"I understand this needs additional attention. Let me get someone who can help."
```

### Step 2: Document (Before Transfer)
- Caller name and contact
- Issue summary (1-2 sentences)
- Steps already attempted
- What caller is requesting
- Caller mood (calm, frustrated, angry)

### Step 3: Brief Supervisor
```
"I have [Caller] on the line regarding [issue].
I've tried [steps]. They're requesting [X].
Caller is [mood level]."
```

### Step 4: Warm Transfer
```
"[Caller], I'm connecting you with [Name/Title] who can help with this.
I've briefed them on your situation. One moment please."
```

### Step 5: Log Escalation
- Record in escalations.md
- Note outcome when resolved

---

## Escalation Tiers

### Tier 1: Supervisor
- Customer insistence
- Refunds $50-200
- Standard policy exceptions
- Coaching moments

### Tier 2: Department Manager
- Refunds $200-1000
- Complex multi-department issues
- Repeated escalations from same customer
- Process failures

### Tier 3: Director/VP
- Refunds >$1000
- Legal involvement
- Media exposure
- Systemic failures

### Tier 4: Legal/Compliance
- Actual legal threats with attorney involvement
- Regulatory complaints
- Data breach concerns
- Discrimination claims

---

## De-escalation Before Escalating

Try these before escalating an angry caller:

### HEAT Method
- **H**ear them out completely
- **E**mpathize with their frustration
- **A**pologize for the experience (not blame)
- **T**ake action or explain what you CAN do

### Power Phrases
- "I hear you, and I want to fix this"
- "You're right to be frustrated"
- "Here's what I can do right now"
- "Let me take ownership of this"

### What to Avoid
- "That's policy" (without explanation)
- "There's nothing I can do"
- "You need to calm down"
- Defensive or argumentative tone

---

## After Escalation

### If Resolved by Supervisor
- Log resolution in memory
- Note if pattern indicates training need

### If Unresolved
- Follow up timeline documented
- Clear owner assigned
- Customer informed of next steps

### Pattern Recognition
Review escalations weekly for:
- Same issue escalating repeatedly → Process fix needed
- Same customer escalating → VIP handling or service recovery
- Same agent escalating → Training opportunity
