---
name: calendar-reminders
description: Calendar reminders pipeline: config-driven wrapper around gcalcli (Google Calendar) plus optional CalDAV source via vdirsyncer+khal, and a reminder planner that outputs a JSON plan for one-shot OpenClaw reminders.
---

# gcalcli calendar wrapper + reminder planner

This skill provides:
- `scripts/calendar` — wrapper around `gcalcli`
- `scripts/calendar_reminder_plan.py` — produces a JSON plan for reminder scheduling
- `references/openclaw-calendar.example.json` — example config format

## Config

Copy the example config to a private location and edit it:

- Default path: `~/.config/openclaw/calendar.json`
- Override with env: `OPENCLAW_CALENDAR_CONFIG=/path/to/calendar.json`

## Requirements

- Required: `python3`, `gcalcli`
- Optional (for CalDAV/iCloud): `vdirsyncer`, `khal`

## Security notes (why ClawHub may flag this)

This skill *invokes external binaries* and is config-driven.

- The planner runs `gcalcli`/`khal` using `subprocess.check_output([...], shell=False)` (argument-list form; safe against shell injection from event titles).
- If you wire a cron job to run `vdirsyncerSyncCommand`, make sure you run it as an **argv list** (`subprocess.run(cmd_list, shell=False)`), not as a shell string.
- Only point `gcalcliPath` / `khalBin` to **trusted binaries** (prefer absolute paths). Don’t run untrusted paths.

## Auth (Google)

`gcalcli` requires OAuth. On headless servers you may need SSH port-forwarding.
The wrapper uses `--noauth_local_server` to print instructions.

## Reminder planning

The planner outputs a JSON blob describing reminders to schedule. A separate cron job
(or an agent turn) can read it and create one-shot OpenClaw reminders.

Defaults:
- Ignore birthdays.
- Timed events are considered important.
- All-day events only trigger reminders if their title matches configured keywords.

## Wiring a daily reminder scheduler (OpenClaw)

Create a daily cron job (e.g. 00:05 local time) that:

1) If CalDAV is enabled in config, runs the configured `vdirsyncer` sync command.
2) Runs `scripts/calendar_reminder_plan.py` to get a JSON plan.
3) For each planned reminder, creates a one-shot OpenClaw `systemEvent` reminder at `reminderAtUtc`.
4) Writes a small state file so you don’t schedule duplicates.

(Our skill intentionally provides the wrapper + planner; scheduling is left to your cron/agent wiring.)
