---
name: caldav-cli
description: Manage CalDAV calendars (iCloud, Google, Yandex) from the command line. Supports OAuth2 and Basic auth, multi-account, table/JSON output.
metadata: {"clawdbot":{"emoji":"📅","os":["linux","macos"],"requires":{"bins":["caldav-cli","node"],"configs":["~/.config/caldav-cli/config.json"],"keychain":true},"install":[{"id":"npm","kind":"shell","command":"npm install -g caldav-cli","bins":["caldav-cli"],"label":"Install caldav-cli via npm"}],"source":"https://github.com/cyberash-dev/caldav-cli"}}
---

# caldav-cli

A CalDAV CLI client. Manages multiple accounts with secure OS keychain storage. Supports iCloud, Google (OAuth2), Yandex and any custom CalDAV server.

## Installation

Requires Node.js >= 18.

```bash
npm install -g caldav-cli
```

After installation the `caldav-cli` command is available globally.

## Quick Start

```bash
caldav-cli account add          # Interactive wizard: pick provider, enter credentials
caldav-cli events list          # Show events for the next 7 days
caldav-cli events create        # Interactive wizard: create a new event
```

## Account Management

Add account (interactive wizard — prompts for provider, credentials, tests connection):
```bash
caldav-cli account add
```

List configured accounts:
```bash
caldav-cli account list
```

Remove an account:
```bash
caldav-cli account remove <name>
```

## View Events

```bash
caldav-cli events list                           # Next 7 days (default)
caldav-cli events list --from 2026-02-10 --to 2026-02-20
caldav-cli events list -a work                   # Specific account
caldav-cli events list -c "Team Calendar"        # Filter by calendar name
caldav-cli events list -a work -c Personal --from 2026-03-01 --to 2026-03-31
```

JSON output (for scripting):
```bash
caldav-cli events list --json
caldav-cli events list --json --from 2026-02-10 --to 2026-02-20
```

## Create Events

Interactive wizard (prompts for all fields):
```bash
caldav-cli events create
```

Non-interactive (all options via flags):
```bash
caldav-cli events create \
  --title "Team standup" \
  --start "2026-02-10T10:00" \
  --end "2026-02-10T10:30" \
  --account work \
  --calendar "Team Calendar" \
  --description "Daily sync" \
  --location "Room 42"
```

Partial flags (wizard prompts for the rest):
```bash
caldav-cli events create --title "Lunch" --account work
```

JSON output after creation:
```bash
caldav-cli events create --json --title "Event" --start "2026-02-10T10:00" --end "2026-02-10T11:00"
```

## Supported Providers

| Provider | Auth | Server URL |
|----------|------|------------|
| Apple iCloud | Basic (app-specific password) | `https://caldav.icloud.com` |
| Google Calendar | OAuth2 (Client ID + Secret) | `https://apidata.googleusercontent.com/caldav/v2` |
| Yandex Calendar | Basic (app password) | `https://caldav.yandex.ru` |
| Custom | Basic | User provides URL |

## Google Calendar Setup

Google requires OAuth2. Before running `caldav-cli account add`:

1. Go to https://console.cloud.google.com/
2. Create a project, enable CalDAV API
3. Create OAuth client ID (Desktop app type)
4. Note the Client ID and Client Secret

The wizard will ask for these, then open a browser for authorization. The refresh token is stored securely in the OS keychain.

## Data Storage

- **Passwords, OAuth2 refresh tokens, and OAuth2 client credentials** (Client ID, Client Secret, Token URL): OS keychain (macOS Keychain, Linux libsecret, Windows Credential Vault) via `@napi-rs/keyring`. Never written to disk in plaintext.
- **Account metadata** (name, provider ID, username, server URL): `~/.config/caldav-cli/config.json` (file permissions `0600`).

No secrets are stored on disk. Existing installations that stored OAuth2 client credentials in `config.json` are automatically migrated to the keychain on first run.

## Flag Reference

### `events list`
| Flag | Short | Description | Default |
|------|-------|-------------|---------|
| `--account <name>` | `-a` | Account name | default account |
| `--from <date>` | | Start date (YYYY-MM-DD) | today |
| `--to <date>` | | End date (YYYY-MM-DD) | today + 7 days |
| `--calendar <name>` | `-c` | Filter by calendar name | all calendars |
| `--json` | | Output as JSON | false |

### `events create`
| Flag | Short | Description |
|------|-------|-------------|
| `--title <title>` | `-t` | Event title |
| `--start <datetime>` | `-s` | Start (YYYY-MM-DDTHH:mm) |
| `--end <datetime>` | `-e` | End (YYYY-MM-DDTHH:mm) |
| `--account <name>` | `-a` | Account name |
| `--calendar <name>` | `-c` | Calendar name |
| `--description <text>` | `-d` | Event description |
| `--location <text>` | `-l` | Event location |
| `--json` | | Output as JSON |

All `events create` flags are optional. Omitted values trigger interactive prompts.
