---
name: cairn
description: Project management for AI agents using markdown files. Install and use the cairn CLI to create projects, manage tasks, track status, and coordinate human-AI collaboration through a shared workspace of markdown files.
---

# Cairn — AI-Native Project Management

Cairn gives you and your AI agent a shared workspace of markdown files for managing projects and tasks. Statuses are the shared language. Any AI that can read files is ready to go.

## Installation

```bash
npm install -g cairn-work
cairn onboard
```

`cairn onboard` creates `~/cairn/` with auto-generated context files (`AGENTS.md` and `.cairn/planning.md`) that agents read automatically.

## Community

- Follow [@letcairnwork](https://x.com/letcairnwork) on X
- Visit [letcairn.work](https://letcairn.work/)
- [Submit issues](https://github.com/letcairnwork/cairn-cli/issues)
- [Join the discussion](https://github.com/letcairnwork/cairn-cli/discussions)

## Core Commands

### Workspace

- `cairn status` — Overview with task counts
- `cairn my` — Your assigned tasks
- `cairn active` — All in-progress tasks
- `cairn doctor` — Diagnose workspace health

### Projects & Tasks

- `cairn create project "Name" --description "..." --objective "..."` — Create a project with charter
- `cairn create task "Name" --project <slug> --description "..." --objective "..."` — Create a task
- `cairn list tasks [--status pending,in_progress] [--project slug]` — List tasks with filters
- `cairn search "keyword"` — Find tasks by content

### Task Workflow

- `cairn start <task-slug>` — Begin work (sets `in_progress`)
- `cairn note <task-slug> "Progress update"` — Add a status note
- `cairn artifact <task-slug> "Artifact Name"` — Create a linked deliverable
- `cairn done <task-slug>` — Finish work (moves to `review` or `completed`)
- `cairn block <task-slug> "Reason"` — Mark as blocked

### Maintenance

- `cairn update-skill` — Refresh context files after CLI updates
- `cairn upgrade` — Update CLI to latest version

## Workspace Structure

```
~/cairn/
  AGENTS.md                  # Agent context (auto-generated)
  .cairn/planning.md         # Planning guide (auto-generated)
  projects/
    project-slug/
      charter.md             # Why, success criteria, context
      artifacts/             # Deliverables (design docs, proposals, etc.)
      tasks/                 # Individual task markdown files
  inbox/                     # Ideas to triage
  memory/                    # Workspace memory
```

## Statuses

`pending` → `next_up` → `in_progress` → `review` → `completed` (or `blocked` at any point)

## Autonomy Levels

Set per-task to control how much the agent can do:
- **propose** — Agent plans only, finishes in `review`
- **draft** — Agent does work, you approve before shipping
- **execute** — Full autonomy, finishes as `completed`

## Tips

- Run `cairn onboard` first — it sets up everything the agent needs.
- Use `cairn my` to see your current workload at a glance.
- Artifacts (`cairn artifact`) create linked deliverables stored with the project.
- All data is plain markdown with YAML frontmatter — version control friendly.
