---
name: cabin
description: Search and book real flights with USDC payments. Gives your AI agent the power to find flights across 500+ airlines and complete bookings paid in USDC on Base. No credit cards, no banks — crypto-native travel commerce.
metadata: {"clawdbot":{"emoji":"✈️","homepage":"https://github.com/yolo-maxi/cabin","requires":{"bins":["node"]}}}
---

# Cabin — Flight Search & Booking with USDC

Search real flights across 500+ airlines and book with USDC on Base.

## API Base URL

`https://api.cabin.team`

## Endpoints

### Search Flights

When the user wants to find flights:

```bash
curl -X POST https://api.cabin.team/v1/search \
  -H "Content-Type: application/json" \
  -d '{
    "from": "HAN",
    "to": "ATH",
    "date": "2026-03-15",
    "return_date": "2026-03-22",
    "adults": 1,
    "class": "ECONOMY",
    "currency": "USD",
    "max_results": 5
  }'
```

**Parameters:**
- `from` (required): Origin IATA airport code
- `to` (required): Destination IATA airport code
- `date` (required): Departure date (YYYY-MM-DD)
- `return_date` (optional): Return date for round-trip
- `adults` (optional, default 1): Number of passengers
- `class` (optional): ECONOMY, PREMIUM_ECONOMY, BUSINESS, FIRST
- `currency` (optional, default USD): Currency for prices
- `max_results` (optional, default 10): Maximum results

**Response includes:**
- `results[]` — Array of flight offers with prices, airlines, times, stops
- `image_url` — URL to a rendered PNG comparison image of results
- `search_id` — ID to reference when booking

**Presenting results to users:**
- Show the rendered image (fetch from image_url) for visual comparison
- Use structured data for specific questions ("which is cheapest?", "any direct flights?")
- Always show price in both USD and USDC equivalent

### Book a Flight

When the user wants to book:

```bash
curl -X POST https://api.cabin.team/v1/book \
  -H "Content-Type: application/json" \
  -d '{
    "offer_id": "offer_1",
    "search_id": "abc123",
    "passengers": [{
      "type": "adult",
      "given_name": "John",
      "family_name": "Doe",
      "email": "john@example.com",
      "born_on": "1990-01-15",
      "gender": "m"
    }]
  }'
```

**Required passenger info:**
- given_name, family_name
- email
- born_on (YYYY-MM-DD)
- gender (m/f)

**Response includes:**
- `booking_id` — Cabin booking reference (CBN-YYYY-XXXX)
- `amount_usdc` — Amount to pay in USDC
- `payment.deposit_address` — USDC deposit address on Base
- `payment.checkout_url` — Payment page URL to share with user

### USDC Payment Flow

After booking, the user needs to pay in USDC on Base:

1. Show the user the `amount_usdc` and `payment.checkout_url`
2. User can either:
   a. Send USDC directly to `payment.deposit_address` on Base
   b. Visit `checkout_url` for a guided payment experience
3. After payment, booking is confirmed automatically

**If the agent has wallet capabilities (e.g., evm-wallet skill):**
```bash
# Check USDC balance on Base
node src/balance.js base --json

# Send USDC to deposit address
node src/send.js base USDC <deposit_address> <amount_usdc> --yes --json
```

### Check Booking Status

```bash
curl https://api.cabin.team/v1/booking/CBN-2026-XXXX
```

**Statuses:** awaiting_payment → confirmed → checked_in

### Get Confirmation Page
```
https://api.cabin.team/v1/booking/CBN-2026-XXXX/confirmation
```
Share this URL with the user after payment confirmation.

### Get Check-in Page
```
https://api.cabin.team/v1/booking/CBN-2026-XXXX/checkin
```
Share when it's time to check in for the flight.

## Common IATA Codes

| Code | City |
|------|------|
| HAN | Hanoi |
| BKK | Bangkok |
| SIN | Singapore |
| NRT | Tokyo Narita |
| HND | Tokyo Haneda |
| ICN | Seoul |
| LHR | London |
| CDG | Paris |
| FCO | Rome |
| ATH | Athens |
| JFK | New York |
| LAX | Los Angeles |
| SFO | San Francisco |
| DXB | Dubai |
| IST | Istanbul |

## Workflow Examples

### Simple one-way search
User: "Find me a flight from Bangkok to Tokyo next Friday"
1. Parse: from=BKK, to=NRT (or HND), date=next Friday
2. Call POST /v1/search
3. Show image_url to user
4. Present top 3-5 options with prices

### Round-trip booking
User: "Book the cheapest round-trip from London to Barcelona, March 15-22"
1. Search: from=LHR, to=BCN, date=2026-03-15, return_date=2026-03-22
2. Present options
3. User picks one → collect passenger details
4. POST /v1/book with passenger info
5. Share payment URL → user pays in USDC
6. Confirm booking → share confirmation page

### Multi-passenger
User: "We need flights for 3 people, Seoul to Bali, April 1-10"
1. Search with adults=3
2. Prices shown are per-person
3. When booking, collect details for all 3 passengers
4. Total USDC amount = per-person × 3

## Error Handling
- **No results**: Try nearby airports or different dates
- **Booking expired**: Search results expire after 30 minutes, search again
- **Payment timeout**: Bookings expire 1 hour after creation if unpaid
- **Invalid airport code**: Suggest the correct IATA code

## USDC on Base
- Chain: Base (Ethereum L2)
- Token: USDC (0x833589fCD6eDb6E08f4c7C32D4f71b54bdA02913)
- Gas fees: ~$0.01 per transaction
- Confirmation: ~2 seconds
