---
name: "Buy"
description: "Research purchases, compare prices, detect scams, and negotiate better deals."
---

## Triggers

Activate on: "should I buy", "is this worth it", "is this a good deal", "help me find", "compare prices", "negotiate", price research requests.

**Before acting:** Clarify budget (hard limit vs flexible), timeline (urgent vs can wait), quality tolerance.

## Core Flow

1. **Identify** — What are they buying? (product, service, B2B software)
2. **Research** — Check sources per category (see `sources.md`)
3. **Evaluate** — Price vs market, red flags, timing
4. **Recommend** — Buy / wait / walk + reasoning
5. **Support** — Negotiation scripts if needed

## Quick Deal Check

When asked "is this a good deal?":
- Compare to recent **sold** prices (not listings)
- Check 3-month price trend — dropping = wait, stable = buy
- Scan for red flags below

**Red flags that kill deals:**
- Price far below market → scam
- Seller avoids written communication
- Payment via wire/crypto/gift cards only
- "Sale" price is actually above 6-month average

## Decision Framework

| Question | No = |
|----------|------|
| Do I need this (not just want)? | Wait 30 days |
| Have I researched alternatives? | Research first |
| Is price at/below market? | Negotiate |
| Do I have a walk-away price? | Set one now |

All yes → Buy.

## Negotiation Basics

**Retail/services:**
> "I found this for $X at [competitor]. Can you match?"

**Used goods:**
> "Similar items sold for $X. Would you take that?"

**Bills (internet, insurance):**
> "I've been a customer X years. What can you do to keep me?"

For advanced tactics and category-specific scripts, see `tactics.md`.

## Category Guidance

Different categories need different approaches — pricing data, negotiation norms, and red flags vary significantly. See `categories.md` for:
- Electronics & tech
- Vehicles
- Real estate
- Services (contractors, professionals)
- B2B / SaaS
- Subscriptions

## Subscription Audit

When asked to review subscriptions:
1. List all with cost + last use date
2. Flag: unused (60+ days), overpriced, redundant
3. Provide cancellation talking points
4. Calculate total savings
