# Validation Frameworks — Business Strategy

## The Mom Test

Questions that get honest answers, not polite lies.

### Bad Questions (Get Lies)
- "Would you use this?" → Always yes, means nothing
- "Do you think it's a good idea?" → Compliments, not data
- "How much would you pay?" → Hypothetical, worthless

### Good Questions (Get Truth)
- "Tell me about the last time you had [problem]"
- "What have you tried to solve it?"
- "What did that cost you?" (time, money, frustration)
- "How are you dealing with it now?"
- "What would have to be true for you to switch?"

### Rule
If they haven't done anything about the problem, it's not a real problem.

---

## Jobs To Be Done

People "hire" products to do a job.

### Framework
```
When [situation],
I want to [motivation],
so I can [expected outcome].
```

### Example
```
When I'm onboarding a new client,
I want to send a professional proposal quickly,
so I can close the deal before they go cold.
```

### Discovery Questions
1. What were you trying to accomplish?
2. What was the trigger that made you look for a solution?
3. What alternatives did you consider?
4. Why did you choose this one?
5. What would make you switch?

---

## Lean Canvas

One-page business model. Fill in order:

```
┌─────────────────┬─────────────────┬─────────────────┐
│ 2. PROBLEM      │ 4. SOLUTION     │ 3. UVP          │
│ Top 3 problems  │ Top 3 features  │ Single, clear   │
│                 │                 │ message         │
├─────────────────┼─────────────────┼─────────────────┤
│ 8. KEY METRICS  │ 1. CUSTOMER     │ 5. CHANNELS     │
│ Key numbers     │ SEGMENTS        │ Path to         │
│ to track        │ Target users    │ customers       │
├─────────────────┼─────────────────┼─────────────────┤
│ 7. COST         │                 │ 6. REVENUE      │
│ STRUCTURE       │                 │ STREAMS         │
│ Fixed + variable│                 │ How you make $  │
└─────────────────┴─────────────────┴─────────────────┘
```

**Order of filling:**
1. Customer Segments (who)
2. Problem (their pain)
3. Unique Value Proposition (why you)
4. Solution (how you solve it)
5. Channels (how you reach them)
6. Revenue Streams (how you make money)
7. Cost Structure (what it costs you)
8. Key Metrics (how you measure success)

---

## Market Sizing

TAM → SAM → SOM (top-down) is usually fiction. Use bottom-up instead.

### Bottom-Up Sizing
```
Customers I can actually reach:        ___
× Realistic conversion rate:           ___% 
× Price per customer:                  $___
= First-year revenue ceiling:          $___
```

### Sanity Check
- Can you name 100 potential customers? (If no, market is hypothetical)
- Can you reach them in 6 months? (If no, timeline is wrong)
- Do they have budget for your price? (If no, pricing is wrong)

---

## Unit Economics

### Core Formula
```
LTV > 3× CAC

Where:
LTV = (ARPU × Gross Margin) / Churn Rate
CAC = Sales & Marketing Spend / New Customers
```

### Example
```
ARPU:         $50/mo
Gross Margin: 80%
Churn:        5%/mo

LTV = ($50 × 0.80) / 0.05 = $800

If CAC = $200:
LTV/CAC = 4× ✓ Healthy

If CAC = $400:
LTV/CAC = 2× ✗ Unprofitable without change
```

### Levers
- Increase LTV: raise prices, reduce churn, upsell
- Decrease CAC: better targeting, referrals, content marketing

---

## Competitive Analysis

### 4 Levels of Competition

1. **Direct:** Same solution, same customer (Slack vs Teams)
2. **Indirect:** Different solution, same problem (email vs Slack)
3. **Alternative:** Customer's current behavior (spreadsheets, manual)
4. **Do nothing:** Apathy, inertia, status quo

### Analysis Grid
```
| Competitor | Strengths | Weaknesses | Their Customer | Why They Win |
|------------|-----------|------------|----------------|--------------|
| A          |           |            |                |              |
| B          |           |            |                |              |
| Status quo |           |            |                |              |
```

### Positioning
Where can you be 10× better (not 2× better)?
- Speed
- Price
- Simplicity
- Niche focus
- Integration
- Experience

---

## Pricing Framework

### Pricing Thermometer
```
Too cheap ←─────────────────────────→ Too expensive
          └── Sweet spot: 10-30% say "too expensive"
```

If no one complains about price: you're too cheap.
If everyone complains: you're too expensive.

### Van Westendorp Questions
Ask potential customers:
1. At what price would this be too cheap (quality concern)?
2. At what price would this be a bargain?
3. At what price would this be expensive but acceptable?
4. At what price would this be too expensive (never buy)?

Plot answers to find acceptable range.

### Starting Point
- B2C: Price anchored to time saved (value of 1 hour × hours saved)
- B2B: Price anchored to revenue generated or cost saved (10-20% of value)

---

## Prioritization: ICE Score

For feature/initiative prioritization:

```
ICE = Impact × Confidence × Ease

Impact (1-10):     How much will this move the needle?
Confidence (1-10): How sure are we about impact?
Ease (1-10):       How easy to implement?

Score = I × C × E (max 1000)
```

### Example
| Initiative | Impact | Confidence | Ease | ICE Score |
|------------|--------|------------|------|-----------|
| Referral program | 8 | 6 | 7 | 336 |
| New feature X | 9 | 3 | 4 | 108 |
| Landing page AB | 5 | 8 | 9 | 360 |

Do landing page AB test first (highest ICE).

---

## Go/No-Go Checklist

Before major investment (launch, hire, raise), verify:

### Must-Haves (all must be YES)
- [ ] Problem validated with real customers (not friends/family)
- [ ] At least 1 person has paid or committed to pay
- [ ] You know specifically how to reach more customers
- [ ] Unit economics work on paper (LTV > 3× CAC)

### Red Flags (any NO = pause)
- [ ] You can explain the business in one sentence
- [ ] You know why people would choose you over status quo
- [ ] You have resources for 6 months runway minimum
- [ ] You're solving a problem you understand deeply

### Yellow Flags (acknowledge and plan)
- [ ] You've talked to customers in last 30 days
- [ ] You know your top 3 risks
- [ ] You have a plan for when things go wrong
