---
name: business-plan
description: Write, structure, and update a business plan for a solopreneur. Use when creating a plan from scratch, updating an existing plan after a pivot or new phase, or preparing a plan to share with investors, partners, or even just to clarify your own strategy. Covers executive summary, market analysis, competitive positioning, revenue model, operations plan, financial projections, and risk assessment — all adapted for a one-person business. Trigger on "write a business plan", "business plan", "create my plan", "business plan template", "update my business plan", "plan for my business", "investor pitch plan".
---

# Business Plan

## Overview
A business plan is not a static document you write once and file away. For solopreneurs, it is a living strategy document — a forcing function that makes you think clearly about your business and a reference you update as reality proves or disproves your assumptions. This playbook builds it section by section, in the order that makes each section easier to write because the previous one is already done.

---

## Section 1: Executive Summary (Write This LAST)

Even though it appears first, write this after everything else is done. It is a 1-page distillation of the entire plan.

**Include exactly these five elements:**
1. What the business does (one sentence)
2. The problem it solves and for whom (two sentences max)
3. The solution and why it's different (two sentences)
4. The market opportunity (one sentence with a number — market size)
5. What you need / what you're asking for (one sentence — funding amount, partnership, or simply your own plan of action)

**Rule:** If someone reads only the executive summary, they should understand the entire business. If they want details, the rest of the plan delivers them.

---

## Section 2: Company Overview

Brief, factual, no fluff.

- Business name and legal structure (sole proprietorship, LLC, etc. — or planned structure)
- What stage you're at: Idea / Pre-revenue / Early revenue / Growing
- Mission statement (pull from your brand foundations)
- Location and operational model (remote, local, hybrid)
- Founding date or planned launch date

---

## Section 3: Problem and Solution

This is the heart of the plan. If this section is weak, everything after it is built on sand.

**3.1 The Problem**
- Describe the specific problem with concrete detail. Who feels it? When? How often? What does it cost them (time, money, stress)?
- Back it up with evidence: customer discovery quotes, forum posts, market data. Not just your opinion.
- Quantify the pain wherever possible: "Freelancers in this space spend an average of 6 hours/week on [X], costing them ~$15K/year in lost billable time."

**3.2 The Solution**
- Describe what your product or service does. Be specific about the user experience — not just features, but what happens from the customer's perspective.
- Explain the "before and after." Before: the painful status quo. After: what life looks like with your solution.
- Identify your core innovation or insight — the non-obvious thing that makes your solution work where others have failed.

**3.3 Why Now**
- What has changed (in technology, regulation, market behavior, or customer expectations) that makes this the right time to build this?
- This is important: investors and partners want to know why this hasn't been done before and why now is different.

---

## Section 4: Market Analysis

Pull directly from your market-research skill output. Summarize into:

- **Market size:** TAM, SAM, SOM with sources and methodology
- **Market trends:** Top 3 trends affecting this space and how they impact your opportunity
- **Customer segments:** Your 1-2 primary personas with key characteristics
- **Target segment size:** How many of your specific target customers exist and how reachable they are

**Keep this section data-driven.** Every claim should have a source or a clear methodology behind it.

---

## Section 5: Competitive Landscape

Pull from your competitive-analysis skill output. Include:

- A comparison matrix of top 3-5 competitors across the dimensions that matter most
- Your competitive wedge — the specific position you occupy that competitors don't
- Table stakes you match (things you must do as well as everyone else)
- Gaps you fill (things competitors miss that you solve)
- Honest assessment of competitor strengths — pretending they're weak makes your plan less credible, not more

---

## Section 6: Business and Revenue Model

Pull from your business-model-canvas output. Translate into narrative form:

- How customers find you (channels and acquisition strategy)
- How they buy (sales flow: discovery → evaluation → purchase)
- Revenue streams (what you charge, how, and at what price points)
- Revenue projections for Year 1 (monthly) and Years 2-3 (quarterly). Be conservative. Use bottom-up math: "If I acquire X customers per month at Y price, revenue = Z."
- Unit economics: CAC, LTV, payback period (even if estimated)

---

## Section 7: Operations Plan

How does the business actually run day-to-day?

- **Product/service delivery:** What does fulfillment look like? How does a customer go from purchase to outcome?
- **Technology stack:** What tools, platforms, or infrastructure do you use or plan to use?
- **Key processes:** The 3-5 recurring processes that keep the business running (e.g., onboarding new customers, generating invoices, publishing content)
- **Automation plan:** Which of these processes can be automated, and with what tools?
- **Outsourcing plan:** Which tasks will you eventually delegate, and what's the trigger (revenue level, time constraint)?

---

## Section 8: Marketing and Sales Plan

- **Positioning:** Your positioning statement (from positioning-strategy)
- **Marketing channels:** Which 2-3 channels you'll focus on first and why
- **Content strategy:** What content you'll create and how often
- **Sales approach:** How you close deals — direct outreach, inbound, self-serve checkout, etc.
- **Customer acquisition targets:** How many customers you need per month to hit revenue goals
- **Customer acquisition cost budget:** How much you'll spend per acquired customer

---

## Section 9: Financial Projections

Build a simple but honest financial model:

**Monthly for Year 1, quarterly for Years 2-3:**
- Revenue (customers × price)
- Cost of goods / delivery
- Marketing spend
- Tools and infrastructure costs
- Contractor costs (if any)
- Gross profit
- Net profit (or loss)

**Key thresholds to calculate:**
- Break-even point: What revenue level covers all costs?
- Runway: If you're investing personal savings, how many months can you sustain at current burn before hitting break-even?
- Cash flow timing: Are there months where expenses spike (launch, seasonal)?

**Honesty rule:** Projections are guesses. Label them as such. Include a "conservative" and an "optimistic" scenario. The conservative scenario should still be a viable business.

---

## Section 10: Risk Assessment

Every business has risks. Identifying them doesn't make them go away — it lets you plan around them.

**For each risk, write:**
1. What the risk is
2. How likely it is (Low / Medium / High)
3. How bad it would be if it happened (Low / Medium / High)
4. Your mitigation plan (what you'll do to reduce probability or impact)

**Common solopreneur risks to cover:**
- Single-person dependency (you get sick, burn out, or want to take time off)
- Platform/API dependency (a tool you rely on changes terms or shuts down)
- Customer concentration (too much revenue from one client)
- Market timing (too early or too late)
- Pricing risk (customers won't pay what you planned)
- Competition risk (a well-funded player enters your niche)

---

## Plan Maintenance Rules
- **Update monthly** during the first 6 months. Reality will differ from your plan constantly.
- **Mark assumptions clearly.** Highlight every assumption in the plan. When reality proves one right or wrong, update it and note what changed.
- **Version it.** Keep old versions. Comparing your plan from 3 months ago to today is one of the best ways to learn and improve your forecasting.
- **Share it.** Show it to 2-3 trusted people (advisors, fellow founders, mentors). Outside eyes catch blind spots.
