---
name: business-model-canvas
description: Build, fill, stress-test, and iterate on a Business Model Canvas for a solopreneur. Use when designing or redesigning how a business creates, delivers, and captures value — covering all nine BMC blocks plus solopreneur-specific adaptations like the "Time & Energy" block and unit economics validation. Trigger on "business model canvas", "design my business model", "how will I make money", "business model", "BMC", "value proposition canvas", "how does my business work", "monetize my idea".
---

# Business Model Canvas

## Overview
The Business Model Canvas (BMC) is a one-page strategic tool that maps every element of how your business works. For solopreneurs, the standard BMC needs one critical addition: a Time & Energy block, because your scarcest resource isn't money — it's you. This playbook walks you through filling every block, validating the connections between them, and finding the weaknesses before the market does.

---

## The Nine (+1) Blocks

Fill these in the order listed. Each block informs the next. Do not skip around.

### Block 1: Customer Segments
**Question:** Who exactly are you serving?

- Be specific. Not "small businesses." Define 1-3 tight segments.
- For each segment: size estimate, pain level, budget, and how they currently solve the problem.
- Rank segments by: pain intensity × willingness to pay × reachability.
- Your primary segment (the one you build for first) should score highest across all three.

### Block 2: Value Propositions
**Question:** What specific value do you deliver to each segment?

- Write one value proposition per segment. Make it concrete and measurable.
- Format: "[Customer type] can [achieve specific outcome] in [timeframe/way], instead of [current painful alternative]."
- Quantify the value wherever possible: "Save 5 hours/week", "Cut churn by 30%", "Close deals 2x faster."
- Identify whether your value is primarily: cost savings, time savings, quality improvement, risk reduction, or new capability.

### Block 3: Channels
**Question:** How do customers discover and buy from you?

- Map the full customer journey: Awareness → Consideration → Purchase → Delivery → Post-purchase.
- For each stage, identify the specific channel or touchpoint. Example: Awareness = LinkedIn content + SEO blog. Consideration = free trial. Purchase = website checkout. Delivery = onboarding email sequence. Post-purchase = in-app onboarding.
- Identify which channels are owned (blog, email list, social following), earned (word-of-mouth, reviews, press), or paid (ads). Aim for a mix, but as a solopreneur, owned and earned channels are your lifeline.

### Block 4: Customer Relationships
**Question:** What kind of relationship does each customer segment expect?

Choose the dominant model(s) for your business:
- **Self-service:** Product does the work. Minimal human touch. (SaaS tools, digital products)
- **Automated personal service:** Personalized at scale via automation. (Email sequences, chatbots, personalized dashboards)
- **Community:** Customers help each other. (Forum, Slack group, peer network)
- **One-to-one:** Direct personal interaction. (Consulting, coaching, white-glove service)

As a solopreneur, self-service and automated are your scaling levers. One-to-one doesn't scale but can be your revenue bridge while building.

### Block 5: Revenue Streams
**Question:** How does money flow in, and from whom?

For each customer segment, define:
- **Revenue model:** One-time purchase / Subscription (monthly or annual) / Usage-based / Freemium / Marketplace commission / Service retainer
- **Price point:** Specific dollar amount per unit or per month
- **Payment trigger:** What action causes the customer to pay?
- **Expected ARPU (Average Revenue Per User):** Monthly and annual

List ALL revenue streams. Most successful solopreneur businesses have 2-3 streams (e.g., a SaaS product + a consulting arm + a digital course).

### Block 6: Key Resources
**Question:** What do you need to deliver your value proposition?

As a solopreneur, resources are: your time, your skills, tools/software, and any intellectual property or data you have.

- List every resource required.
- Flag which are one-time investments vs. ongoing costs.
- Identify the resource that is your biggest bottleneck. This often reveals a scaling problem early.

### Block 7: Key Activities
**Question:** What must you actually DO every day/week to keep this business running?

Split into:
- **Product/Service delivery** — the core thing you do to serve customers
- **Customer acquisition** — marketing, sales, outreach
- **Operations & maintenance** — support, invoicing, infrastructure, updates

**Solopreneur time-check:** Estimate hours per week for each activity. If the total exceeds your available hours (realistically 30-40 for a full-time solo operation), something must be cut, automated, or outsourced.

### Block 8: Key Partnerships
**Question:** What external relationships reduce risk or fill capability gaps?

Partnerships for solopreneurs often include:
- Tool/platform partnerships (integration partners, affiliate relationships)
- Freelancer or contractor relationships for skills you lack
- Distribution partners (someone who sends customers your way in exchange for value)
- Technology dependencies (API providers, hosting, payment processors)

**Risk flag:** If your business depends on a single platform or partner that could change terms or shut down, that's a critical risk. Identify these and have contingency plans.

### Block 9: Cost Structure
**Question:** What does it cost to run this business?

Categorize costs:
- **Fixed costs** (don't change with volume): hosting, tools/subscriptions, insurance, legal
- **Variable costs** (scale with revenue or customers): payment processing fees, ad spend, contractor hours, per-unit delivery costs
- **One-time costs:** Initial setup, branding, first version of product

Calculate your **monthly burn rate** (fixed + baseline variable) and your **break-even point** (how many customers or revenue needed to cover all costs).

### Block 10 (Solopreneur Addition): Time & Energy Budget
**Question:** Can YOU actually do all of this without burning out?

This block doesn't exist in the standard BMC but is the #1 killer of solopreneur businesses.

- List every key activity from Block 7.
- Assign realistic weekly hours to each.
- Identify what can be automated (Block 7 cross-reference).
- Identify what can be outsourced and at what cost (feeds back into Block 9).
- Calculate your remaining personal hours for rest, learning, and life.

**Rule:** If your time budget doesn't balance, the business model is broken. Fix it before launching — not after burning out six months in.

---

## Validation Step: Cross-Block Consistency Check

After filling all blocks, run these checks. Each one catches a common mistake:

| Check | What to Verify |
|---|---|
| Value ↔ Segments | Does each value proposition directly address a pain that each segment actually has? |
| Revenue ↔ Value | Are customers willing to pay the price you set for the value you deliver? (Cross-reference customer discovery data) |
| Channels ↔ Segments | Can you actually reach your target segments through the channels you listed? |
| Activities ↔ Time | Do your key activities fit within realistic available hours? (Block 10) |
| Costs ↔ Revenue | Does your revenue exceed your costs at a realistic customer volume? (Unit economics) |
| Resources ↔ Activities | Do you have every resource needed to execute every activity? |
| Partnerships ↔ Risks | Are critical dependencies identified and mitigated? |

**For every "no" answer:** Either fix the block or fundamentally rethink the model. A business model with unresolved inconsistencies will fail predictably.

---

## Unit Economics Sanity Check

Before finalizing, calculate these three numbers:

- **CAC (Customer Acquisition Cost):** Total marketing/sales spend ÷ number of new customers acquired. Target: CAC < 3 months of customer revenue.
- **LTV (Customer Lifetime Value):** ARPU × average customer lifespan in months. Target: LTV > 3× CAC.
- **Payback Period:** CAC ÷ monthly ARPU. Target: < 12 months.

If unit economics don't work, adjust: raise price, reduce CAC via better channels, or increase retention to extend LTV.

---

## When to Revisit
- Before every major decision (new feature, new market, new pricing).
- Monthly during the first 6 months of operation.
- Quarterly thereafter.
- Whenever a key assumption is proven wrong by real data.

The BMC is a living document. The version you write today will be wrong in 30 days. That's expected. Update it honestly and often.
