# Idea Validation Methods

Validate before building. Most ideas fail validation, which is the point.

## Quick Validation (1-2 hours)

### Google Trends Check
- Search the problem/solution keywords
- Look for upward trend or stable demand
- Compare against alternatives

### Competition Scan
- Search "best [solution] for [audience]"
- Count competitors and analyze quality
- No competitors = no market OR opportunity

### Reddit/Forum Search
- Search problem keywords in relevant subreddits
- Count posts and engagement
- Read comments for pain intensity

### Willingness to Pay Signal
- Search "[solution] pricing" or "[competitor] alternatives"
- Check if people discuss paying for solutions
- Look for "I'd pay for X" comments

## Medium Validation (1-2 days)

### Landing Page Test
1. Create simple landing page explaining value
2. Add email signup for "early access"
3. Drive 100-500 visitors via ads ($50-200)
4. Measure signup rate (>10% = promising)

### Pre-sale Attempt
1. Describe product/service in detail
2. Offer early-bird pricing
3. Ask for payment or commitment
4. Zero sales = pivot or kill

### Expert Interviews
1. Find 5-10 potential customers
2. Ask about current solutions and frustrations
3. Describe your idea (don't pitch, describe)
4. Ask what they'd pay and why

## Deep Validation (1-2 weeks)

### Concierge MVP
1. Deliver service manually to 3-5 customers
2. Charge real money (even if discounted)
3. Measure time to deliver and satisfaction
4. Calculate if automating makes sense

### Fake Door Test
1. Build feature/product button in existing product
2. Track clicks (interest signal)
3. Show "coming soon" message
4. High interest = build it

### Letter of Intent
1. Approach potential B2B customers
2. Describe solution and pricing
3. Ask for signed letter of intent
4. Multiple LOIs = strong signal

## Validation Scorecard

After validation, score each dimension:

| Signal | Score 1-10 |
|--------|-----------|
| People searching for solution | |
| People paying for alternatives | |
| Clear target customer identified | |
| Unique angle vs competition | |
| Willingness to pay confirmed | |
| **Total (out of 50)** | |

**Interpretation:**
- 40+ → Strong proceed
- 30-39 → Proceed with caution
- 20-29 → Major pivot needed
- <20 → Kill and move on

## Red Flags (Stop Signals)

- "Interesting idea" without payment signal
- Only friends/family show interest
- Target customer hard to reach
- Competition with infinite funding
- Requires behavior change + new category

## Green Flags (Proceed Signals)

- Strangers pay for early access
- Target customers easy to find and reach
- Existing budget for this problem
- Competition exists but is beatable
- Clear path to first 10 customers

---

## Validation Budget Guide

| Stage | Budget | Time | Goal |
|-------|--------|------|------|
| Quick | $0-50 | 2h | Kill obviously bad ideas |
| Medium | $50-500 | 2d | Confirm demand exists |
| Deep | $500-2000 | 2w | Confirm people will pay |

**Rule:** Don't build until you've spent at least $200 on validation.
