# Idea Generation Frameworks

Use these systematically. Rotate to ensure variety.

## 1. Pain Point Mining

Find frustrations in daily life or work.

**Process:**
1. Pick a domain (work, health, finance, relationships)
2. List 10 frustrations people complain about
3. Rank by frequency and intensity
4. Design solution for top 3

**Trigger questions:**
- What do people complain about repeatedly?
- What takes too long or costs too much?
- What do people avoid because it's painful?

## 2. Trend Riding

Surf emerging waves before they peak.

**Process:**
1. Identify rising trend (AI, remote work, creator economy, etc.)
2. Find underserved niche within trend
3. Build picks-and-shovels or direct solution

**Trigger questions:**
- What's growing 50%+ year over year?
- What do early adopters use that mainstream will want?
- What infrastructure is missing for this trend?

## 3. Existing Business Remix

Take proven model, apply to new market.

**Process:**
1. Find successful business in market A
2. Identify market B without equivalent
3. Adapt model for market B specifics

**Examples:**
- Uber for X (logistics, services, professionals)
- Shopify for Y (specific verticals)
- Notion for Z (specific workflows)

## 4. Audience First

Start with people, find their needs.

**Process:**
1. Pick specific audience you understand
2. Map their journey and spending
3. Find gaps in current solutions
4. Build for that gap

**Best audiences:**
- Your past self (2-5 years ago)
- Your current profession
- Communities you belong to

## 5. Technology Arbitrage

Apply new tech to old problems.

**Process:**
1. Identify new capability (AI, blockchain, AR, etc.)
2. Find industry still doing things old way
3. Apply new tech to reduce cost/time 10x

**Current opportunities:**
- AI for manual processes
- Automation for repetitive work
- Mobile-first for desktop-only tools

## 6. Unbundling

Break apart aggregators into focused tools.

**Process:**
1. Find large platform serving many needs
2. Identify one need served poorly
3. Build focused solution for that need

**Examples:**
- Craigslist unbundled into 50+ startups
- Excel unbundled into specialized tools
- Social media unbundling by interest

## 7. Productized Service

Turn service into scalable product.

**Process:**
1. Find service businesses with high margins
2. Identify repeatable parts of delivery
3. Automate or templatize those parts
4. Sell at lower price, higher volume

**Good candidates:**
- Consulting with standard deliverables
- Agencies with repeating workflows
- Professional services with templates

## 8. Reverse Engineering

Work backwards from successful exits.

**Process:**
1. Study recent acquisitions in target space
2. Identify what made them valuable
3. Build similar value in adjacent space
4. Position for same acquirers

## 9. API as Business

Build infrastructure others need.

**Process:**
1. Find common technical problem across companies
2. Build API that solves it once
3. Charge per use or subscription

**Signals of opportunity:**
- Engineers building same thing repeatedly
- Open source projects with no hosted version
- Complex integrations everyone needs

## 10. Community to Commerce

Monetize existing communities.

**Process:**
1. Find engaged community (online or offline)
2. Identify shared needs or desires
3. Build product or service for that need
4. Leverage community for distribution

---

## Framework Selection Guide

| Situation | Best Frameworks |
|-----------|-----------------|
| Technical founder | Technology Arbitrage, API as Business |
| Domain expert | Audience First, Pain Point Mining |
| Following trends | Trend Riding, Unbundling |
| Low risk tolerance | Existing Business Remix, Productized Service |
| Fast validation needed | Pain Point Mining, Community to Commerce |
