#!/bin/bash
# pipeline-report.sh - Generate BD pipeline reports
# Usage: ./pipeline-report.sh [command]

BD_DIR="${HOME}/.openclaw/workspace/business-development"
REPORTS_DIR="$BD_DIR/reports"
mkdir -p "$REPORTS_DIR"

generate_weekly() {
    local date=$(date +%Y-%m-%d)
    local report_file="${REPORTS_DIR}/weekly-${date}.md"
    
    cat > "$report_file" << EOF
# BD Weekly Report — ${date}

## Summary
- New opportunities: 
- Moved forward: 
- Partnerships closed: 
- Lost/paused: 

## Pipeline Health
- Total opportunities: 
- Total potential value: \$
- Weighted value: \$

## Activity This Week

### Outreach
| Partner | Method | Response |
|---------|--------|----------|

### Meetings
| Partner | Purpose | Outcome |
|---------|---------|---------|

### Proposals Sent
| Partner | Type | Value |
|---------|------|-------|

## Movement

### Moved Forward
| Partner | From | To | Notes |
|---------|------|-----|-------|

### Stalled
| Partner | Stage | Days Stalled | Next Action |
|---------|-------|--------------|-------------|

## Key Wins
- 

## Challenges
- 

## Focus Next Week
1. 
2. 
3. 

---
*Report generated by pipeline-report.sh*
EOF
    
    echo "✅ Weekly BD report created: $report_file"
}

generate_quarterly() {
    local date=$(date +%Y-%m-%d)
    local quarter=$(( ($(date +%-m) - 1) / 3 + 1 ))
    local year=$(date +%Y)
    local report_file="${REPORTS_DIR}/Q${quarter}-${year}.md"
    
    cat > "$report_file" << EOF
# BD Quarterly Review — Q${quarter} ${year}

## Executive Summary
[Quarter highlights and key achievements]

## Metrics

### Pipeline
- Starting pipeline: \$
- Ending pipeline: \$
- Change: %

### Partnerships Closed
| Partner | Type | Value | Date |
|---------|------|-------|------|

### Win Rate
- Proposals sent: 
- Partnerships closed: 
- Win rate: %

## Partnership Performance

### Active Partnerships Review
| Partner | Type | Health | Value Delivered | Issues |
|---------|------|--------|-----------------|--------|

### Top Performing
1. 
2. 

### Needs Attention
1. 
2. 

## Market Insights
[Key learnings from BD conversations]

## Competitive Intelligence
[Updates on competitor partnerships/moves]

## Next Quarter Goals
1. 
2. 
3. 

## Resource Needs
- 

---
*Report generated by pipeline-report.sh*
EOF
    
    echo "✅ Quarterly BD report created: $report_file"
}

case "$1" in
    weekly)
        generate_weekly
        ;;
    
    quarterly)
        generate_quarterly
        ;;
    
    list)
        echo "📊 Available Reports"
        echo "==================="
        ls "$REPORTS_DIR"/*.md 2>/dev/null || echo "No reports yet."
        ;;
    
    *)
        echo "BD Pipeline Report Generator"
        echo "============================"
        echo "Commands:"
        echo "  weekly     - Generate weekly BD report"
        echo "  quarterly  - Generate quarterly review"
        echo "  list       - List all reports"
        ;;
esac
