---
name: business-development
version: 1.0.0
description: "Partnership outreach, market research, competitor analysis, and proposal generation. Transform your AI agent into a strategic business development partner that identifies and cultivates growth opportunities."
author: openclaw
---

# Business Development Skill 🤝

**Turn your AI agent into a strategic growth partner.**

Research markets, identify partnerships, analyze competitors, and generate compelling proposals that open doors.

---

## What This Skill Does

✅ **Partnership Outreach** — Identify, research, and approach potential partners
✅ **Market Research** — Analyze market size, trends, and opportunities
✅ **Competitor Analysis** — Track competitors and identify advantages
✅ **Proposal Generation** — Create compelling partnership and business proposals
✅ **Opportunity Tracking** — Manage BD pipeline from lead to deal
✅ **Strategic Planning** — Support business expansion decisions

---

## Quick Start

1. Configure your BD focus in `TOOLS.md`:
```markdown
### Business Development
- Target markets: [Industries/Geographies]
- Partnership types: [Integration/Reseller/Co-marketing/etc.]
- Competitor watch list: [Key competitors]
- Proposal templates: [Location]
```

2. Set up your workspace:
```bash
./scripts/bd-init.sh
```

3. Start building partnerships!

---

## Partnership Development

### Partnership Types

| Type | Description | Value Proposition |
|------|-------------|-------------------|
| **Integration** | Technical product connection | Expand functionality, reach new users |
| **Reseller/Distribution** | Sell through partners | Access new channels, scale faster |
| **Co-Marketing** | Joint marketing efforts | Share audiences, reduce CAC |
| **Referral** | Lead sharing | Lower-friction partnership |
| **Strategic** | Deep collaboration | Market expansion, shared resources |
| **White-Label** | Rebrand product for partner | New revenue stream |

### Partner Qualification Framework

**PARTNER Score:**

| Criteria | Question | Weight |
|----------|----------|--------|
| **P**otential | What's the upside? | 20% |
| **A**lignment | Do goals/values match? | 20% |
| **R**each | What audience can they access? | 15% |
| **T**iming | Are they ready now? | 15% |
| **N**eed | Do they need what we offer? | 15% |
| **E**xperience | Have they done this before? | 10% |
| **R**isk | What could go wrong? | 5% |

**Score 70+:** Prioritize actively
**Score 50-70:** Keep warm
**Score <50:** Deprioritize

### Partner Profile Template

```markdown
# Partner Profile: [Company Name]

## Overview
- **Company:** [Name]
- **Website:** [URL]
- **Industry:** [Industry]
- **Size:** [Employees / Revenue if known]
- **Founded:** [Year]
- **HQ:** [Location]

## Key Contacts
- **Primary:** [Name, Title, Email, LinkedIn]
- **Secondary:** [Name, Title, Email, LinkedIn]

## Their Business
- **What they do:** [Description]
- **Target customers:** [Who they serve]
- **Key products:** [Products/Services]
- **Competitive advantage:** [What makes them different]

## Partnership Opportunity
- **Type:** [Integration/Reseller/Co-marketing/etc.]
- **Value to them:** [What we offer]
- **Value to us:** [What they offer]
- **Synergy:** [How we complement each other]

## Qualification (PARTNER Score)
- Potential: [X/10] — [Notes]
- Alignment: [X/10] — [Notes]
- Reach: [X/10] — [Notes]
- Timing: [X/10] — [Notes]
- Need: [X/10] — [Notes]
- Experience: [X/10] — [Notes]
- Risk: [X/10] — [Notes]
- **Total:** [X/70]

## Research Notes
[Relevant findings from research]

## Status & Next Steps
- **Current stage:** [Prospect/Outreach/Discussion/Negotiation/Active]
- **Last contact:** [Date]
- **Next action:** [Action] — Due: [Date]
```

---

## Partnership Outreach

### Outreach Sequence

**Phase 1: Research (Before Contact)**
- [ ] Company website deep dive
- [ ] Key personnel LinkedIn research
- [ ] Recent news/press releases
- [ ] Existing partnerships they have
- [ ] Mutual connections check
- [ ] Their tech stack (if relevant)

**Phase 2: Initial Outreach**

Email Template:
```
Subject: Partnership idea: [Specific value proposition]

Hi [Name],

[Personalized observation showing you did research — reference something specific they did/said].

I lead BD at [Your Company]. We [brief description of what you do] for [target customers].

I noticed [observation about their business] and think there's an interesting opportunity to [specific partnership concept].

[One sentence on mutual benefit — what's in it for them + what's in it for you].

Would you be open to a quick call to explore?

Best,
[Your name]
```

**Phase 3: Follow-up**

Day 5:
```
Subject: Re: Partnership idea

Hi [Name],

Wanted to follow up on my note below. I've been thinking more about how [specific idea] could work.

[Add one more value point or insight].

Worth 15 minutes to discuss?

[Your name]
```

Day 12 (Value-add):
```
Subject: [Relevant resource/insight]

Hi [Name],

Found this [article/report/insight] and thought of you: [link]

[Brief tie to why it's relevant to potential partnership].

Still think there's something interesting here if you're open to exploring.

[Your name]
```

### Partnership Meeting Agenda

```markdown
# Partnership Discussion: [Company]
**Date:** [Date]
**Attendees:** [Names]

## Agenda (30 min)

1. **Intros** (5 min)
   - Background on each company
   - Roles in the partnership

2. **Opportunity Discussion** (10 min)
   - Partnership concept
   - Mutual value proposition
   - Initial scope

3. **Alignment Check** (10 min)
   - Goals and expectations
   - Potential challenges
   - Resources needed

4. **Next Steps** (5 min)
   - Action items
   - Timeline
   - Next meeting

## Questions to Ask
- What would success look like for you?
- What's your typical partnership process?
- Who else needs to be involved?
- What's your timeline for decision?
```

---

## Market Research

### Market Research Framework

**1. Market Sizing (TAM/SAM/SOM)**

| Metric | Definition | How to Calculate |
|--------|------------|------------------|
| **TAM** | Total Addressable Market | Total revenue if you had 100% market share |
| **SAM** | Serviceable Addressable Market | Portion you can actually reach |
| **SOM** | Serviceable Obtainable Market | Realistic near-term capture |

**2. Market Analysis Template**

```markdown
# Market Research: [Market/Industry]

## Executive Summary
[2-3 sentences on key findings and opportunity]

## Market Size
- **TAM:** $[X]B (global, all segments)
- **SAM:** $[X]M (your reachable market)
- **SOM:** $[X]M (realistic 3-year target)

## Market Dynamics
- **Growth rate:** [X]% CAGR
- **Key drivers:** [List]
- **Key barriers:** [List]

## Customer Segments
| Segment | Size | Growth | Our Fit |
|---------|------|--------|---------|
| [Segment] | $[X]M | [X]% | High/Med/Low |

## Competitive Landscape
[Overview of key players]

## Trends
1. **[Trend]:** [Impact on us]
2. **[Trend]:** [Impact on us]

## Opportunities
1. [Opportunity description]
2. [Opportunity description]

## Threats
1. [Threat description]
2. [Threat description]

## Recommendations
1. [Action to take]
2. [Action to take]

## Sources
- [Source 1]
- [Source 2]
```

### Research Sources

| Type | Sources | Best For |
|------|---------|----------|
| **Industry reports** | Gartner, Forrester, IBISWorld | Market size, trends |
| **Financial data** | SEC filings, Crunchbase, PitchBook | Company data |
| **News** | Google News, industry publications | Recent developments |
| **Social** | LinkedIn, Twitter/X | Sentiment, personnel |
| **Technical** | G2, Capterra, BuiltWith | Product research |
| **Primary** | Interviews, surveys | Deep insights |

---

## Competitor Analysis

### Competitor Profile Template

```markdown
# Competitor Analysis: [Company Name]

## Overview
- **Company:** [Name]
- **Website:** [URL]
- **Founded:** [Year]
- **Funding:** [Stage/Amount]
- **Employees:** [Count]
- **HQ:** [Location]

## Product/Service
- **Core offering:** [Description]
- **Key features:** [List]
- **Pricing:** [Model and tiers]
- **Target customers:** [Segments]

## Strengths
1. [Strength]
2. [Strength]

## Weaknesses
1. [Weakness]
2. [Weakness]

## Market Position
- **Market share:** [Estimate]
- **Brand perception:** [How they're seen]
- **Key differentiator:** [What makes them unique]

## Recent Moves
- [Recent news/launch/change]

## Their Customers
- [Notable customers if known]

## How We Compare
| Factor | Us | Them | Advantage |
|--------|-----|------|-----------|
| [Factor] | [Our position] | [Their position] | Us/Them/Tie |

## Battlecard (for sales)
- **When we win against them:** [Scenarios]
- **When we lose against them:** [Scenarios]
- **Key talking points:** [What to emphasize]
- **Their objections to us:** [How to counter]
```

### Competitive Landscape Matrix

```markdown
# Competitive Landscape: [Category]

## Positioning Map

                  High Price
                      |
    [Premium]         |         [Enterprise]
    Competitor A      |         Competitor B
                      |
  Low Complexity -----|------ High Complexity
                      |
    [Budget]          |         [Niche]
    Competitor C      |         Competitor D
                      |
                  Low Price

## Feature Comparison

| Feature | Us | Comp A | Comp B | Comp C |
|---------|-----|--------|--------|--------|
| [Feature 1] | ✅ | ✅ | ❌ | ✅ |
| [Feature 2] | ✅ | ❌ | ✅ | ❌ |
| [Feature 3] | ✅ | ✅ | ✅ | ❌ |

## Summary
- **Our primary competition:** [Company]
- **Our differentiation:** [Key differentiator]
- **Market gaps we can exploit:** [Opportunities]
```

---

## Proposal Generation

### Proposal Structure

```markdown
# Partnership Proposal: [Your Company] × [Partner Company]

## Executive Summary
[1 paragraph overview of the opportunity and mutual value]

---

## The Opportunity

### Market Context
[Brief market opportunity both companies can address]

### Why Now
[Timing factors that make this partnership timely]

---

## The Partnership

### Concept
[Clear description of what you're proposing]

### Value to [Partner]
1. [Benefit 1]
2. [Benefit 2]
3. [Benefit 3]

### Value to [Your Company]
1. [Benefit 1]
2. [Benefit 2]
3. [Benefit 3]

---

## How It Works

### Integration/Collaboration Model
[Technical or operational details of how partnership functions]

### Roles & Responsibilities
| Area | [Your Company] | [Partner] |
|------|----------------|-----------|
| [Area] | [Responsibility] | [Responsibility] |

### Timeline
- **Phase 1 (Months 1-2):** [Activities]
- **Phase 2 (Months 3-4):** [Activities]
- **Phase 3 (Months 5+):** [Activities]

---

## Commercial Terms

### Revenue/Value Share
[Proposed commercial arrangement]

### Investment Required
| Item | [Your Company] | [Partner] |
|------|----------------|-----------|
| [Resource] | [Commitment] | [Commitment] |

---

## Success Metrics

| Metric | Target (Year 1) | How Measured |
|--------|-----------------|--------------|
| [Metric] | [Target] | [Measurement] |

---

## Risk Mitigation

| Risk | Mitigation |
|------|------------|
| [Risk] | [How we address it] |

---

## About [Your Company]
[Brief company overview, relevant traction, why you're a good partner]

---

## Next Steps
1. [Proposed next step]
2. [Proposed next step]

---

**Contact:**
[Name]
[Title]
[Email]
[Phone]
```

### Proposal Best Practices

1. **Lead with their value** — Partner's benefits first
2. **Be specific** — Vague proposals get ignored
3. **Show you understand them** — Reference their business
4. **Make it easy** — Clear next steps
5. **Keep it scannable** — Execs skim
6. **Include social proof** — Other partnerships, traction
7. **Address risk** — Show you've thought it through

---

## BD Pipeline Management

### Pipeline Stages

| Stage | Definition | Exit Criteria |
|-------|------------|---------------|
| **Research** | Identifying and qualifying prospects | Profile complete, score >50 |
| **Outreach** | Initial contact attempts | Response received |
| **Discussion** | Exploring mutual interest | Aligned on concept |
| **Proposal** | Formal proposal submitted | Proposal delivered |
| **Negotiation** | Terms discussion | Terms agreed |
| **Legal** | Contracts in review | Signed agreement |
| **Active** | Partnership live | Launched |

### Pipeline Tracking

```markdown
# BD Pipeline — [Month/Quarter]

## Summary
- Total opportunities: [X]
- Pipeline value: $[X] (potential annual value)
- Weighted value: $[X]
- Expected closes this quarter: [X]

## By Stage

### Research ([X])
| Partner | Type | PARTNER Score | Next Action |
|---------|------|---------------|-------------|
| [Name] | [Type] | [X/70] | [Action] |

### Outreach ([X])
| Partner | Type | Outreach # | Last Contact |
|---------|------|------------|--------------|
| [Name] | [Type] | [1/2/3] | [Date] |

### Discussion ([X])
| Partner | Type | Est. Value | Next Meeting |
|---------|------|------------|--------------|
| [Name] | [Type] | $[X] | [Date] |

### Proposal ([X])
| Partner | Type | Proposal Date | Decision Expected |
|---------|------|---------------|-------------------|
| [Name] | [Type] | [Date] | [Date] |

## Stale Opportunities (>30 days no activity)
| Partner | Stage | Last Activity | Action |
|---------|-------|---------------|--------|
```

---

## Strategic Planning

### SWOT Analysis Template

```markdown
# SWOT Analysis: [Initiative/Partnership/Market]

## Strengths (Internal, Positive)
- [Strength 1]
- [Strength 2]

## Weaknesses (Internal, Negative)
- [Weakness 1]
- [Weakness 2]

## Opportunities (External, Positive)
- [Opportunity 1]
- [Opportunity 2]

## Threats (External, Negative)
- [Threat 1]
- [Threat 2]

## Strategic Implications
- **Leverage:** [Use strengths to capture opportunities]
- **Improve:** [Address weaknesses to enable opportunities]
- **Defend:** [Use strengths to mitigate threats]
- **Watch:** [Monitor weakness × threat combinations]
```

### Decision Framework

For major BD decisions, use:

```markdown
# Decision: [What we're deciding]

## Context
[Background and why this decision is needed]

## Options
1. **[Option A]:** [Description]
2. **[Option B]:** [Description]
3. **[Option C]:** [Description]

## Evaluation

| Criteria | Weight | Option A | Option B | Option C |
|----------|--------|----------|----------|----------|
| [Criteria 1] | [X]% | [Score] | [Score] | [Score] |
| [Criteria 2] | [X]% | [Score] | [Score] | [Score] |
| **Weighted Total** | | [Total] | [Total] | [Total] |

## Recommendation
[Option X] because [reasoning]

## Risks & Mitigations
- [Risk]: [Mitigation]

## Next Steps
1. [Action]
2. [Action]
```

---

## Scripts

### bd-init.sh
Initialize your BD workspace with templates and tracking.

### partner-research.sh
Quick partner research and profile generation.

```bash
# Research a company
./scripts/partner-research.sh "Company Name"

# Generate partner profile
./scripts/partner-research.sh "Company Name" --profile
```

### pipeline-report.sh
Generate BD pipeline reports.

```bash
# Weekly pipeline summary
./scripts/pipeline-report.sh weekly

# Quarterly review
./scripts/pipeline-report.sh quarterly
```

---

## Best Practices

1. **Research before outreach** — Personalized > Generic
2. **Lead with value** — What's in it for them?
3. **Build relationships, not transactions** — Long-term thinking
4. **Document everything** — Conversations, decisions, context
5. **Follow up persistently** — Most deals need 5+ touchpoints
6. **Know your competition** — Updated battlecards win deals
7. **Start small** — Pilot before big commitment
8. **Measure what matters** — Partners closed, not meetings held

---

## Common Mistakes

❌ **Pitching too early** — Understand their needs first
❌ **Overselling** — Under-promise, over-deliver
❌ **Ignoring internal champions** — Find and nurture them
❌ **No mutual accountability** — Both sides need commitments
❌ **Slow follow-up** — Momentum matters
❌ **Vague proposals** — Specific asks get specific answers

---

## License

**License:** MIT — use freely, modify, distribute.

---

*"Opportunities don't happen, you create them." — Chris Grosser*
