# Build Hook

Build a Uniswap V4 hook: Solidity implementation, Foundry tests, CREATE2 address mining for hook flags, and deployment scripts.

→ **[SKILL.md](SKILL.md)** — Full skill specification and workflow.

## Installation

Install into Claude Code or Cursor with:

```bash
npx skills add https://github.com/wpank/Agentic-Uniswap/tree/main/.ai/skills/build-hook
```

Or via Clawhub:

```bash
npx clawhub@latest install build-hook
```

## When to use

Use this skill when:

- You want to **generate a production-ready Uniswap V4 hook** (code, tests, deployment).
- You need **CREATE2 address mining** to satisfy hook flag requirements.
- You prefer a **turnkey dev flow** from design assumptions to runnable code.

## Example prompts

- "Build a Uniswap V4 hook that charges a dynamic fee based on volatility."
- "Generate a V4 hook that shares a portion of swap fees with a treasury address."
- "Create a V4 hook for anti-sandwich protection with tests and deployment scripts."
