---
name: build-discipline
description: Build unbreakable discipline with habit stacking, streak tracking, and accountability
author: clawd-team
version: 1.0.0
triggers:
  - "build discipline"
  - "more disciplined"
  - "self discipline"
  - "stay consistent"
  - "discipline check"
---

# Build Discipline

**Become consistently excellent through habit stacking, streak tracking, and real-time accountability.**

## What it does

This skill transforms discipline from willpower (finite) into systems (infinite). It works by:

- **Commitment Tracking** - Lock in your daily non-negotiables and track adherence automatically
- **Streak Systems** - Visual momentum through consecutive day counters that compound motivation
- **Habit Stacking** - Attach new behaviors to existing anchors (e.g., "After coffee, meditate for 5 min")
- **Willpower Management** - Smart timing for hard tasks + recovery windows to prevent burnout
- **Accountability** - Daily check-ins with streak status, pattern analysis, and course corrections

## Usage

### Set commitments
Define your non-negotiables for the day. Examples: "Sleep by 11pm", "1 hour deep work", "30 min exercise". Clawd stores these and reminds you when each window opens.

### Daily check-in
Quick status update each morning: How did yesterday go? Clawd marks the streak as intact or broken, logs the data, and adjusts your difficulty curve.

### Streak status
See your current streaks at a glance. Visual feedback (🔥 for hot streaks) amplifies momentum. Long streaks become identity.

### Stack habits
Pair new habits with existing ones. "After brush teeth → take 3 deep breaths." Piggyback behavior change on automatic routines.

### Review discipline
Weekly or monthly review: Which commitments stuck? Which broke? Patterns emerge. Clawd suggests micro-adjustments to increase success rate.

## Discipline Pillars

The framework targets five foundational pillars:

| Pillar | Focus | Example |
|--------|-------|---------|
| Sleep | 7-9 hrs, consistent time | Bed by 11pm, wake 6:30am |
| Exercise | Movement + strength | 30 min walk or lift, 5x/week |
| Nutrition | Whole foods, hydration | 2L water, no processed sugar |
| Focus Blocks | Deep work windows | 2 hrs uninterrupted, 9-11am |
| Recovery | Rest days, stretching | 1 rest day/week, 10 min mobility |

Each pillar auto-compounds when stacked together. Sleep improves focus. Exercise improves sleep. This creates a flywheel.

## Tips

1. **Start with one pillar.** Don't overload. Pick the one that unlocks the others (usually sleep or exercise) and nail it for 30 days before adding more.

2. **Stack, don't replace.** Attach new habits to existing anchors. "After morning coffee" is stronger than "at some point today."

3. **Track the minimum.** A 5-min walk beats zero. A 6-hour sleep beats staying up. Consistency > perfection.

4. **Review weekly, not daily.** Daily breaks feel like failure. Weekly patterns reveal truth. Adjust Tuesday for next Monday.

5. **All data stays local on your machine.** Your discipline data never leaves your device. No cloud sync, no third-party analytics, no privacy leaks. You own everything.
