---
name: bug-investigation
description: Systematically reproduces, locates, and diagnoses frontend bugs using steps, hypotheses, DevTools, and minimal repro. Use when 排查bug, bug定位, 调试, debugging, 复现问题, or investigating frontend issues.
---

# Bug 排查（Bug Investigation）

用可复现步骤、假设验证和工具链，快速定位并诊断前端问题根因。

## 触发场景

- 用户说「排查 bug」「定位问题」「复现不了」「不知道哪里错了」
- 描述现象：白屏、报错、样式错乱、请求失败、交互异常等
- 提供错误信息、截图、环境（浏览器、设备、网络）

## 执行流程

### 1. 明确现象与环境

- **现象**：用户操作路径 + 预期 vs 实际（一句话描述）
- **环境**：浏览器及版本、是否生产/预发/本地、设备/分辨率、网络（慢网/离线）
- **必现/偶现**：若偶现，补充可能相关条件（数据量、时机、多 tab 等）

### 2. 复现与缩小范围

- 写出**最小复现步骤**（3–5 步内能复现）
- 判断范围：仅某页面 / 某组件 / 某接口 / 某浏览器 / 某分辨率
- 若无法复现：请用户提供录屏、Console 报错、Network 失败请求，或可复现的测试数据/账号

### 3. 假设与验证

按优先级做假设并逐条验证（用「是/否」结论）：

| 假设类型 | 验证方式 |
|----------|----------|
| 前端逻辑/状态 | 断点、console.log、React DevTools 状态 |
| 接口/数据 | Network 看请求与响应、mock 数据对比 |
| 样式/布局 | 审查元素、Computed、覆盖样式来源 |
| 时机/异步 | 执行顺序、Promise/async、事件触发顺序 |
| 环境/兼容 | 换浏览器、无痕、禁用扩展、不同设备 |

### 4. 定位根因

- 指出**具体文件 + 位置（行/函数/组件）**
- 用一句话说明**根因**：例如「在 XX 条件下未做判空导致取属性报错」
- 若为接口或后端问题，明确说明并给出前端可做的降级或提示

### 5. 修复建议

- 给出最小改动修复方案（代码片段或步骤）
- 必要时补充：边界情况、测试建议、类似位置是否需一并检查

## 输出模板

```markdown
## Bug 排查报告

### 现象
- 操作：…
- 预期：… / 实际：…

### 环境
- 浏览器/设备/网络：…

### 复现步骤
1. …
2. …

### 假设与验证
- [ ] 假设 1：… → 验证结果
- [ ] 假设 2：… → 验证结果

### 根因
- 位置：文件:行 或 组件名
- 原因：…

### 修复建议
- 方案：…
- 注意：…
```

## 常用手段

- **Console**：报错栈、`console.trace`、断点
- **Network**：状态码、响应体、请求头、是否被缓存
- **Elements**：计算样式、覆盖关系、伪元素
- **React DevTools**：组件树、props/state、重渲染
- **Performance / Lighthouse**：卡顿、长任务、布局抖动
- **最小复现**：新建单页或 CodeSandbox 只保留必要代码与数据
