# Buenos Aires Visitor Tips

## Essential First-Day Tasks

### 1. Get Argentine Pesos (Blue Dollar)

**Do NOT use ATM or credit card for cash.**

**Options:**
| Method | Rate | Notes |
|--------|------|-------|
| Western Union | Best | Bring foreign debit card, get pesos |
| Cuevas (exchange houses) | Good | Florida Street, ask "dolar blue" |
| Hotels/hostels | OK | Slightly worse rate |
| ATM | Bad | Official rate = 30% loss |

**Tip:** Western Union app lets you send to yourself, pick up in pesos.

### 2. Get a SUBE Card

Public transport requires this rechargeable card.

**Where to buy:**
- Subte stations
- Kioscos (corner stores)
- Some lottery shops (Loterias)

**Cost:** ~$1 for card + charge it with pesos
**How:** Top up at kioscos or subte machines

### 3. Download Apps

| App | Purpose |
|-----|---------|
| **Uber/Cabify** | Safe rides |
| **WhatsApp** | Everyone uses it |
| **Google Maps** | Works well for BA |
| **BA Como Llego** | Public transport planner |
| **Rappi/PedidosYa** | Food delivery |
| **Mesa** | Restaurant reservations |

### 4. Get a Local SIM (Optional)

| Carrier | Coverage | Notes |
|---------|----------|-------|
| Claro | Good | Easy tourist plans |
| Movistar | Good | Similar |
| Personal | Good | Similar |

**Where:** Carrier stores, some kioscos
**Cost:** ~$10-20 for card + data
**Alternative:** eSIM before arriving (Airalo, etc.)

---

## Money Strategy

### The Blue Dollar Explained

Argentina has currency controls. The "official" rate is for banks/cards. The "blue" rate is the free market rate.

| Rate (Feb 2026) | ~ARS per USD |
|-----------------|--------------|
| Official | ~900 |
| Blue | ~1,200 |
| Difference | ~30% |

**Bottom line:** Pay cash in pesos (exchanged at blue) or USD whenever possible.

### Daily Budget (Blue Rate)

| Style | Per Day (USD) |
|-------|---------------|
| Backpacker | $30-50 |
| Budget | $50-80 |
| Comfortable | $80-150 |
| Luxury | $150-300+ |

### Where to Use Card vs Cash

| Use Card | Use Cash |
|----------|----------|
| Hotels (often official rate) | Restaurants |
| Flights | Shopping |
| Major chains | Taxis |
| If you must | Markets |
| | Small businesses |

---

## Safety Essentials

### Street Smart Basics

| Do | Don't |
|----|-------|
| Use front pockets | Flash phone on street |
| Carry copy of passport | Carry actual passport daily |
| Stay aware in crowds | Wear expensive jewelry |
| Use main streets at night | Walk distracted |
| Keep small bills separate | Count money publicly |

### Phone Safety

**Phone theft is common.** Especially:
- Walking while looking at phone
- Sitting at outdoor cafe with phone on table
- Using phone near street edge

**Prevention:**
- Hold phone firmly, away from street
- Use headphones so you hear around you
- Consider cheap backup phone for street use
- Apple AirTags in bag

### Safe Areas at Night

| Generally Safe | Use Caution | Avoid |
|----------------|-------------|-------|
| Palermo | San Telmo | La Boca (beyond Caminito) |
| Recoleta | Almagro | Constitucion |
| Puerto Madero | Villa Crespo edges | Once |
| Belgrano | | Microcentro (deserted) |
| Las Canitas | | Retiro (bus station area) |

### If Something Happens

- **Emergency:** 911
- **Tourist police:** 0800-999-5000
- **Report:** Go to nearest comisaria (police station)
- **Embassy:** Have number saved

---

## Getting Around

### Subte (Metro)

| Info | Details |
|------|---------|
| Lines | A, B, C, D, E, H |
| Hours | ~5am-11pm (less on weekends) |
| Cost | ~$0.50 per ride |
| Pay | SUBE card only |

**Tips:**
- Avoid rush hour (8-9am, 6-7pm)
- Keep bag in front
- Lines A and D most useful for tourists

### Colectivos (Buses)

- 140+ routes, goes everywhere
- Runs 24/7 (some routes)
- Pay with SUBE
- Enter front, exit middle/back
- Tell driver where you're going (helps)

### Taxis

| Type | Notes |
|------|-------|
| Street hail | Use marked official taxis (black/yellow) |
| Radio taxi | Safest, call ahead |
| Uber | Works, legal gray area |
| Cabify | Works, similar to Uber |

**Taxi tips:**
- Confirm meter is running
- Have small bills
- Know approximate fare
- Night = slightly higher

### Walking

Buenos Aires is very walkable. But:
- Sidewalks can be uneven
- Watch for dog poop
- Cross carefully (drivers don't always yield)
- Cobblestones in San Telmo = hard on feet

---

## Language Tips

### Essential Spanish

| English | Spanish |
|---------|---------|
| Hello | Hola |
| Thank you | Gracias |
| Please | Por favor |
| The bill | La cuenta |
| How much? |  Cuanto cuesta? |
| Where is...? |  Donde esta...? |
| I don't understand | No entiendo |
| Do you speak English? |  Habla ingles? |

### Argentine Spanish Quirks

- **Vos** instead of tu
- **Che** = hey, dude
- **Boludo** = dude (can be insult or friendly)
- **Dale** = OK, go ahead
- **Mira** = look (conversation filler)
- **LL** sounds like "sh" (calle = ca-she)

### English Prevalence

| Area | English Level |
|------|---------------|
| Palermo | Moderate-good |
| Recoleta | Moderate |
| San Telmo | Some |
| Tourist attractions | Usually |
| Local neighborhoods | Limited |
| Taxis | Rare |

---

## Cultural Tips

### Greetings

- **One kiss on cheek** - Standard greeting (even business)
- **Handshake** - More formal or first meeting
- **Hug** - Friends

### Timing

| Activity | Local Time |
|----------|------------|
| Breakfast | 8-10am |
| Lunch | 1-3pm |
| Merienda | 5-7pm |
| Dinner | 9-11pm |
| Going out | After midnight |

Don't show up at restaurants at 7pm expecting crowds.

### Tipping

| Service | Tip |
|---------|-----|
| Restaurant | 10% |
| Cafe | Round up |
| Taxi | Round up |
| Hotel bellhop | Small amount |
| Spa/salon | 10-15% |

### Social Norms

- **Personal space:** Closer than North American
- **Eye contact:** Normal and expected
- **Punctuality:** Flexible (15 min late = on time)
- **Dress:** Generally well-dressed, casual smart
- **Small talk:** Expected before business

---

## Day Trip Tips

### Tigre

- **How:** Train from Retiro (cheaper) or taxi
- **Bring:** Cash, sunscreen, camera
- **Skip:** Weekend if hate crowds

### Colonia (Uruguay)

- **How:** Ferry from Puerto Madero
- **Bring:** Passport (it's another country!)
- **Note:** Book ferry ahead in summer

### Estancia (Ranch)

- **Book ahead:** Most require reservations
- **Includes:** Usually lunch, gaucho show, horse ride
- **Wear:** Comfortable clothes, closed shoes

---

## Seasonal Tips

### Summer (Dec-Feb)

- **January:** Many portenos leave, some closures
- **Heat:** 30-35C, humid
- **Stay hydrated**
- **Siesta hours:** 2-5pm things slow down
- **Beach trip:** Consider Mar del Plata

### Winter (Jun-Aug)

- **Cold:** 5-15C, feels colder
- **Heating:** Buildings often poorly heated
- **Layer up**
- **Rain:** More common
- **Indoor activities:** Museums, cafes, tango

### Shoulder (Mar-May, Sep-Nov)

- **Best weather:** 15-25C
- **Fewer crowds**
- **Jacarandas:** November = purple flowers everywhere

---

## Common Scams

### To Watch For

| Scam | How It Works | Prevention |
|------|--------------|------------|
| Mustard scam | Someone "spills" on you, accomplice helps/steals | Keep walking, don't engage |
| Fake police | Ask to see wallet for "drug check" | Real police don't do this |
| Taxi meter | Rigged or "broken" meter | Use Uber or agree price first |
| Money switch | Give good bill, get bad bill "back" | Count your money |
| ATM helpers | "Help" you, steal info | Use ATMs inside banks |

### General Prevention

- Look confident, purposeful
- Don't stop for strangers offering help
- Research prices before buying
- Trust your instincts
