# Buenos Aires Immigration & Visas

## The Reality

Argentina has historically been very welcoming to immigrants and has relatively accessible paths to long-term residence. For digital nomads and remote workers, the country operates in a gray zone-technically you need work authorization, but enforcement is minimal for those not working locally.

**Key characteristics:**
- **90-day tourist entry** - Renewable once for another 90 days
- **Visa runs common** - Colonia del Sacramento is 1 hour away
- **Digital nomad visa** - Launched 2022, underutilized
- **Residency accessible** - Multiple paths, not impossible
- **Citizenship fast** - 2 years residency (among fastest globally)
- **Ancestry routes** - Italian/Spanish heritage = easier paths

## Tourist Entry

### The Basic 90 Days

| Passport | Visa Required | Stay |
|----------|---------------|------|
| US, EU, UK, Canada, Australia | No | 90 days |
| Most Americas | No | 90 days |
| Others | Check | Varies |

### The 90+90 System

| Step | Details |
|------|---------|
| **Entry** | 90 days granted at immigration |
| **Extension** | Go to Migraciones, pay ~$100 USD, get 90 more |
| **Total** | 180 days per entry |
| **Then what** | Must leave country, can return immediately |

**How to extend:**
1. Go to Direccion Nacional de Migraciones
2. Locations: Retiro (main), some regional offices
3. Pay fee (in pesos, bring cash)
4. Get stamp, enjoy 90 more days

### Visa Runs

| Destination | Time | Cost | Notes |
|-------------|------|------|-------|
| **Colonia, Uruguay** | 1 hour ferry | $80-150 RT | Most popular, can do day trip |
| **Montevideo, Uruguay** | 3 hour ferry | $100-200 RT | Stay overnight, nice city |
| **Montevideo (bus)** | 8-10 hours | $40-60 RT | Budget option |
| **Santiago, Chile** | 2h flight | $100-200 RT | If you want a longer trip |
| **Asuncion, Paraguay** | Varies | Cheap | Less common |

**Colonia day trip strategy:**
- Morning Buquebus or Colonia Express ferry
- Walk around colonial town (UNESCO site)
- Lunch
- Evening ferry back
- Immigration stamp = fresh 90 days

**Frequency limit:** No legal limit on re-entries. People do visa runs for years. Immigration may question if too frequent, but rare.

## Digital Nomad Visa (Nomada Digital)

### Overview

| Aspect | Details |
|--------|---------|
| **Launched** | May 2022 |
| **Duration** | 6 months, extendable to 12 |
| **Work allowed** | Remote work for non-Argentine companies |
| **Extensions** | One 6-month extension possible |
| **Path to residency** | No direct path, but shows intent |

### Requirements

| Requirement | Details |
|-------------|---------|
| **Income proof** | ~$1,500 USD/month minimum (3x minimum wage) |
| **Employment proof** | Contract, invoices, or business ownership |
| **Health insurance** | Coverage valid in Argentina |
| **Clean record** | No criminal background |
| **Passport valid** | 18+ months recommended |

### Application Process

1. **Online application** - Through Migraciones portal
2. **Document upload** - Apostilled documents may be needed
3. **Payment** - Processing fee ~$200 USD
4. **Wait** - Processing time varies (weeks to months)
5. **Approval** - Travel within validity window

### Reality Check

| Aspect | Reality |
|--------|---------|
| **Uptake** | Low-many just do tourist visa runs |
| **Advantages** | Legal peace of mind, 6-12 months |
| **Disadvantages** | Bureaucratic, not a path to residency |
| **Worth it?** | If you want to be fully legal and stay 6-12 months |

**Key insight:** Most digital nomads skip this and do tourist entries + visa runs. The DN visa is more useful if you want official status or plan to eventually pursue residency.

## Work Visa (Employer Sponsored)

### Overview

| Aspect | Details |
|--------|---------|
| **Type** | Temporary residency, work-authorized |
| **Sponsor** | Must have Argentine employer |
| **Duration** | 1-3 years, renewable |
| **Path** | Leads to permanent residency |

### Requirements

| Requirement | Details |
|-------------|---------|
| **Job offer** | From registered Argentine company |
| **Contract** | In Spanish, specific requirements |
| **Company standing** | Employer must be compliant with AFIP |
| **Your documents** | Apostilled degree, background check, etc. |

### Process

| Step | Time |
|------|------|
| Employer initiates | Variable |
| Document gathering | 1-2 months |
| Migraciones application | 2-4 months |
| DNI appointment | After approval |
| **Total** | 3-6 months typical |

**Reality:** Getting a local job offer is the hard part. Once you have it, the process works.

## Residency Paths

### Overview of Options

| Path | Difficulty | Time to Residency | Notes |
|------|------------|-------------------|-------|
| **Rentista** | Medium | 1-2 years temp, then permanent | Prove income |
| **Investment** | Medium | 1-2 years temp | Prove investment |
| **Work visa** | Medium | 1-3 years temp | Need employer |
| **Marriage to Argentine** | Easier | 1 year temp | Spouse sponsors |
| **MERCOSUR** | Easy | Immediate temp | If from member country |
| **Italian ancestry** | Separate track | Via citizenship | Very popular |
| **Spanish ancestry** | Separate track | Via citizenship | Also popular |

### Rentista Visa (Passive Income)

| Aspect | Details |
|--------|---------|
| **Income required** | ~$2,500 USD/month proven |
| **Source** | Investments, pensions, remote work contracts |
| **Proof** | Bank statements, contracts, accountant letter |
| **Duration** | 1 year temp, renewable to permanent |

**Best for:** Retirees, investors, established remote workers.

### Investment Path

| Aspect | Details |
|--------|---------|
| **Amount** | No fixed minimum, but meaningful |
| **Types** | Business, real estate, capital investment |
| **Proof** | Documentation of investment |
| **Benefit** | Shows economic ties to Argentina |

### MERCOSUR Citizens

| Country | Process |
|---------|---------|
| Brazil, Uruguay, Paraguay, Chile, etc. | Simplified residency |
| **Requirement** | Passport from member country |
| **Timeline** | 2-year temp, then permanent |
| **Process** | Much faster than other paths |

## DNI (National ID)

### Types

| Type | Who | Duration |
|------|-----|----------|
| **DNI Extranjero Temporario** | Temp residents | While residency valid |
| **DNI Extranjero Permanente** | Permanent residents | Indefinite |

### Why It Matters

| With DNI | Without DNI |
|----------|-------------|
| Open bank accounts | Tourist accounts only |
| Sign contracts | Limited |
| Get phone plan | Only prepaid |
| Healthcare (obra social) | Private only |
| Work legally | Gray area |
| Eventually citizenship | Not possible |

### Getting DNI After Residency Approval

1. **Schedule appointment** - Via RENAPER system
2. **Visit registry** - With documents
3. **Biometrics** - Photo, fingerprints
4. **Receive DNI** - Mailed or pickup
5. **Timeline** - 2-4 weeks

## Citizenship

### The 2-Year Path

| Aspect | Details |
|--------|---------|
| **Residency requirement** | 2 years continuous legal residence |
| **One of fastest globally** | Compare to 5+ years in most countries |
| **Dual citizenship** | Allowed |
| **Benefits** | Argentine/MERCOSUR passport, voting, full rights |

### Requirements

| Requirement | Details |
|-------------|---------|
| **2 years residency** | Documented, temp or permanent |
| **Continuous presence** | No extended absences |
| **Basic Spanish** | Conversational level |
| **Good conduct** | No serious issues |
| **Civic knowledge** | Basic Argentine history/civics |

### Process

| Step | Timeline |
|------|----------|
| Apply at federal court | After 2 years residency |
| Document submission | Varies |
| Interview/exam | Spanish and civics |
| Judge decision | 6-18 months |
| Swearing in | Final step |
| **Total** | 2.5-4 years from residency start |

## Ancestry Paths

### Italian Citizenship (Jure Sanguinis)

| Aspect | Details |
|--------|---------|
| **Eligibility** | Unbroken Italian ancestry, no naturalizations breaking chain |
| **Process in Argentina** | Can apply at Italian consulate |
| **Wait times** | Years (long queue in BA) |
| **Alternative** | Apply in Italy (faster but requires residence) |
| **Result** | Italian/EU citizenship, independent of Argentina |

**Why popular in BA:** Huge Italian diaspora. Many Argentines + expats qualify.

### Spanish Citizenship

| Path | Details |
|------|---------|
| **Grandchildren** | Nationality for grandchildren of Spanish emigrants |
| **Residents** | 2 years residency in Argentina (LatAm country) counts |
| **Sephardic** | Special path for Sephardic Jewish ancestry |
| **Result** | Spanish/EU citizenship |

## Practical Tips

### For Digital Nomads

| Strategy | Recommended For |
|----------|-----------------|
| **Tourist + visa runs** | 1-2 years, minimal hassle |
| **Digital nomad visa** | Want legal status, 6-12 months |
| **Rentista** | Long-term, have income proof |

### For Future Residents

| Step | Timing |
|------|--------|
| 1. Enter on tourist | Immediately |
| 2. Consult immigration lawyer | Month 1 |
| 3. Gather apostilled documents | Months 1-3 |
| 4. Apply for temp residency | Month 3-4 |
| 5. Receive DNI | Month 6-8 |
| 6. Start 2-year citizenship clock | From temp residency |

### Document Preparation

| Document | Notes |
|----------|-------|
| **Birth certificate** | Apostilled |
| **Background check** | FBI/national equivalent, apostilled |
| **Marriage certificate** | If applicable, apostilled |
| **Degrees** | Apostilled, sometimes translated |
| **Passport** | Valid 18+ months |

**Apostille:** Required for most foreign documents. Done in country of origin.

## Costs

| Item | Cost USD |
|------|----------|
| Tourist extension | ~$100 |
| Visa run (Colonia) | $80-150 |
| Digital nomad visa | ~$200 |
| Residency application | $200-400 |
| Immigration lawyer | $1,000-3,000 |
| DNI processing | Minimal |
| Citizenship application | $200-500 |

## Resources

| Resource | Purpose |
|----------|---------|
| **argentina.gob.ar/migraciones** | Official immigration |
| **RENAPER** | DNI appointments |
| **Expat Facebook groups** | Lived experiences |
| **Immigration lawyers** | Complex cases |

**Final advice:** Argentina wants immigrants. The paths exist and are achievable. Start with tourist status, see if you like it, then formalize if you decide to stay. The 2-year citizenship path is genuinely one of the best in the world.
