# Buenos Aires Transport Guide

## Overview

Buenos Aires has excellent public transport, especially for a South American city. Most visitors won't need a car.

### Transport Options Summary

| Mode | Best For | Cost |
|------|----------|------|
| Subte (metro) | Quick cross-town | ~$0.40/ride |
| Colectivo (bus) | Everywhere, 24/7 | ~$0.30/ride |
| Taxi | Night, luggage | $5-15/trip |
| Uber/Cabify | Convenience | ~Taxi price |
| Train | Suburbs, day trips | Very cheap |
| Walking | Central areas | Free |
| Bike | Palermo, Puerto Madero | Free city bikes |

---

## SUBE Card (Essential)

### What Is It?

Rechargeable card required for all public transit (subte, bus, train).

### How to Get

| Where | Notes |
|-------|-------|
| Subte stations | Most have kiosks |
| Kioscos (corner stores) | Ask " Tiene SUBE?" |
| Loterias | Some have them |
| Online | Can order, slower |

**Cost:** ~$1 for card

### How to Charge

| Where | How |
|-------|-----|
| Subte machines | Cash or card |
| Kioscos | Cash only ("Cargar SUBE") |
| Apps | Bank apps, some wallets |

**Tip:** Keep ~$5-10 loaded. Low balance = can't board.

---

## Subte (Metro)

### The Network

| Line | Color | Route | Useful For |
|------|-------|-------|------------|
| A | Cyan | Plaza de Mayo -> San Pedrito | Centro to west |
| B | Red | L.N. Alem -> Juan Manuel de Rosas | Centro to Villa Urquiza |
| C | Blue | Constitucion -> Retiro | North-south, connects stations |
| D | Green | Catedral -> Congreso de Tucuman | Centro to Palermo, Belgrano |
| E | Purple | Bolivar -> Plaza de los Virreyes | Centro to south |
| H | Yellow | Hospitales -> Facultad de Derecho | East-west, Recoleta |

### Line D is Your Friend

Most tourist areas: Centro -> Recoleta -> Palermo -> Belgrano

### Hours

| Day | Hours |
|-----|-------|
| Monday-Saturday | 5:30am-10:30pm |
| Sunday/Holiday | 8:00am-10:00pm |

**Note:** Reduced service Sundays. Last trains earlier than posted.

### Tips

- **Rush hour:** 8-9:30am, 6-8pm - packed
- **Enter/exit:** Follow arrows, stand right on escalators
- **Security:** Keep bag in front
- **Signal:** None underground, save messages for above
- **Heat:** Summer can be brutal, no AC on old trains

### Fare (Feb 2026)

~$0.40-0.50 USD per ride. Discount for transfers.

---

## Colectivos (Buses)

### Overview

140+ routes covering the entire city, 24/7 on many lines.

### How to Use

1. **Find your stop:** Signs or shelters
2. **Know your line number:** Posted on bus front
3. **Signal the driver:** Wave or hand out
4. **Board front:** Tell driver your destination (helps with fare)
5. **Pay:** SUBE card on reader
6. **Exit:** Middle or rear doors
7. **Ring bell:** Before your stop

### Key Routes for Tourists

| Route | Connects |
|-------|----------|
| 152 | Recoleta -> Centro -> San Telmo -> La Boca |
| 29 | Centro -> Palermo -> Belgrano |
| 59 | Centro -> Palermo -> Nunez |
| 130 | Palermo -> San Telmo -> Puerto Madero |
| 93 | Centro -> Recoleta |

### Apps for Routes

- **BA Como Llego:** Official city app
- **Moovit:** Good alternative
- **Google Maps:** Works well

### Tips

- **Cash not accepted:** SUBE only
- **Night buses:** Many run 24h
- **Stops aren't always marked:** Know your destination
- **Say "Permiso":** When pushing through

---

## Taxis

### How to Use

**Street hail:**
- Look for black/yellow taxis
- "Libre" sign lit = available
- Enter, tell destination
- Confirm meter is running

**Radio taxi (safer):**
- Call ahead: Radio Taxi Premium, Pidalo, etc.
- App booking available
- Pre-arranged = safer

### Fares (USD at Blue Rate)

| Trip | Approximate |
|------|-------------|
| Palermo to Centro | $5-8 |
| Palermo to San Telmo | $6-10 |
| Centro to Ezeiza airport | $25-40 |
| Centro to Aeroparque | $8-12 |

### Tips

- **Meter:** Must be running
- **Small bills:** Drivers often "don't have change"
- **Receipt:** Ask "factura" if needed
- **Night surcharge:** 20% after 10pm
- **Scam prevention:** Know rough fare, count change

### Common Scams

| Scam | Prevention |
|------|------------|
| Long route | Know basic directions |
| Broken meter | Agree price first or exit |
| Bill switch | Watch your bills |
| "No change" | Carry small bills |

---

## Uber & Cabify

### Status

Technically gray area legally, but widely used and functional.

### Pros

- Fixed price shown upfront
- No cash needed
- Route tracked
- Driver ratings
- Receipt automatic

### Cons

- Drivers may ask you to sit in front (less obvious)
- Surge pricing during events
- Some areas drivers won't go

### Tips

- **Pin location carefully:** BA addresses can be confusing
- **Message driver:** WhatsApp common
- **Preferred:** Cabify often has better drivers

---

## Trains

### When to Use

- Day trips (Tigre, San Isidro)
- Suburbs
- Cheaper than bus for longer distances

### Main Lines

| Line | Destination | Departs From |
|------|-------------|--------------|
| Mitre | Tigre, Belgrano | Retiro |
| San Martin | Pilar, suburbs | Retiro |
| Belgrano Norte | North suburbs | Retiro |
| Sarmiento | West (Moreno) | Once |
| Roca | South (La Plata) | Constitucion |

### Safety

- **Retiro area:** Fine during day, careful at night
- **Constitucion:** More sketchy, don't linger
- **On trains:** Keep belongings close

---

## Walking

### Best Areas to Walk

| Area | Walkability |
|------|-------------|
| Palermo Soho/Hollywood | Excellent |
| Recoleta | Excellent |
| San Telmo | Good (cobblestones) |
| Puerto Madero | Excellent (flat) |
| Centro | Good (busy) |
| Belgrano | Good |

### Pedestrian Warnings

- **Sidewalks:** Often uneven, broken
- **Dog poop:** Watch your step (seriously)
- **Crossings:** Cars don't always stop
- **Cobblestones:** Hard on feet, avoid heels
- **Phone:** Don't walk looking at it

---

## Cycling

### Ecobici (City Bikes)

Free bike-share system.

**How to use:**
1. Register at ecobici.buenosaires.gob.ar
2. Get card or use app
3. Unlock at station
4. Return to any station

**Rules:**
- Free for rides under 30 minutes
- Charge for longer
- Many stations in Palermo, Recoleta, Centro

### Bike Lanes

Expanding network, especially:
- Palermo parks
- Puerto Madero
- Some main avenues

### Safety

- Helmet not required but recommended
- Lock bike ALWAYS (theft common)
- Night riding: lights required
- Traffic can be aggressive

---

## Airport Transfers

### Ezeiza (EZE) - International

**Distance:** 35km from Centro

| Option | Time | Cost (USD) |
|--------|------|------------|
| Official taxi (Tienda Leon) | 45-60 min | $35-45 |
| Regular taxi | 45-60 min | $25-40 |
| Uber/Cabify | 45-60 min | $20-35 |
| Tienda Leon bus | 60-90 min | $10-15 |
| Public bus (8) | 2+ hours | $1 |

**Recommendation:** Tienda Leon or Uber for first visit.

### Aeroparque (AEP) - Domestic

**Distance:** 5km from Centro

| Option | Time | Cost (USD) |
|--------|------|------------|
| Taxi | 15-30 min | $8-12 |
| Uber/Cabify | 15-30 min | $6-10 |
| Bus (33, 45) | 30-45 min | $0.50 |

---

## Driving (Not Recommended)

### Why Avoid

- Aggressive drivers
- Confusing streets
- Parking nightmare
- Cheaper to taxi/Uber
- Insurance complications

### If You Must

- **License:** International + home license
- **Rental:** Available at airports
- **Insurance:** Get full coverage
- **Parking:** Use garage (robo common on street)
- **Traffic:** Terrible 7-10am, 5-8pm

---

## Getting to Nearby Cities

### Bus (Long Distance)

- **Terminal:** Retiro bus station
- **Book:** busbud.com or terminal
- **Quality:** Semicama (semi-recline) or Cama (full bed)
- **Destinations:** Mendoza (14h), Bariloche (20h), Cordoba (10h)

### Plane

- **Domestic flights:** From Aeroparque
- **Airlines:** Aerolineas Argentinas, Flybondi, JetSmart
- **Book early:** Cheaper

### Ferry to Uruguay

- **To Colonia:** 1-3 hours, Buquebus or Colonia Express
- **To Montevideo:** 3+ hours or ferry + bus
- **From:** Puerto Madero terminals
