# Buenos Aires Tech Industry Guide

## Overview

Buenos Aires is **Latin America's leading tech hub**, with a thriving startup ecosystem, strong developer talent, and growing international presence.

### Key Stats (2025-2026)

| Metric | Data |
|--------|------|
| Tech workers | 100,000+ in metro area |
| Startups | 10,000+ active |
| Unicorns | 10+ (Mercado Libre, Globant, Auth0, etc.) |
| VC funding | $1B+ annually |
| Growth | 20%+ year-over-year |

---

## Tech Hubs & Areas

### Where Tech Works

| Area | Companies | Vibe |
|------|-----------|------|
| Palermo | Startups, agencies | Hip, cafes |
| Belgrano | Tech offices | Professional |
| Puerto Madero | Corporates | Corporate |
| Microcentro | Banks, fintech | Traditional |
| Villa Crespo | Emerging startups | Up-and-coming |

### Coworking for Tech

| Space | Best For | Cost/Month |
|-------|----------|------------|
| WeWork | Funded startups, corporates | $150-300 |
| Urban Station | Early-stage, freelancers | $100-150 |
| La Maquinita | Creative tech | $80-120 |
| Nube Coworking | Budget | $60-100 |
| Selina | Digital nomads | $150-200 |

---

## Salary Guide (2025-2026)

### In Argentine Pesos (Local Contracts)

| Role | Monthly (USD Equivalent) |
|------|--------------------------|
| Junior Developer | $800-1,500 |
| Mid Developer | $1,500-2,500 |
| Senior Developer | $2,500-4,000 |
| Tech Lead | $3,500-5,500 |
| Engineering Manager | $4,000-7,000 |
| CTO (startup) | $5,000-10,000 |

**Note:** Paid in pesos, subject to inflation. Companies often adjust.

### For Remote/International Companies (USD)

| Role | Monthly (USD) |
|------|---------------|
| Junior Developer | $2,000-3,500 |
| Mid Developer | $3,500-5,500 |
| Senior Developer | $5,000-8,000 |
| Staff/Principal | $8,000-12,000 |
| Tech Lead | $7,000-10,000 |
| Engineering Manager | $9,000-14,000 |

**Note:** Paid in USD, massive advantage with blue dollar.

### By Technology (Senior Level, International)

| Stack | Monthly (USD) |
|-------|---------------|
| React/Node | $5,000-8,000 |
| Python/ML | $6,000-10,000 |
| Golang | $6,000-9,000 |
| iOS/Android | $5,000-8,000 |
| DevOps/SRE | $5,500-9,000 |
| Data Science | $6,000-10,000 |
| Blockchain | $7,000-12,000 |

---

## Employment Types

### Local Employment

| Type | Pros | Cons |
|------|------|------|
| Full-time employee | Benefits, stability | Peso salary, taxes |
| Contract | More flexibility | Less security |
| Freelance | Tax benefits possible | Self-managed |

### International Remote

| Arrangement | Notes |
|-------------|-------|
| Direct contractor | Most common, invoice company |
| Employer of Record (EOR) | Companies like Deel, Remote.com |
| Through local entity | Some companies set up local |
| Freelance platforms | Toptal, Turing, etc. |

### The USD Arbitrage

**Why remote work is powerful in BA:**
- $5,000/month USD = top 5% income
- $8,000/month USD = luxury lifestyle
- $3,000/month USD = very comfortable
- Cost of living: $1,500-2,500/month

---

## Major Companies

### Argentine Unicorns/Success Stories

| Company | Type | Notes |
|---------|------|-------|
| Mercado Libre | E-commerce | LATAM's Amazon, huge employer |
| Globant | Services | IT services giant |
| Auth0 | Identity | Acquired by Okta |
| Uala | Fintech | Banking app |
| Vercel | Dev tools | Next.js company |
| Mural | Collaboration | Visual collaboration |
| Tiendanube | E-commerce | Shopify of LATAM |
| Bitfarms | Crypto | Mining |

### International Companies with BA Presence

| Company | Office Type |
|---------|-------------|
| Google | Large office |
| Microsoft | Regional HQ |
| IBM | Large office |
| Accenture | Large |
| JP Morgan | Tech hub |
| Salesforce | Growing |
| Oracle | Regional |

### Growing Startups (2025-2026)

Focus areas:
- Fintech (huge sector)
- Agtech (agricultural tech)
- Edtech
- Healthcare
- Logistics
- Crypto/Web3

---

## Finding Tech Jobs

### Job Platforms

| Platform | Type | Notes |
|----------|------|-------|
| LinkedIn | All | Primary for international |
| GetonBoard | LATAM tech | Quality listings |
| Bumeran | Local | Larger companies |
| Glassdoor | Reviews + jobs | Good for research |
| StackOverflow | Tech-specific | Remote options |
| Wellfound (AngelList) | Startups | Equity opportunities |

### Remote Job Platforms

| Platform | Notes |
|----------|-------|
| Toptal | Selective, high pay |
| Turing | AI matching |
| RemoteOK | Aggregator |
| We Work Remotely | Quality |
| Arc.dev | Developers |

### Networking

| Method | Where |
|--------|-------|
| Tech meetups | Meetup.com, Eventbrite |
| Startup events | Buenos Aires Tech Scene |
| Coworking | Natural networking |
| Online communities | Discord, Slack groups |

---

## Tech Education & Upskilling

### Coding Bootcamps

| Bootcamp | Focus | Notes |
|----------|-------|-------|
| Digital House | Full-stack, data | Largest |
| Henry | Full-stack | ISA model |
| Plataforma 5 | JavaScript | Intensive |
| Coderhouse | Various | Flexible |
| Acamica | Product, design | Digital |

### Universities

| University | Tech Program |
|------------|--------------|
| UBA (public) | Computer Science, free |
| ITBA | Engineering, private |
| Universidad de San Andres | Business + tech |
| UTN | Technical, public |

### Certifications

All major certifications available:
- AWS
- Google Cloud
- Azure
- Various programming certs

---

## Tech Culture

### Work Style

| Aspect | Reality |
|--------|---------|
| Hours | Often flexible |
| Remote | Very common post-COVID |
| Dress code | Casual in tech |
| Hierarchy | Flatter than traditional |
| English | Required for international |

### Tech Events

| Event | When | Notes |
|-------|------|-------|
| Nerdearla | Annual | Major tech conference |
| NodeConf Argentina | Annual | Node.js community |
| PyConAr | Annual | Python community |
| Startup Weekend | Regular | Entrepreneurship |
| Various meetups | Weekly | Many languages/topics |

### Tech Community

Strong, welcoming community:
- Active meetup scene
- Knowledge sharing culture
- Open source contributors
- International connections

---

## Freelance & Consulting

### Platforms

| Platform | For |
|----------|-----|
| Toptal | High-end |
| Upwork | General |
| Freelancer | Various |
| Local agencies | Projects |
| Direct clients | Networking |

### Rates

| Level | Hourly (USD) |
|-------|--------------|
| Junior | $25-40 |
| Mid | $40-70 |
| Senior | $70-120 |
| Expert/Specialist | $120-200+ |

### Legal Setup

| Structure | Notes |
|-----------|-------|
| Monotributista | Simple tax regime, limits apply |
| Responsable Inscripto | Higher limits, more complex |
| LLC (SAS) | Company structure |
| Invoice abroad | USD, various methods |

---

## Challenges

### Local Employment Challenges

| Challenge | Reality |
|-----------|---------|
| Inflation | Peso salaries erode |
| Taxes | High on employment |
| Currency controls | Receiving USD complicated |
| Benefits | Varying quality |

### Remote Work Challenges

| Challenge | Solution |
|-----------|----------|
| Payment | Crypto, Wise, Payoneer |
| Tax complexity | Accountant essential |
| Time zones | US-friendly (1-5 hours) |
| Isolation | Coworking, meetups |

---

## Starting a Tech Company

### Common Structures

| Structure | For |
|-----------|-----|
| SAS (Sociedad por Acciones Simplificada) | Startups, quick setup |
| SRL | Traditional, more complex |
| Delaware C-Corp | VC-backed, international |

### Startup Ecosystem

| Resource | Type |
|----------|------|
| NXTP Labs | VC, accelerator |
| Endeavor | Scale-up support |
| Wayra | Telefonica accelerator |
| ARCAP | Angel investor network |
| Ciudad de Buenos Aires | Government programs |

### Costs

| Item | Range |
|------|-------|
| Company formation (SAS) | $500-2,000 |
| Monthly accounting | $100-300 |
| Coworking | $100-300 |
| Legal (when needed) | $100-200/hour |
