# Buenos Aires Startup Guide

## Ecosystem Overview

Buenos Aires is **the startup capital of Latin America**, with more unicorns per capita than any other LATAM city.

### Why Buenos Aires?

| Factor | Advantage |
|--------|-----------|
| Talent | Large pool of developers, designers |
| Cost | Low burn rate vs US/Europe |
| Time zone | Americas-friendly |
| Culture | Entrepreneurial, resilient |
| Track record | Proven exits (MercadoLibre, Auth0) |

### Key Stats (2025-2026)

| Metric | Data |
|--------|------|
| Active startups | 10,000+ |
| Unicorns | 10+ |
| Annual VC investment | $1B+ |
| Tech workers | 100,000+ |
| Accelerators | 50+ |

---

## Starting Up

### Company Structures

| Structure | Best For | Setup Time | Cost |
|-----------|----------|------------|------|
| SAS | Most startups | 1-2 weeks | $500-1,500 |
| SRL | Traditional business | 1-2 months | $1,000-3,000 |
| Delaware C-Corp | VC-backed | 1 week (US) | $1,000-2,000 |
| Sole proprietor | Freelance testing | 1 day | Minimal |

### The Delaware Question

**Most VC-backed startups incorporate in Delaware** (USA):
- Standard for US investors
- Cleaner cap table management
- Established legal framework
- Argentine subsidiary for operations

### SAS (Sociedad por Acciones Simplificada)

Argentina's startup-friendly structure:
- Quick registration (online)
- Flexible bylaws
- Single shareholder OK
- Low minimum capital
- Can receive investment

### Registration Process (SAS)

| Step | Time | Cost |
|------|------|------|
| Reserve company name | 1 day | Minimal |
| Digital signature | 1-2 days | $50 |
| Online registration | 1-2 days | $200-400 |
| CUIT (tax ID) | 1-3 days | Free |
| Bank account | 1-2 weeks | Varies |

**Total:** 2-3 weeks for fully operational company

---

## Funding Landscape

### Funding Stages in BA

| Stage | Typical Amount | Sources |
|-------|----------------|---------|
| Pre-seed | $50K-250K | Angels, friends, accelerators |
| Seed | $250K-2M | Local VCs, some US VCs |
| Series A | $2M-15M | Regional + US VCs |
| Series B+ | $15M+ | Mostly international VCs |

### Notable VCs (LATAM-Focused)

| VC | Stage | Notes |
|----|-------|-------|
| NXTP Labs | Seed, Series A | BA-based, very active |
| Kaszek | All stages | Largest LATAM VC |
| Globant Ventures | Growth | Corporate VC |
| Endeavor Catalyst | Growth | Co-investment |
| ALLVP | Seed, A | Mexico + LATAM |
| Magma Partners | Seed | Chile + LATAM |
| Monashees | All | Brazil + LATAM |

### Angel Networks

| Network | Notes |
|---------|-------|
| ARCAP | Argentine angel association |
| IAE Angels | Business school network |
| Endeavor | High-net-worth network |
| Personal networks | Very important in BA |

### International Investors Active in BA

| Investor | Stage |
|----------|-------|
| Andreessen Horowitz (a16z) | Growth |
| SoftBank | Late stage |
| Tiger Global | Growth |
| General Catalyst | Various |
| Y Combinator | Seed (many BA alumni) |

---

## Accelerators & Programs

### Top Accelerators

| Program | Type | Notes |
|---------|------|-------|
| Y Combinator | Remote/US | Many BA founders |
| 500 Global | Remote/US | LATAM cohorts |
| Wayra | Corporate | Telefonica |
| NXTP Labs | Local | Largest in region |
| Parallel18 | Puerto Rico | LATAM focus |
| Start-Up Chile | Chile | Strong program |

### Government Programs

| Program | Offers |
|---------|--------|
| Buenos Aires Ciudad | Grants, coworking |
| Startup Argentina | Federal support |
| FONTAR | Innovation grants |
| Academia BA Emprende | Training |

### University Programs

| University | Program |
|------------|---------|
| Universidad de San Andres | Entrepreneurship center |
| IAE Business School | MBA entrepreneurship |
| ITBA | Tech startups |
| UBA | Various initiatives |

---

## Building a Team

### Finding Talent

| Source | Best For |
|--------|----------|
| LinkedIn | All roles |
| GetonBoard | Tech |
| Personal network | Critical hires |
| University partnerships | Junior talent |
| Meetups | Tech specialists |

### Compensation Structures

| Component | Notes |
|-----------|-------|
| Base salary | Peso or USD indexed |
| Equity | Stock options common |
| Benefits | Health, meals, education |
| Remote flexibility | Expected now |

### Equity Considerations

| Factor | Reality |
|--------|---------|
| Standard vesting | 4 years, 1-year cliff |
| Pool size | 10-20% typical |
| Argentine law | Stock options complex |
| Delaware | Cleaner for options |

### Employment Costs

| Component | Approximate |
|-----------|-------------|
| Salary | Base |
| Employer taxes | ~30-35% of salary |
| Benefits | Variable |
| Total cost | ~1.4-1.5x salary |

---

## Operational Costs

### Monthly Burn (Early Stage)

| Item | Range (USD) |
|------|-------------|
| Coworking (5 people) | $500-1,000 |
| Salaries (5 tech) | $15,000-25,000 |
| Legal/accounting | $200-500 |
| Software/tools | $500-1,000 |
| Marketing | Variable |
| Misc | $500-1,000 |
| **Total** | **$17,000-28,000** |

### Comparison to US

| Cost | Buenos Aires | San Francisco |
|------|--------------|---------------|
| Senior developer | $5,000/mo | $15,000/mo |
| Office space/person | $100-200/mo | $500-1,000/mo |
| Total burn | 40-60% less | Baseline |

---

## Legal & Accounting

### Essential Professionals

| Role | When to Hire |
|------|--------------|
| Accountant (contador) | Day 1 |
| Corporate lawyer | For incorporation |
| Employment lawyer | When hiring |
| IP lawyer | When relevant |

### Costs

| Service | Monthly/One-time |
|---------|------------------|
| Accounting | $100-300/month |
| Legal retainer | $200-500/month |
| Company formation | $500-2,000 (one-time) |
| Cap table management | Use software |

### Compliance Requirements

| Requirement | Frequency |
|-------------|-----------|
| Tax filings | Monthly/Annual |
| Payroll taxes | Monthly |
| Annual financial statements | Yearly |
| Board minutes | As needed |

---

## Intellectual Property

### Protection Available

| Type | Notes |
|------|-------|
| Trademarks | Local + international |
| Patents | Available, slower process |
| Copyrights | Automatic protection |
| Trade secrets | Contractual protection |

### Process

| IP Type | Time | Cost |
|---------|------|------|
| Trademark | 6-18 months | $500-1,500 |
| Patent | 2-5 years | $3,000-10,000 |

**Recommendation:** Start with US/international IP for global products.

---

## Startup Community

### Events

| Event | When | Notes |
|-------|------|-------|
| Nerdearla | Annual | Major tech conference |
| Startup Weekend | Regular | 54-hour events |
| Demo Days | Various | Accelerator showcases |
| Founder meetups | Weekly | Various groups |

### Communities

| Group | Platform |
|-------|----------|
| Startups Argentina | Slack |
| BA Tech | Various |
| Founder circles | Private groups |
| Endeavor network | Selective |

### Coworking as Community

Major coworking spaces host:
- Pitch nights
- Mentor office hours
- Networking events
- Educational workshops

---

## Scaling from BA

### Regional Expansion

| Market | Considerations |
|--------|----------------|
| Brazil | Huge but complex, needs local |
| Mexico | Large, Spanish-speaking |
| Colombia | Growing, accessible |
| Chile | Stable, smaller |

### US Expansion

| Element | Approach |
|---------|----------|
| Entity | Delaware C-Corp |
| Sales | Remote initially |
| Hiring | Contractors, then employees |
| Fundraising | Makes VC easier |

### Success Stories

| Company | Exit/Status |
|---------|-------------|
| MercadoLibre | $50B+ market cap |
| Globant | $8B+ market cap |
| Auth0 | Acquired $6.5B |
| Vercel | $2.5B+ valuation |
| Uala | Unicorn status |

---

## Challenges & Solutions

### Common Challenges

| Challenge | Solution |
|-----------|----------|
| Currency instability | USD contracts, crypto |
| Capital controls | Delaware entity |
| Tax complexity | Good contador |
| Brain drain | Competitive offers |
| Bureaucracy | Professional help |

### Why It Works Anyway

- Resilient, adaptable founders
- Strong technical talent
- Lower costs enable longer runway
- Regional market access
- Proven exit path
