# Buenos Aires Safety Guide

## Overall Assessment

Buenos Aires is **relatively safe** for a major Latin American city. Most visitors have no issues. However, petty crime is common and requires street smarts.

### Safety Comparison

| City | Safety Level |
|------|--------------|
| Buenos Aires | Moderate (requires awareness) |
| Santiago | Slightly safer |
| S o Paulo | Less safe |
| Mexico City | Comparable |
| European capitals | Safer |

---

## Main Risks

### 1. Phone/Electronics Theft

**The #1 issue for tourists.**

| Risk Factor | Level |
|-------------|-------|
| Phone snatching | High |
| Laptop theft | Medium |
| Pickpocketing | Medium |

**Prevention:**
- Don't use phone obviously on street
- Keep phone in front pocket or bag
- Don't set phone on cafe table near street
- Consider cheap backup phone for navigation
- AirTag your devices

### 2. Pickpocketing

**Common areas:**
- Subte (metro) during rush hour
- San Telmo Sunday market
- Florida Street
- Any crowded area

**Prevention:**
- Front pockets only
- Bag in front of body
- Be aware in crowds
- Don't flash cash

### 3. Express Kidnapping (Secuestro Express)

**Rare but serious.** Victim taken briefly, forced to withdraw cash from ATMs.

**Prevention:**
- Don't display expensive jewelry/watches
- Use ATMs inside banks during business hours
- Be cautious of anyone following you
- Vary your routine

### 4. Taxi/Transit Scams

**Types:**
- Fake taxis
- Meter manipulation
- Bill switching

**Prevention:**
- Use Uber/Cabify
- Or radio taxis
- Know approximate fares
- Watch your bills

---

## Neighborhood Safety

### Generally Safe (Day & Night)

| Area | Notes |
|------|-------|
| Puerto Madero | Safest, security everywhere |
| Recoleta | Well-patrolled |
| Belgrano | Residential, quiet |
| Palermo (main areas) | Good, busy = safe |
| Nunez | Quiet residential |
| Las Canitas | Small, safe |

### Safe Day, Caution at Night

| Area | Day | Night |
|------|-----|-------|
| Palermo Soho | 4/5 | 4/5 (busy = OK) |
| Palermo Hollywood | 4/5 | 3/5 (late night caution) |
| San Telmo | 4/5 | 3/5 (main streets OK) |
| Villa Crespo | 4/5 | 3/5 |
| Centro/Microcentro | 3/5 | 2/5 (deserted, avoid) |
| Caballito | 4/5 | 3/5 |
| Almagro | 3/5 | 3/5 |

### Avoid or Exercise Extreme Caution

| Area | Recommendation |
|------|----------------|
| La Boca (beyond Caminito) | Avoid |
| Constitucion | Avoid |
| Once (at night) | Avoid |
| Villa 31 (Retiro) | Avoid |
| Flores (parts) | Research specific areas |
| Bajo Flores | Avoid |
| Villa Lugano | Avoid |

---

## Time-Based Safety

### Day vs Night

| Time | Risk Level | Notes |
|------|------------|-------|
| 6am-8pm | Lower | Normal caution |
| 8pm-midnight | Moderate | Stay in busy areas |
| Midnight-4am | Higher | Taxi between locations |
| 4am-6am | Highest | Avoid streets, taxi only |

### Late Night Safety

If out late:
1. **Pre-arrange transport** - Uber/taxi ready
2. **Stay in groups** - Safety in numbers
3. **Avoid dark streets** - Main roads only
4. **Don't walk drunk** - Take taxi
5. **Know your route** - Don't wander

---

## Common Scams

### The Mustard/Bird Poop Scam

**How it works:**
1. Someone "accidentally" spills mustard/liquid on you
2. Helpful stranger offers to clean you
3. Accomplice steals belongings during distraction

**Prevention:**
- Keep walking if splashed
- Don't let strangers touch you or your bags
- Say "No gracias" firmly and move

### Fake Police

**How it works:**
1. "Police" approach asking for documents
2. Request to see wallet to "check for counterfeit"
3. Steal money during "inspection"

**Reality:** Real police don't do random wallet checks.

**Prevention:**
- Real police have proper uniforms, credentials
- Never show wallet contents
- Ask to go to police station
- Insist on calling embassy

### ATM Helpers

**How it works:**
1. Someone offers to "help" at ATM
2. Watches your PIN or distracts
3. Card skimming or direct theft

**Prevention:**
- Use ATMs inside banks
- Never accept "help"
- Cover PIN pad
- Check for skimmers

### Restaurant Bill Padding

**How it works:**
- Extra items added to bill
- "Service charge" added unexpectedly
- Wrong exchange rate for card

**Prevention:**
- Check bill carefully
- Know prices of what you ordered
- Pay cash at blue rate

### Counterfeit Bills

**Risk:** Being given fake bills as change.

**Prevention:**
- Learn to recognize real bills (watermarks, feel)
- Check large bills
- Use Uber (no cash) to reduce risk

---

## ATM & Money Safety

### ATM Best Practices

| Do | Don't |
|----|-------|
| Use ATMs inside banks | Street ATMs at night |
| During business hours | Accept help from strangers |
| Cover your PIN | Use if looks tampered |
| Take receipt | Leave receipt behind |
| Check surroundings | Count cash at machine |

### Cash Carrying Tips

- **Spread money:** Don't keep all in one place
- **Decoy wallet:** Small amount in accessible pocket
- **Real money:** Hidden in bag/money belt
- **Daily amount:** Only carry what you need

---

## Women's Safety

### General

Buenos Aires is **generally safe for solo women**, but typical precautions apply.

### Specific Tips

| Situation | Advice |
|-----------|--------|
| Solo at night | Taxi, don't walk alone |
| Clubs | Watch your drink |
| Dating apps | Meet in public, tell someone |
| Catcalling | Common, usually harmless, ignore |
| Public transit | Rush hour can be grabby, stay alert |

### Avoiding Unwanted Attention

- "No gracias" is sufficient
- Don't engage with persistent advances
- Walk into a business if followed
- Fake phone call can help

---

## LGBTQ+ Safety

### Overview

Buenos Aires is the **most LGBTQ+-friendly city in Latin America**. Same-sex marriage legal since 2010.

### Safe Areas

- Palermo (especially Soho)
- San Telmo
- Recoleta
- Most central areas

### Caution

- Working-class outer neighborhoods may be less accepting
- PDA: Same rules as straight couples (modest is fine)
- Pride Month (November): Huge parade, very welcoming

---

## Emergency Contacts

| Service | Number |
|---------|--------|
| Police/Fire/Ambulance | 911 |
| Tourist Police | 0800-999-5000 |
| Medical Emergency | 107 |
| Fire | 100 |
| Ambulance (SAME) | 107 |

### Embassies

| Country | Phone |
|---------|-------|
| US Embassy | +54-11-5777-4533 |
| UK Embassy | +54-11-4808-2200 |
| Canadian Embassy | +54-11-4808-1000 |
| Australian Embassy | +54-11-4779-3500 |

---

## If Something Happens

### Theft/Robbery

1. **Don't resist** - Give up belongings
2. **Stay calm** - Your safety first
3. **Note details** - Description, direction fled
4. **Go to comisaria** - Nearest police station
5. **File denuncia** - Official report (for insurance)
6. **Contact embassy** - If passport stolen
7. **Cancel cards** - Immediately

### Lost Passport

1. File police report (denuncia)
2. Contact embassy
3. Get emergency travel document
4. May take 1-3 days

### Medical Emergency

1. Call 107 (SAME ambulance)
2. Or go to nearest hospital
3. Public hospitals: Free, can be crowded
4. Private clinics: Faster, need to pay

---

## Safety Apps & Resources

| App | Purpose |
|-----|---------|
| **911 BA** | Emergency services |
| **BA Como Llego** | Safe transit routing |
| **Uber/Cabify** | Safe transport |
| **WhatsApp** | Stay connected |
| **Maps.me** | Offline maps |

### Useful Tips

- **Share location** with someone you trust
- **Screenshot important info** (address, emergency contacts)
- **Travel insurance** - Get it
- **Register with embassy** - Smart Traveler Enrollment (US)

---

## Protests & Demonstrations

### Reality

Protests are **very common** in Buenos Aires, especially near:
- Plaza de Mayo
- Congreso
- Obelisco

### What to Know

- Usually peaceful
- Can disrupt traffic
- Avoid getting caught in crowd
- Don't photograph aggressive confrontations
- Check news for major demonstrations

### If Caught Near One

- Stay calm
- Move perpendicular to crowd flow
- Enter a cafe or business
- Don't run (may escalate)
