# Moving to Buenos Aires: Resident Guide

## First Steps After Arrival

### Week 1 Checklist

| Task | Priority | Notes |
|------|----------|-------|
| Get pesos (blue rate) | Immediate | Western Union or cueva |
| Buy SUBE card | Day 1 | For all public transport |
| Get SIM card | Day 1-2 | For local communication |
| Temporary accommodation | Pre-arranged | Hotel/Airbnb while apartment hunting |
| Learn neighborhood | Week 1 | Walk around, find essentials |

### Week 2-4 Checklist

| Task | Priority | Notes |
|------|----------|-------|
| Find apartment | High | See housing section |
| Set up internet | High | Can take 1-2 weeks |
| Open bank account (if eligible) | Medium | Difficult without DNI |
| Find gym | Medium | Try before committing |
| Establish routines | Medium | Grocery stores, laundry, etc. |

---

## Finding an Apartment

### Where to Search

| Platform | Type | Notes |
|----------|------|-------|
| ZonaProp | Local listings | Long-term, Spanish |
| Argenprop | Local listings | Long-term |
| Properati | Local listings | Good interface |
| Airbnb | Short-term | Test areas first |
| Facebook groups | Both | BA Expats, Palermo Rentals |
| Craigslist BA | Expat listings | English-friendly |

### Rental Types

| Type | Duration | Payment | Best For |
|------|----------|---------|----------|
| Temporary | 1-12 months | USD common | New arrivals, flexibility |
| Traditional | 2-3 years | Pesos (inflation-adjusted) | Long-term, lower cost |
| Airbnb | Days-months | USD | Testing areas |

### What to Expect

| Factor | Reality |
|--------|---------|
| Furnished | Most temporary rentals include |
| Utilities | Often separate from rent |
| Expensas | Building fees, always extra |
| Deposit | 1-2 months typical |
| Contract | Get everything in writing |

### Red Flags

| Warning Sign | Why |
|--------------|-----|
| Payment before viewing | Scam |
| Price far below market | Scam |
| Won't video call | Suspicious |
| Pressure to decide fast | Suspicious |
| No contract offered | Risky |

### Viewing Tips

1. **Visit at different times** - Day, night, weekend
2. **Check water pressure** - Common issue
3. **Test heating/AC** - Essential
4. **Meet the portero** - Building manager
5. **Ask about expensas** - Can be significant
6. **Verify internet options** - Check coverage

---

## Setting Up Your Home

### Utilities

| Service | How to Set Up |
|---------|---------------|
| Electricity | Usually transfer from landlord |
| Gas | Same, Metrogas |
| Water | Usually included in expensas |
| Internet | Call provider, 1-2 week wait |

### Internet Providers

| Provider | Coverage | Process |
|----------|----------|---------|
| Fibertel | Good | Call, schedule install |
| Telecentro | Good | Call, schedule |
| Movistar | Growing | Call, schedule |

**Tip:** Ask current tenant/landlord which provider works best in building.

### Essential Purchases

| Item | Where | Notes |
|------|-------|-------|
| Bedding | Carrefour, Falabella | If not furnished |
| Kitchen basics | Carrefour, Coto | Pots, utensils |
| Cleaning supplies | Supermarket, Dia | Stock up |
| Adapter plugs | Ferreterias | Argentina uses Type I |

### Plug Adapters

Argentina uses Type I (like Australia) and sometimes Type C:
- Bring universal adapter
- Buy local adapters at ferreteria (hardware store)
- New buildings often have modern outlets

---

## Getting Connected

### Phone Number

| Option | For |
|--------|-----|
| Prepaid SIM | Flexibility, tourists |
| Contract | Better rates, residents |
| eSIM | Digital convenience |

**Process:**
1. Buy SIM at carrier store
2. Show passport
3. Activate with charge

### Banking

| Status | Options |
|--------|---------|
| Tourist | None traditional |
| Digital nomad visa | Some banks possible |
| Resident (DNI) | Full banking |

**Alternatives:**
- Wise account
- Crypto (very common)
- Cash
- PayPal (limited)

### Mail

| Need | Solution |
|------|----------|
| Receiving packages | Use apartment address |
| International packages | Consider courier, customs issues |
| Important documents | Courier (DHL, FedEx) |

---

## Building Life

### The Portero

Every building has a portero (doorman/manager):
- Receives packages
- Handles building issues
- Valuable information source
- **Tip at Christmas** (aguinaldo)

### Expensas

Monthly building fees covering:
- Portero salary
- Common area cleaning
- Building maintenance
- Sometimes water
- Building insurance

**Range:** $50-200+ USD/month depending on building

### Building Rules

| Common Rules | Notes |
|--------------|-------|
| Quiet hours | Usually 10pm-8am |
| Laundry hours | Limited in some buildings |
| Pets | Ask before signing |
| Guests | Usually no restrictions |
| Renovations | Require permission |

---

## Daily Life Setup

### Groceries

| Store | Type | For |
|-------|------|-----|
| Carrefour | Large supermarket | Weekly stock-up |
| Coto | Large supermarket | Weekly stock-up |
| Disco | Medium supermarket | Convenient |
| Dia | Small budget chain | Basics, everywhere |
| Verduleria | Fruit/vegetable shop | Fresh produce, cheaper |
| Carniceria | Butcher | Quality meat |
| Panaderia | Bakery | Fresh bread daily |

### Delivery Apps

| App | Use |
|-----|-----|
| Rappi | Everything delivery |
| PedidosYa | Food delivery |
| Mercado Libre | Argentine Amazon |
| Fazil | Supermarket delivery |

### Laundry

| Option | Cost (USD) |
|--------|------------|
| In-building machines | Varies |
| Lavanderia (drop-off) | $2-4/kg |
| Laundry pickup service | $3-5/kg |

---

## Healthcare Setup

### Prepaid Plans (Recommended)

| Plan | Level | Monthly |
|------|-------|---------|
| OSDE 210 | Basic | $50-80 |
| OSDE 310 | Good | $80-120 |
| OSDE 510 | Premium | $120-200 |
| Swiss Medical | Good | $80-150 |
| Galeno | Various | $60-150 |

### What Plans Include

- Doctor visits
- Specialist referrals
- Hospital coverage
- Some medications
- Dental (basic)

### Without Insurance

| Service | Cost (USD) |
|---------|------------|
| GP visit | $30-50 |
| Specialist | $50-80 |
| Emergency room (private) | $100-300 |
| Public hospital | Free |

### Pharmacy

Most medications available without prescription:
- Antibiotics (some)
- Pain medications
- Most common drugs
- **Controlled substances** require prescription

---

## Social Integration

### Meeting People

| How | Where |
|-----|-------|
| Expat meetups | Facebook groups, Meetup.com |
| Language exchanges | Common in cafes |
| Sports | Running groups, gyms, football |
| Coworking | Natural networking |
| Classes | Spanish, tango, cooking |

### Spanish Learning

| Option | Notes |
|--------|-------|
| Private tutor | $10-20/hour |
| Group classes | Cheaper, social |
| Language exchange | Free, informal |
| Apps | Supplemental |

**Reality:** Spanish helpful, not mandatory in Palermo/tourist areas.

### Expat Communities

| Group | Platform |
|-------|----------|
| BA Expats | Facebook |
| Palermo Rentals | Facebook |
| Internations | Website |
| Gringos in BA | Various |

---

## Working Remotely

### Coworking Options

| Space | Location | Monthly |
|-------|----------|---------|
| WeWork | Multiple | $150-250 |
| Urban Station | Multiple | $100-150 |
| La Maquinita | Palermo | $80-120 |
| Area Tres | Multiple | $60-100 |

### Cafe Working

Palermo cafes are generally work-friendly:
- Good WiFi
- Power outlets
- No time pressure
- $5-10 for coffee + workspace

### Home Office

| Factor | Reality |
|--------|---------|
| Internet | Good fiber available |
| Power | Reliable in central areas |
| Noise | Depends on apartment |
| Time zones | Good for US (2-3 hours difference) |

---

## Safety & Security

### Home Safety

| Measure | Notes |
|---------|-------|
| Building security | Most have portero |
| Apartment locks | Check quality |
| Valuables | Don't keep all cash at home |
| Insurance | Consider renter's insurance |

### Street Safety

| Practice | Always |
|----------|--------|
| Phone in front pocket | Yes |
| Bag in front | In crowds |
| Vary routine | Somewhat |
| Know emergency numbers | 911 |

---

## Long-Term Considerations

### After 6 Months

| Task | Consider |
|------|----------|
| Residency | If staying long-term |
| Tax implications | 183 days = tax resident |
| Long-term lease | Better rates |
| Spanish fluency | Invest in learning |

### Building Credit/History

Without DNI, limited options. With DNI:
- Utility bills in your name
- Bank account history
- Rental history

### Community Involvement

| Option | Benefit |
|--------|---------|
| Volunteer | Meet locals |
| Classes | Build skills + network |
| Sports leagues | Social + health |
| Neighborhood events | Integration |
