# Buenos Aires North: Palermo, Belgrano, Nunez

> The city's most desirable residential areas. Tree-lined streets, excellent restaurants, and the safest neighborhoods.

---

## Palermo - The Expat & Digital Nomad Capital

Palermo is Buenos Aires' largest barrio, divided into distinct sub-neighborhoods, each with its own personality.

### Palermo Soho

**Character:** Trendy, boutique-filled, Instagram-worthy. The heart of BA's foodie scene.

| Factor | Rating | Notes |
|--------|--------|-------|
| Walkability | 5/5 | Everything within walking distance |
| Nightlife | 4/5 | Bars and restaurants, not clubs |
| Coffee Shops | 5/5 | Best in city for remote work |
| Safety | 4/5 | Good, watch phone on streets |
| Noise | Medium-High | Weekend nights can be loud |
| Expat Density | Very High | Spanish not required |

**Rent (monthly, blue rate):**
| Type | Range USD |
|------|-----------|
| Studio | $400-550 |
| 1BR | $500-750 |
| 2BR | $650-1,000 |

**Best streets:** Plaza Armenia area, Honduras, El Salvador, Thames, Gurruchaga

**Ideal for:** Digital nomads, foodies, creative professionals, short-term stays

**Cons:**
- Tourist prices (20-30% premium)
- Cobblestone streets (luggage nightmare)
- Noisy weekends
- Hardest to find long-term rentals

### Palermo Hollywood

**Character:** Media production, bars, restaurants, more local than Soho. Named for TV/film studios.

| Factor | Rating | Notes |
|--------|--------|-------|
| Walkability | 5/5 | Excellent |
| Nightlife | 5/5 | Best cocktail bars in BA |
| Coffee Shops | 4/5 | Good, less crowded than Soho |
| Safety | 4/5 | Good until 3am+ |
| Noise | High | Party area |
| Expat Density | High | Mix of expats and locals |

**Rent (monthly, blue rate):**
| Type | Range USD |
|------|-----------|
| Studio | $380-500 |
| 1BR | $450-700 |
| 2BR | $600-900 |

**Best streets:** Fitz Roy, Bonpland, Nicaragua, Costa Rica

**Ideal for:** Night owls, media/tech workers, social butterflies

**Cons:**
- Loud at night (seriously, earplugs needed)
- Can feel overwhelming
- Late-night safety concerns

### Palermo Viejo

**Character:** The original Palermo, quieter residential streets between Soho and Hollywood.

**Rent:** Between Soho and Hollywood prices
**Ideal for:** Those wanting Palermo location but quieter life

### Palermo Chico

**Character:** The embassy district. Mansions, old money, quiet tree-lined streets.

| Factor | Rating |
|--------|--------|
| Safety | 5/5 |
| Quiet | 5/5 |
| Walkability | 4/5 |
| Restaurants | 2/5 (need to walk to Soho) |
| Green Space | 5/5 (near Bosques) |

**Rent (monthly, blue rate):**
- 2BR apartment: $800-1,200
- House/mansion: $2,000-5,000+

**Ideal for:** Families, executives, diplomats, quiet-seekers with budget

### Bosques de Palermo

Not residential-the city's largest park system. Running, cycling, boating, weekend markets.

### Las Canitas

**Character:** Small pocket near Campo de Polo. After-work drinks, upscale casual.

| Factor | Rating |
|--------|--------|
| Restaurants | 4/5 |
| Bars | 4/5 |
| Safety | 4/5 |
| Quiet | 3/5 |
| Family-friendly | 4/5 |

**Rent:** Similar to Palermo Hollywood

**Ideal for:** Young professionals, couples, after-work crowd

---

## Belgrano - The Family Neighborhood

Buenos Aires' most prestigious residential neighborhood for families. Excellent schools, parks, and a distinct village feel.

### Overview

| Factor | Rating | Notes |
|--------|--------|-------|
| Family-friendly | 5/5 | Best schools, safest |
| Walkability | 4/5 | Good within area |
| Restaurants | 3/5 | Family-oriented, less trendy |
| Safety | 5/5 | One of safest areas |
| Transit | 4/5 | Linea D, trains |
| Green Space | 5/5 | Barrancas, parks |
| Expat Density | Medium-High | Especially families |

### Belgrano R (Residencial)

The quietest, most residential part. Large houses with gardens, tree-lined streets.

**Rent (monthly, blue rate):**
| Type | Range USD |
|------|-----------|
| 2BR apartment | $550-850 |
| 3BR apartment | $750-1,200 |
| House | $1,200-2,500 |

**Best for:** Families, long-term residents, those wanting quiet

### Belgrano C (Centro)

More commercial, around Cabildo avenue. Shopping, restaurants, services.

**Rent:** 10-15% cheaper than Belgrano R

**Best for:** Those wanting urban convenience with Belgrano safety

### Chinatown (Barrio Chino)

Small area around Arribenos street. Asian restaurants, supermarkets, cultural events.

**Worth visiting:** Yes, especially for food
**Worth living:** Not particularly-tiny area with tourist crowds

### Barrancas de Belgrano

Beautiful park with weekend craft fair. Apartments overlooking the park are premium.

### Schools

| School | Type | Language | Fees (USD/year) |
|--------|------|----------|-----------------|
| St. Andrew's Scots School | Private | English/Spanish | $8,000-12,000 |
| Belgrano Day School | Private | English/Spanish | $7,000-10,000 |
| Lincoln International | American | English | $15,000-25,000 |
| Northlands | Private | English/Spanish | $10,000-15,000 |
| Escuela Argentina Modelo | Private | Spanish | $3,000-5,000 |

### Transit
- **Subte Linea D:** Stations at Juramento, Jose Hernandez, Olleros
- **Trains:** Belgrano C and Belgrano Norte lines
- **Buses:** Many lines along Cabildo and main avenues

---

## Nunez - River Plate & Quiet Living

Home to River Plate's Monumental stadium and some of BA's quietest residential streets.

### Overview

| Factor | Rating | Notes |
|--------|--------|-------|
| Family-friendly | 5/5 | Very quiet, safe |
| Walkability | 3/5 | Spread out, car helpful |
| Restaurants | 3/5 | Limited, mostly casual |
| Safety | 5/5 | Excellent |
| Transit | 3/5 | Train + buses |
| Green Space | 5/5 | Costanera, parks |
| Expat Density | Medium | Mostly families |

**Rent (monthly, blue rate):**
| Type | Range USD |
|------|-----------|
| 1BR | $350-550 |
| 2BR | $500-800 |
| 3BR | $700-1,100 |
| House | $1,000-2,000 |

### Highlights

1. **Estadio Monumental** - River Plate's stadium. Game days are LOUD.
2. **Parque de la Memoria** - Memorial park along the river, beautiful for running
3. **Costanera Norte** - River path, restaurants, weekend markets
4. **Ciudad Universitaria** - UBA campus, young crowd

### Living Near the Stadium

- Match days (mostly Sundays): Traffic chaos, crowds, noise
- Other days: Completely quiet
- Street parking difficult on match days
- Apartments with stadium view: Premium pricing

### Best For
- Families wanting space and quiet
- Runners (great river paths)
- River Plate fans
- Those with cars (less transit-dependent)

### Cons
- Limited nightlife/dining
- Need car or long walks to subte
- Far from Palermo/center action
- Match day disruption

---

## Norte Zone: Practical Info

### Getting Around

| From | To Center | Method | Time |
|------|-----------|--------|------|
| Palermo Soho | Microcentro | Subte D | 20 min |
| Belgrano | Microcentro | Subte D | 25-30 min |
| Nunez | Microcentro | Train + Subte | 35-40 min |

### Supermarkets

| Store | Type | Locations |
|-------|------|-----------|
| Carrefour | Large | Multiple |
| Jumbo | Large | Palermo, Belgrano |
| Disco | Medium | Many |
| Dia | Budget | Everywhere |
| Barrio Chino markets | Asian | Belgrano |

### Coworking Spaces (Palermo)

| Space | Day Pass USD | Monthly USD | Notes |
|-------|--------------|-------------|-------|
| WeWork Palermo | $25 | $200+ | International chain |
| Urban Station | $15 | $150 | Local favorite |
| La Maquinita | $12 | $100 | Creative vibe |
| Selina | $20 | $180 | Hostel/cowork combo |
| Area Tres | $10 | $80 | Budget option |

### Gyms

| Gym | Monthly USD | Notes |
|-----|-------------|-------|
| Megatlon | $40-60 | Premium chain |
| SportClub | $30-50 | Multiple locations |
| Smart Fit | $20-30 | Budget, basic |
| CrossFit boxes | $60-100 | Various |
| Outdoor gyms | Free | Bosques de Palermo |

---

## Choosing Within Norte

### Quick Decision Matrix

| If you want... | Choose... |
|----------------|-----------|
| Best restaurants + nightlife | Palermo Soho/Hollywood |
| Quiet + family | Belgrano R |
| Budget + still nice | Villa Crespo (next door) |
| Waterfront + space | Nunez |
| Central + upscale | Palermo Chico |
| After-work scene | Las Canitas |
| Asian food access | Near Chinatown, Belgrano |
