# Buenos Aires Neighborhoods - Quick Comparison Index

> **Data Sources:** ZonaProp, Argenprop, Properati (Feb 2026), local real estate agents  
> **Currency:** ARS (Argentine Peso) | Blue dollar rate: ~$1 USD = 1,200 ARS (fluctuates)  
> **All USD prices calculated at blue dollar rate**

---

## [Stats] Rental Price Comparison (Monthly USD at Blue Rate)

| Neighborhood | Studio | 1-Bedroom | 2-Bedroom | 3-Bedroom | Notes |
|-------------|--------|-----------|-----------|-----------|-------|
| **Puerto Madero** | $600-800 | $800-1,200 | $1,200-1,800 | $1,800-3,000 | Most expensive, waterfront |
| **Recoleta** | $400-550 | $500-800 | $700-1,100 | $1,000-1,600 | Classic elegance |
| **Palermo Soho** | $400-550 | $500-750 | $650-1,000 | $900-1,400 | Trendy, expat favorite |
| **Palermo Hollywood** | $380-500 | $450-700 | $600-900 | $850-1,300 | Nightlife, studios |
| **Belgrano** | $350-450 | $400-600 | $550-850 | $750-1,200 | Family-friendly |
| **Nunez** | $300-400 | $350-550 | $500-800 | $700-1,100 | Near River stadium |
| **Villa Crespo** | $300-400 | $350-500 | $500-750 | $650-1,000 | Up-and-coming |
| **San Telmo** | $280-380 | $350-500 | $450-700 | $600-900 | Historic, bohemian |
| **Caballito** | $250-350 | $300-450 | $400-650 | $550-850 | Local, residential |
| **Almagro** | $220-320 | $280-420 | $380-600 | $500-800 | Budget-friendly |
| **Boedo** | $200-300 | $250-400 | $350-550 | $450-700 | Authentic, tango |
| **Flores** | $180-280 | $220-350 | $300-500 | $400-650 | Very local |

---

## [Target] Quick Profile Matching

### [Laptop] Digital Nomads / Remote Workers (Budget: $400-700/month)
| Priority | Best Choice | Why |
|----------|-------------|-----|
| Scene + Coffee | **Palermo Soho** | Best cafes, coworking, expat network |
| Budget + Vibe | **Villa Crespo** | Cheaper than Palermo, still walkable |
| Historic + Cheap | **San Telmo** | Character, antique markets, local feel |

### [Business] Tech Workers (Budget: $500-1,000/month)
| Priority | Best Choice | Why |
|----------|-------------|-----|
| Modern + Secure | **Puerto Madero** | Newest area, 24/7 security, corporate |
| Work-Life Balance | **Belgrano** | Quiet, green, good transit |
| Social + Networking | **Palermo Hollywood** | Tech scene, bars, events |

### [Couple] Couples / DINKs (Budget: $500-900/month)
| Priority | Best Choice | Why |
|----------|-------------|-----|
| Foodie Paradise | **Palermo Soho** | Best restaurants, bars, markets |
| Culture + Elegance | **Recoleta** | Museums, parks, sophisticated |
| Emerging + Value | **Villa Crespo** | Trendy, cheaper, great restaurants |

### [Family] Families (Budget: $700-1,400/month)
| Priority | Best Choice | Why |
|----------|-------------|-----|
| Best Schools | **Belgrano** | Top bilingual schools, parks |
| Green Space | **Nunez** | Near Parque de la Memoria, safe |
| Traditional | **Caballito** | Large apartments, Parque Centenario |
| Luxury Family | **Recoleta** | Parks, museums, private schools |

### [Diamond] Luxury / Expat Executives
| Priority | Best Choice | Why |
|----------|-------------|-----|
| Waterfront Living | **Puerto Madero** | Only waterfront, modern towers |
| Classic Elegance | **Recoleta** | Parisian architecture, embassies |
| Best of Both | **Palermo Chico** | Quiet, green, near everything |

---

## [Metro] Subte (Metro) Access Score

| Neighborhood | Subte Lines | Stations | Walkability | Car Needed? |
|--------------|-------------|----------|-------------|-------------|
| Microcentro | A, B, C, D, E | 15+ | 5/5 | No |
| San Telmo | C, E | 3 | 4/5 | No |
| Recoleta | D, H | 3 | 5/5 | No |
| Palermo | D | 4 | 5/5 | No |
| Belgrano | D | 3 | 4/5 | Optional |
| Caballito | A, E | 4 | 4/5 | No |
| Villa Crespo | B | 2 | 4/5 | No |
| Almagro | A, B | 3 | 4/5 | No |
| Puerto Madero | None (Tram) | 1 | 3/5 | Recommended |
| Nunez | None (Train) | 1 | 3/5 | Recommended |

---

## [Tree] Green Space & Quality of Life

| Neighborhood | Parks | Trees | Noise Level | Air Quality |
|--------------|-------|-------|-------------|-------------|
| Palermo (Bosques) | 5/5 | 5/5 | Medium | Good |
| Belgrano | 4/5 | 5/5 | Low | Good |
| Recoleta | 4/5 | 4/5 | Medium | Good |
| Nunez | 4/5 | 4/5 | Low | Good |
| Puerto Madero | 4/5 | 4/5 | Low | Good |
| Caballito | 4/5 | 3/5 | Medium | Medium |
| Villa Crespo | 2/5 | 3/5 | Medium-High | Medium |
| San Telmo | 2/5 | 2/5 | Medium | Medium |
| Microcentro | 1/5 | 1/5 | Very High | Poor |
| La Boca | 2/5 | 1/5 | Medium | Poor |

---

## [Lock] Safety Ratings

| Neighborhood | Day Safety | Night Safety | Tourist Safe? | Notes |
|--------------|------------|--------------|---------------|-------|
| Puerto Madero | 5/5 | 5/5 | [OK] | Security everywhere |
| Recoleta | 5/5 | 4/5 | [OK] | Well-patrolled |
| Belgrano | 4/5 | 4/5 | [OK] | Residential, quiet |
| Palermo Soho | 4/5 | 4/5 | [OK] | Busy, generally safe |
| Palermo Hollywood | 4/5 | 3/5 | [OK] | Watch late night |
| Nunez | 4/5 | 4/5 | [OK] | Quiet residential |
| Villa Crespo | 4/5 | 3/5 | [OK] | Improving |
| San Telmo | 3/5 | 3/5 | [!] | Tourist target |
| Caballito | 4/5 | 3/5 | [OK] | Local, quiet |
| Almagro | 3/5 | 3/5 | [!] | Varies by block |
| Microcentro | 3/5 | 2/5 | [!] | Deserted at night |
| La Boca | 2/5 | 1/5 | [X] | Only Caminito |
| Constitucion | 2/5 | 1/5 | [X] | Avoid |

---

## [Food] Food & Nightlife

| Neighborhood | Restaurants | Bars/Clubs | Cafes | Best For |
|--------------|-------------|------------|-------|----------|
| Palermo Soho | 5/5 | 4/5 | 5/5 | Trendy dining, brunch |
| Palermo Hollywood | 4/5 | 5/5 | 4/5 | Nightlife, cocktails |
| Recoleta | 4/5 | 3/5 | 5/5 | Classic, upscale |
| San Telmo | 4/5 | 4/5 | 4/5 | Tango, bohemian |
| Puerto Madero | 4/5 | 2/5 | 3/5 | Upscale, waterfront |
| Villa Crespo | 4/5 | 3/5 | 4/5 | Emerging scene |
| Belgrano | 3/5 | 2/5 | 3/5 | Family restaurants |
| Las Canitas | 4/5 | 4/5 | 3/5 | After-work drinks |

---

## [!] Key Warnings by Area

1. **Puerto Madero** - Isolated, everything closes early, need car/taxi
2. **Palermo Soho** - Tourist prices, weekend crowds, noise at night
3. **San Telmo** - Pickpockets around market, uneven streets
4. **La Boca** - ONLY visit Caminito during day, dangerous otherwise
5. **Microcentro** - Dead after 8pm weekdays, avoid walking alone
6. **Constitucion** - Avoid entirely, high crime around train station
7. **Once** - Safe during day (shopping), avoid at night
8. **Retiro** - Bus station area sketchy, rest is fine

---

## [Link] Detailed Guides

- [Palermo, Belgrano, Nunez ->](neighborhoods-norte.md)
- [Microcentro, San Nicolas, Retiro ->](neighborhoods-centro.md)
- [San Telmo, La Boca, Barracas ->](neighborhoods-sur.md)
- [Caballito, Almagro, Villa Crespo ->](neighborhoods-oeste.md)
- [Puerto Madero, Recoleta ->](neighborhoods-premium.md)
- [How to Choose Your Neighborhood ->](neighborhoods-choosing.md)
