# Buenos Aires Centro: Microcentro, San Nicolas, Retiro

> The historical and commercial heart. Work here, but think twice about living here.

---

## Microcentro - The Financial District

Buenos Aires' Wall Street. Banks, offices, and the famous pedestrian street Florida.

### Overview

| Factor | Rating | Notes |
|--------|--------|-------|
| Daytime Activity | 5/5 | Bustling 9am-7pm |
| Nighttime | 1/5 | Dead after 8pm |
| Walkability | 5/5 | All pedestrian streets |
| Safety Day | 4/5 | Police presence |
| Safety Night | 2/5 | Avoid walking alone |
| Restaurants | 3/5 | Business lunch spots |
| Housing | 2/5 | Offices converted to lofts |
| Transit | 5/5 | All subte lines |

### Key Areas

**Calle Florida** - Pedestrian shopping street. Tourist shops, leather stores, street performers. Crowded but safe during day.

**Lavalle** - Pedestrian street parallel to Florida. Theaters, cinemas, fast food.

**Avenida Corrientes** - Broadway of Buenos Aires. Theaters, bookstores, pizzerias open late.

### Living Here?

Mostly NOT recommended for residential, but:

**Pros:**
- Very cheap rent ($200-400/month for 1BR)
- All transit accessible
- Near everything during work hours
- Loft-style converted offices

**Cons:**
- Deserted and unsafe after 8pm
- No supermarkets, gyms, or services
- Zero green space
- Loud during day, eerie at night
- Homeless population increases at night

**Who it works for:**
- Short-term stays (Airbnb travelers)
- Night owls who leave at night anyway
- Budget-conscious who stay in Palermo for fun
- People who work until midnight anyway

### Rent (monthly, blue rate)
| Type | Range USD |
|------|-----------|
| Studio | $180-280 |
| 1BR | $250-400 |
| 2BR | $350-550 |

---

## San Nicolas - Theater District & Obelisco

Home to the Obelisco landmark and the Teatro Colon. More residential than Microcentro.

### Overview

| Factor | Rating | Notes |
|--------|--------|-------|
| Culture | 5/5 | Teatro Colon, theaters |
| Walkability | 5/5 | Excellent |
| Safety Day | 4/5 | Good |
| Safety Night | 3/5 | Better than Microcentro |
| Restaurants | 4/5 | Classic porteno spots |
| Nightlife | 3/5 | Avenida Corrientes |
| Transit | 5/5 | Multiple lines |

### Landmarks

- **Obelisco** - The iconic monument, center of everything
- **Teatro Colon** - World-class opera house
- **Plaza de la Republica** - Where protests and celebrations happen
- **Avenida 9 de Julio** - World's widest avenue

### Avenida Corrientes

The street that never sleeps. Open 24/7:
- Pizzerias (Guerrin, Banchero, Las Cuartetas)
- Bookstores (many open until midnight)
- Theaters and cinemas
- After-theater dining

### Living Here

Better than Microcentro, but still urban grit.

**Rent (monthly, blue rate):**
| Type | Range USD |
|------|-----------|
| Studio | $220-350 |
| 1BR | $300-450 |
| 2BR | $400-600 |

**Best for:**
- Theater lovers
- Night owls who love Corrientes culture
- Those who want true urban living
- Budget-conscious wanting central location

---

## Retiro - Transport Hub & Contrasts

The most contrasting neighborhood in Buenos Aires. Luxury apartments next to one of the largest villas (slums).

### Overview

| Factor | Rating | Notes |
|--------|--------|-------|
| Transit | 5/5 | Main hub of city |
| Safety | Varies wildly | Block by block |
| Architecture | 4/5 | Beautiful old buildings |
| Green Space | 4/5 | Plaza San Martin |
| Business | 4/5 | Corporate offices |

### The Two Retiros

**Retiro "Bueno" (Good):**
- Plaza San Martin area
- Torre de los Ingleses (clock tower)
- Historic hotels (Marriott, Sheraton)
- Corporate towers
- Beautiful French architecture
- Safe, well-maintained

**Retiro "Malo" (Bad):**
- Behind the bus terminal
- Villa 31 (large informal settlement)
- NOT dangerous to transit through, but not residential for expats

### Transport Hub

**Estacion Retiro** includes:
- Retiro train station (multiple lines)
- Long-distance bus terminal (to all of Argentina)
- Subte Linea C terminus

**Warning:** The area immediately around the bus terminal can be sketchy. Keep belongings close, don't flash phones.

### Living Here

Only in specific areas:

**Good blocks:**
- Facing Plaza San Martin
- Along Avenida del Libertador toward Recoleta
- Near embassies

**Avoid:**
- Anything behind/near bus terminal
- Near Villa 31

**Rent (good areas, monthly, blue rate):**
| Type | Range USD |
|------|-----------|
| 1BR | $400-600 |
| 2BR | $550-850 |

### Plaza San Martin

Beautiful green space with:
- Monumento a los Caidos en Malvinas
- Views of Torre de los Ingleses
- Jacaranda trees (purple in spring)
- Good for lunch breaks

---

## Centro Zone: Practical Info

### Why Live Here?

**Valid reasons:**
1. Work in the area and hate commuting
2. Temporary stay (1-3 months)
3. Tight budget, willing to trade comfort
4. Night owl who's never home anyway
5. Theater/culture obsessed

**Invalid reasons:**
1. "It's central" - Palermo is central AND livable
2. "It's cheap" - The quality difference isn't worth savings
3. "I'll explore other areas" - You'll tire of the commute

### Best of Centro

| For... | Go to... |
|--------|----------|
| Pizza (classic) | Guerrin, Avenida Corrientes |
| Pizza (upscale) | La Mezzetta |
| Bookstores | Avenida Corrientes (walk the whole strip) |
| Theater | Teatro Colon (take a tour) |
| Empanadas | El Sanjuanino |
| Historic cafe | Cafe Tortoni (touristy but beautiful) |
| Steak | La Brigada (San Telmo, nearby) |

### Getting Out

| To... | Best Route | Time |
|-------|------------|------|
| Palermo | Subte D from Diagonal Norte | 15 min |
| San Telmo | Subte C from Lavalle | 10 min |
| Recoleta | Walk or Subte D | 10-15 min |
| Puerto Madero | Walk east | 10 min |
| Belgrano | Subte D | 25 min |

### Services

**Supermarkets:** Carrefour Express (multiple), Dia (many)
**Gyms:** Few options, most people go to other barrios
**Coworking:** WeWork (multiple), but most prefer Palermo
**Laundry:** Many lavanderias, cheap

### Day vs Night Reality

**9am-7pm:**
- Streets packed
- Restaurants full
- Safe with crowds
- Everything open

**7pm-9am:**
- Streets empty quickly
- Most restaurants closed
- Police presence drops
- Homeless population visible
- Walking alone NOT recommended

---

## Centro Zone: Decision Guide

### Should You Live in Centro?

**Yes if:**
- [ ] You work here and value 5-min commute
- [ ] You're staying <3 months
- [ ] You're very budget conscious
- [ ] You're a night owl who's always out elsewhere
- [ ] You specifically want Corrientes theater culture

**No if:**
- [ ] You want greenery or quiet
- [ ] You plan to work remotely (cafes limited)
- [ ] You value night walks
- [ ] You're moving with family
- [ ] You want to integrate with expat community

### Alternatives to Consider

| Instead of... | Consider... | Why |
|---------------|-------------|-----|
| Microcentro | San Telmo | Same price, more character, safer |
| San Nicolas | Villa Crespo | Similar transit, way more livable |
| Retiro | Recoleta | 10 min walk, completely different |
