# Buenos Aires: Local Services Guide

## Banking & Money

### Opening a Bank Account

**As a foreigner:** Difficult without residency (DNI).

**Options:**
| Status | Bank Account? |
|--------|---------------|
| Tourist | No |
| Digital nomad visa | Possible with some banks |
| Resident (DNI) | Yes, full access |

### Alternatives

| Service | Use Case |
|---------|----------|
| Wise (TransferWise) | Hold USD, convert to ARS |
| PayPal | Limited, not great rates |
| Western Union | Get pesos at blue rate |
| Crypto (USDT, etc.) | Very common in Argentina |
| Cash USD | Widely accepted |

### ATMs

| Network | Notes |
|---------|-------|
| Banelco | Most common |
| Link | Second network |
| Limits | Low (~$100-200 USD/day) |
| Fees | High for foreign cards |
| Rate | Official (bad) |

**Recommendation:** Avoid ATMs. Use Western Union or cuevas.

### Crypto Adoption

Argentina has **one of the highest crypto adoption rates** globally:
- USDT widely accepted
- P2P exchanges (Binance P2P)
- Some stores accept crypto
- Crypto meetups common

---

## Mobile & Internet

### SIM Cards

| Carrier | Coverage | Notes |
|---------|----------|-------|
| Claro | Good | Easy tourist plans |
| Movistar | Good | Largest network |
| Personal | Good | Third major carrier |

**Where to buy:**
- Carrier stores (best)
- Kioscos (sometimes)
- Shopping centers

**Cost:** ~$10-20 for SIM + data

**Documents needed:** Passport

### eSIM

| Provider | Notes |
|----------|-------|
| Airalo | Easy setup before arrival |
| Holafly | Unlimited data options |
| Local carriers | Some support eSIM |

### Home Internet

| Provider | Type | Speed | Monthly |
|----------|------|-------|---------|
| Fibertel | Fiber/Cable | 100-500 Mbps | $25-50 |
| Telecentro | Fiber/Cable | 100-300 Mbps | $20-40 |
| Movistar | Fiber | 100-300 Mbps | $25-45 |
| Personal | Fiber | Varies | $20-40 |

**Reality:** Fiber available in most central areas, good speeds.

**Installation:** Often takes 1-2 weeks, plan ahead.

---

## Postal & Shipping

### Correo Argentino (National Post)

| Service | Reality |
|---------|---------|
| Reliability | Variable |
| Speed | Slow (domestic), very slow (international) |
| Tracking | Basic |
| Use for | Non-urgent, cheap domestic |

### Private Couriers

| Service | Notes |
|---------|-------|
| OCA | Domestic, more reliable |
| Andreani | Domestic, common |
| DHL | International, expensive but reliable |
| FedEx | International, expensive |
| UPS | International |

### Receiving International Packages

**Warning:** Argentina has strict import controls.

| Issue | Reality |
|-------|---------|
| Customs | Packages often held |
| Taxes | Import duties apply |
| Process | May need to pick up in person |
| Delays | Common |

**Recommendation:** Avoid shipping valuable items to Argentina if possible.

---

## Healthcare Services

### Public System

| Aspect | Reality |
|--------|---------|
| Cost | Free for everyone |
| Quality | Good doctors, crowded facilities |
| Wait times | Can be long |
| Best for | Emergency, specialists |

### Private System

| Aspect | Reality |
|--------|---------|
| Cost | Affordable vs US/Europe |
| Quality | Excellent |
| Access | Quick appointments |
| Options | Prepaid plans or pay-per-visit |

### Finding Doctors

| Need | Where |
|------|-------|
| General | Prepaid plan, or walk-in clinic |
| English-speaking | Hospital Aleman, Hospital Britanico |
| Specialist | Ask at clinic, referral |
| Dentist | Many excellent, affordable |

### Pharmacies

| Name | Type |
|------|------|
| Farmacity | Large chain |
| Farmacias Lider | Chain |
| Neighborhood pharmacies | Often cheaper |

**Reality:** Many medications available without prescription.

### Hospital Recommendations

| Hospital | Type | Notes |
|----------|------|-------|
| Hospital Aleman | Private | Excellent, English common |
| Hospital Britanico | Private | Very good |
| Sanatorio Guemes | Private | Well-regarded |
| Hospital Italiano | Private | Large, comprehensive |
| Hospital Fernandez | Public | Good public option |

---

## Laundry Services

### Lavanderia (Laundromat)

| Service | Cost (USD) | Notes |
|---------|------------|-------|
| Wash + dry + fold | $2-4/kg | Most common |
| Same day | $3-5/kg | Available |
| Dry cleaning | $5-10/item | For delicates |

**How it works:**
1. Drop off clothes
2. Pay by weight
3. Pick up next day (or same day)
4. They wash, dry, fold

**Tip:** Use neighborhood lavanderia, cheaper than hotel.

### In-Building Laundry

Many apartments have shared laundry or machines in unit.

---

## Household Services

### Cleaning Services

| Type | Cost (USD) |
|------|------------|
| 3-hour session | $15-25 |
| Full day | $30-50 |
| Weekly arrangement | $60-100/month |

**Finding cleaners:**
- Building portero recommendations
- Facebook groups
- Apps (Zolvers)
- Word of mouth

### Plumber/Electrician

| Service | Cost |
|---------|------|
| House call | $15-30 |
| Simple repair | $20-50 |
| Major work | Quote needed |

**Finding:** Ask portero, neighbors, or online.

### Pet Services

| Service | Cost (USD) |
|---------|------------|
| Dog walker (monthly) | $50-100 |
| Vet visit | $20-40 |
| Grooming | $20-40 |
| Pet sitting (daily) | $15-25 |

---

## Shopping

### Supermarkets

| Chain | Type | Notes |
|-------|------|-------|
| Carrefour | Large | Best prices, variety |
| Coto | Large | Good value |
| Disco | Medium | Decent, convenient |
| Jumbo | Large | Premium options |
| Dia | Small | Budget, many locations |

### Specialty Food

| Type | Where |
|------|-------|
| Organic | Almacen Organico, Tierra Viva |
| Asian | Barrio Chino (Belgrano) |
| European imports | Selected supermarkets, high markup |
| Wine shops | Everywhere, excellent |

### Clothing

| Type | Where |
|------|-------|
| Fast fashion | Florida Street, shopping malls |
| Local designers | Palermo Soho |
| Vintage | San Telmo |
| Leather | Various (research quality) |
| Outlets | Caminito outlets (outside city) |

### Electronics

| Reality | Impact |
|---------|--------|
| Import taxes | 2-3x US prices |
| Selection | Limited vs US |
| Apple | Expensive, limited warranty |
| Local purchase | Not recommended unless urgent |

**Recommendation:** Buy electronics before arrival.

---

## Gyms & Fitness

### Gym Chains

| Chain | Type | Monthly (USD) |
|-------|------|---------------|
| Megatlon | Premium | $40-60 |
| SportClub | Mid-range | $30-50 |
| Smart Fit | Budget | $20-30 |
| CrossFit boxes | Specialty | $60-100 |

### Pay-per-class

| Type | Cost (USD) |
|------|------------|
| Yoga drop-in | $8-15 |
| Pilates | $10-20 |
| Spinning | $8-12 |
| Dance class | $10-15 |

### Free Options

- Outdoor gyms (Palermo parks)
- Running groups
- Public park activities
- Costanera running paths

---

## Coworking Spaces

### Major Options

| Space | Location | Monthly (USD) |
|-------|----------|---------------|
| WeWork | Multiple | $150-250 |
| Urban Station | Multiple | $100-150 |
| La Maquinita | Palermo | $80-120 |
| Selina | Palermo | $150-200 |
| Area Tres | Multiple | $60-100 |

### Cafe Working

Many cafes are work-friendly:
- Good WiFi
- Power outlets
- No time pressure
- Coffee culture

**Best areas:** Palermo Soho, Belgrano, Recoleta

---

## Utilities Setup

### Electricity & Gas

| Provider | Coverage |
|----------|----------|
| Edenor/Edesur | Electricity (divided by area) |
| Metrogas | Natural gas |

**For renters:** Usually set up by landlord, transferred to your name or paid through landlord.

### Water

| Provider | Notes |
|----------|-------|
| AySA | Water utility |
| Very cheap | Often included in expensas |

### Typical Monthly Costs (USD)

| Utility | Studio/1BR | 2-3BR |
|---------|------------|-------|
| Electricity | $15-30 | $25-50 |
| Gas | $10-20 | $15-30 |
| Water | $5-10 | $5-15 |
| Internet | $20-40 | $25-45 |
| Phone | $10-20 | $10-20 |

---

## Government Services

### DNI (National ID)

Needed for:
- Bank accounts
- Employment
- Many services

**Getting it:** Through residency process

### CUIT/CUIL

Tax identification number:
- CUIL: For employees
- CUIT: For self-employed/business

### Driver's License

Foreign license valid for tourists. Residents need local license:
- Written test
- Practical test
- Document requirements
