# Buenos Aires Healthcare Guide

## System Overview

Argentina has a **three-tiered healthcare system**, all of which are accessible to foreigners.

| Tier | Coverage | Quality | Cost |
|------|----------|---------|------|
| Public (Hospital Publico) | Everyone, free | Good, crowded | Free |
| Union-based (Obra Social) | Employees | Variable | Payroll deduction |
| Private (Prepaga) | Anyone who pays | Excellent | $50-200+/month |

---

## Public Healthcare

### Overview

| Aspect | Reality |
|--------|---------|
| Cost | Completely free |
| Access | Everyone, including foreigners |
| Quality | Good doctors, crowded facilities |
| Wait times | Can be long |
| Facilities | Variable, some excellent |

### Best Public Hospitals

| Hospital | Specialty | Location |
|----------|-----------|----------|
| Hospital Fernandez | General | Palermo |
| Hospital Italiano | Comprehensive | Almagro |
| Hospital de Clinicas | Academic | Recoleta |
| Hospital Garrahan | Pediatric | Parque Patricios |
| Hospital de Ninos | Pediatric | Recoleta |

### When to Use Public

- Emergency care (always treated)
- Specialist consultations (referral)
- Chronic conditions
- Budget constraints
- When private not available

---

## Private Healthcare (Prepaga)

### What Is Prepaga?

Monthly subscription healthcare-like US health insurance but usually with direct access to services.

### Major Providers

| Provider | Level | Monthly (USD) |
|----------|-------|---------------|
| OSDE 210 | Basic | $50-80 |
| OSDE 310 | Good | $80-120 |
| OSDE 510 | Premium | $150-200+ |
| Swiss Medical | Good-Premium | $80-150 |
| Galeno | Various | $60-150 |
| Medicus | Various | $60-130 |
| Omint | Premium | $150-250 |

### What's Included

| Service | Typically Covered |
|---------|-------------------|
| Doctor visits | Yes (small copay) |
| Specialists | Yes (with referral or direct) |
| Hospital | Yes |
| Surgery | Yes |
| Maternity | Yes (waiting periods) |
| Mental health | Yes (limited sessions) |
| Dental | Basic (major extra) |
| Vision | Limited |
| Medications | Discounts, some coverage |

### Choosing a Plan

| Factor | Consider |
|--------|----------|
| Coverage network | Which hospitals/doctors |
| Copays | Per-visit costs |
| Reintegros | Reimbursement policy |
| Waiting periods | For pre-existing |
| International coverage | If travel often |

### Signing Up

| Requirement | Notes |
|-------------|-------|
| ID | Passport or DNI |
| Declaration | Health questionnaire |
| Age factor | Older = more expensive |
| Pre-existing | May have waiting periods |
| Contract | Usually 1 year minimum |

---

## Finding Doctors

### With Prepaga

| Method | How |
|--------|-----|
| Provider app/website | Search by specialty |
| Call center | Request appointment |
| Direct contact | Many doctors' offices |

### Without Insurance

| Method | Where |
|--------|-------|
| Hospital publico | Walk-in or scheduled |
| Private consultation | Pay out of pocket |
| Referrals | Ask locals, expats |

### English-Speaking Doctors

| Hospital/Clinic | Notes |
|-----------------|-------|
| Hospital Aleman | German Hospital, multilingual |
| Hospital Britanico | British Hospital |
| Hospital Italiano | Good English |
| Swiss Medical Center | International |
| Various private clinics | In Palermo, Recoleta |

---

## Medical Costs (Without Insurance)

### Consultations

| Type | Cost (USD) |
|------|------------|
| General practitioner | $30-60 |
| Specialist | $50-100 |
| Emergency room (private) | $100-300 |
| House call | $80-150 |

### Procedures

| Procedure | Cost (USD) |
|-----------|------------|
| Blood work (basic panel) | $30-60 |
| X-ray | $40-80 |
| MRI | $200-400 |
| CT scan | $150-300 |
| Ultrasound | $50-100 |

### Dental

| Service | Cost (USD) |
|---------|------------|
| Cleaning | $30-60 |
| Filling | $40-80 |
| Root canal | $100-200 |
| Crown | $200-400 |
| Implant | $800-1,500 |

### Vision

| Service | Cost (USD) |
|---------|------------|
| Eye exam | $30-50 |
| Glasses | $50-200+ |
| Contacts (monthly supply) | $30-60 |
| LASIK | $1,500-3,000 |

---

## Pharmacies

### Overview

Argentina has **well-stocked pharmacies** with many medications available without prescription.

### Major Chains

| Chain | Notes |
|-------|-------|
| Farmacity | Largest, 24h locations |
| Farmacias del Dr. Ahorro | Budget option |
| Pharmacy neighborhood | Often cheaper |

### Prescription Rules

| Category | Requirement |
|----------|-------------|
| Most medications | Available OTC |
| Antibiotics | Some require prescription |
| Controlled substances | Strict prescription |
| Psychotropics | Prescription required |

### Costs

Medications are generally **much cheaper** than US:
- Generic options widely available
- Prepaga discounts (20-40%)
- Hospital pharmacies often cheapest

### 24-Hour Pharmacies

Available in most neighborhoods-Farmacity has many 24h locations.

---

## Emergency Care

### Emergency Numbers

| Service | Number |
|---------|--------|
| General emergency | 911 |
| Ambulance (SAME) | 107 |
| Police | 911 |
| Fire | 100 |

### Emergency Rooms

| Situation | Where to Go |
|-----------|-------------|
| Life-threatening | Nearest hospital (public or private) |
| With prepaga | Your network hospital |
| Without insurance | Public hospital |
| Uncertain | Call 107 for advice |

### What to Expect

| Factor | Reality |
|--------|---------|
| Triage | Yes, severity-based |
| Wait times | Variable |
| Cost | Free at public, varies at private |
| Quality | Generally good |
| Language | Spanish (bring translator if needed) |

---

## Mental Health

### Access

Buenos Aires has **excellent mental health services**-more therapists per capita than anywhere.

### Types of Services

| Service | Availability |
|---------|--------------|
| Psychotherapy | Abundant |
| Psychiatry | Good access |
| Group therapy | Available |
| Hospital mental health | Public and private |

### Costs

| Service | Cost (USD) |
|---------|------------|
| Therapy session | $30-80 |
| Psychiatrist | $50-100 |
| With prepaga | Often covered (limited sessions) |
| Public | Free |

### Finding a Therapist

| Method | Notes |
|--------|-------|
| Prepaga network | Easy access |
| Referrals | Ask around |
| English-speaking | Available, ask specifically |
| Online directories | Growing |

---

## Vaccinations

### Required

No vaccinations required for entry from most countries.

### Recommended

| Vaccine | Notes |
|---------|-------|
| Routine vaccines | Up to date |
| Hepatitis A | If eating out frequently |
| COVID-19 | Not required but available |

### Where to Get

| Location | Type |
|----------|------|
| Public hospitals | Free |
| Private clinics | Paid |
| Pharmacies | Some vaccines |

---

## Medical Tourism

Buenos Aires is a **medical tourism destination** due to:
- High quality
- Low costs
- Skilled surgeons

### Common Procedures

| Procedure | Cost (USD) |
|-----------|------------|
| Dental implants | $800-1,500 |
| LASIK | $1,500-3,000 |
| Cosmetic surgery | $2,000-8,000 |
| IVF | $3,000-6,000 |
| Knee replacement | $8,000-15,000 |

### Finding Care

| Resource | Notes |
|----------|-------|
| Hospital websites | Direct contact |
| Medical tourism agencies | Handle logistics |
| Referrals | Research carefully |

---

## Pregnancy & Birth

### Overview

Excellent maternal care available at all levels.

### Costs

| Service | Public | Private |
|---------|--------|---------|
| Prenatal care | Free | $1,500-4,000 |
| Hospital birth | Free | $3,000-8,000 |
| C-section | Free | $4,000-10,000 |
| Private room | N/A | Extra |

### Key Hospitals for Birth

| Hospital | Type |
|----------|------|
| Hospital Aleman | Private, excellent |
| Sanatorio Otamendi | Private |
| Swiss Medical | Private |
| Hospital Italiano | Private |
| Public hospitals | Free, variable quality |

### Citizenship Note

Children born in Argentina are **Argentine citizens** (jus soli).
