# Buenos Aires: Dining Practical Guide

## Payment & Money

### Cash vs Card

| Method | Acceptance | Notes |
|--------|------------|-------|
| Cash (pesos) | Everywhere | Best rates at blue dollar |
| Cash (USD) | Many restaurants | Ask for "dolar" price |
| Credit card | Most places | Official exchange rate (worse) |
| Debit card | Most places | Same as credit |

### The Blue Dollar Reality

**Critical to understand:**
- Official rate   900 ARS per USD (Feb 2026)
- Blue rate   1,200 ARS per USD
- Paying with foreign cards = official rate = 30%+ more expensive

**Strategy:**
1. Bring USD cash
2. Exchange at "cuevas" (informal exchanges) or Western Union
3. Pay cash at restaurants
4. Many restaurants quote USD prices and accept dollars

### Tipping

| Service | Tip |
|---------|-----|
| Restaurant (table service) | 10% |
| Counter service | Not expected |
| Delivery | Small amount or round up |
| Bar (per drink) | Not expected |
| Cafe | Round up or nothing |

**Note:** Some restaurants add "cubierto" (cover charge, $1-3). This is NOT tip-tip separately.

---

## Reservations

### How to Book

| Method | Best For |
|--------|----------|
| Mesa App | Local restaurants |
| The Fork | Some restaurants |
| WhatsApp | Many restaurants prefer |
| Instagram DM | Trendy/new spots |
| Phone call | Traditional places |
| Walk-in | Casual spots |

### When to Book

| Restaurant Type | Advance Time |
|-----------------|--------------|
| Don Julio | 2-3 weeks |
| Popular parrillas (weekend) | 1 week |
| Closed-door restaurants | 1-2 weeks |
| Fine dining | 3-7 days |
| Regular nice restaurant (weekend) | 2-3 days |
| Casual | Day of or walk-in |

### Peak Times

- **Lunch:** 1-2pm
- **Dinner:** 9:30-10:30pm start
- **Weekend dinner:** 10-11pm busiest

---

## Dining Etiquette

### Timing

- **Don't arrive at 7pm for dinner** - You'll be alone
- **Normal dinner:** 9-10pm arrival
- **Late dinner:** 10:30-11pm (common)
- **Lunch:** 12:30-2pm
- **Merienda:** 5-7pm (coffee + pastries)

### At the Table

| Practice | Notes |
|----------|-------|
| Bread | Often served, may be charged |
| Water | Ask for "agua sin gas" or "con gas" |
| Wine | House wine (vino de la casa) is usually fine |
| Sharing | Common and expected |
| Lingering | Take your time, not rushed |
| Bill | Ask "la cuenta, por favor" |
| Splitting | Not common, figure out among yourselves |

### Parrilla Specific

- **Don't ask for A1 or ketchup** - Offensive
- **Chimichurri sparingly** - Good meat doesn't need much
- **Salt** - Applied during cooking, don't over-salt
- **Sides share** - Fries and salad family-style
- **Pace yourself** - Meat is a lot

---

## Menu Spanish

### Common Terms

| Spanish | English |
|---------|---------|
| Entrada | Appetizer/starter |
| Plato principal | Main course |
| Postre | Dessert |
| Bebidas | Drinks |
| Vino tinto/blanco | Red/white wine |
| Agua | Water |
| Sin gas/con gas | Still/sparkling |
| Cerveza | Beer |
| Cafe | Coffee |
| La cuenta | The bill |
| Propina | Tip |

### Meat Terms

| Spanish | English |
|---------|---------|
| Carne | Beef |
| Pollo | Chicken |
| Cerdo | Pork |
| Cordero | Lamb |
| Pescado | Fish |
| Mariscos | Seafood |
| Achuras | Offal/organ meats |
| Jugoso | Rare |
| A punto | Medium rare |
| Cocido | Well done |

### Common Preparations

| Term | Meaning |
|------|---------|
| A la parrilla | Grilled |
| Al horno | Baked |
| Frito/a | Fried |
| A la plancha | On flat grill |
| Relleno/a | Stuffed |
| Con | With |
| Sin | Without |

---

## Dietary Needs

### Communicating Restrictions

| Need | Spanish |
|------|---------|
| I'm vegetarian | Soy vegetariano/a |
| I'm vegan | Soy vegano/a |
| I don't eat meat | No como carne |
| I don't eat fish | No como pescado |
| No gluten | Sin gluten / Sin TACC |
| No dairy | Sin lacteos |
| I'm allergic to... | Soy alergico/a a... |
| Nuts | Frutos secos / Nueces |
| Shellfish | Mariscos |

### Gluten-Free (Celiaco)

Argentina has good celiac awareness:
- "Sin TACC" is the local term (TACC = wheat, oat, barley, rye)
- Many products labeled
- Some dedicated bakeries
- Parrillas are usually safe (pure meat)
- Empanadas and milanesas are NOT safe

### Vegetarian Survival

| Safe Options |
|--------------|
| Provoleta (grilled cheese) |
| Empanadas de verdura/humita |
| Pizza |
| Pasta with vegetable sauces |
| Tartas (quiches) |
| Ensaladas |
| Dedicated vegetarian restaurants |

**Warning:** "Sin carne" may still include chicken to some people. Clarify.

### Vegan Reality

Harder but improving. Palermo has dedicated options:
- Buenos Aires Verde
- Artemisia
- Sacro
- Krishna (cheap, Hare Krishna)

---

## Alcohol

### Wine Basics

| Type | What to Order |
|------|---------------|
| Red | Malbec (safe choice), Cabernet Sauvignon |
| White | Torrontes (aromatic), Chardonnay |
| House wine | "Vino de la casa tinto/blanco" |
| By glass | "Una copa de..." |
| Bottle | "Una botella de..." |

### Beer Culture

| Brand | Type | Notes |
|-------|------|-------|
| Quilmes | Lager | National brand |
| Stella Artois | Lager | Brewed locally |
| Patagonia | Craft-ish | Widely available |
| Antares | Craft | Chain brewpub |
| Various craft | IPA, etc. | Growing scene |

### Fernet con Coca

The national drink among young Argentines:
- Fernet Branca + Coca-Cola
- Mixed 30/70 or 40/60
- Served in large glasses
- Often shared
- Acquired taste

### Cocktail Terms

| Spanish | English |
|---------|---------|
| Trago | Drink/cocktail |
| En las rocas | On the rocks |
| Directo | Neat/straight |
| Happy hour | Same term used |

---

## Service Expectations

### What's Normal

- **Slow by US standards** - Not rudeness, just pace
- **No hovering waiters** - You have to signal
- **Bill not brought unsolicited** - Ask for it
- **Water not automatic** - Order it
- **Refills not automatic** - Order more
- **Kids welcome everywhere** - Family-friendly culture

### Getting Attention

- **Raise hand** - Acceptable
- **"Mozo" or "Moza"** - Waiter/waitress (a bit old-fashioned)
- **"Disculpe"** - Excuse me
- **Eye contact + nod** - Works

### Complaints

Generally, Argentines don't complain much in restaurants. If you must:
- Be polite
- "Disculpe, pero..." (Excuse me, but...)
- Escalating to manager is rare

---

## Food Safety

### Generally Safe

Buenos Aires has good food safety standards:
- Tap water: Safe to drink
- Ice: Safe
- Salads: Safe
- Street food: Generally safe

### Caution

| Risk | Notes |
|------|-------|
| Buffets | Standard buffet cautions |
| Very cheap places | Use judgment |
| Seafood | BA is not a seafood city-stick to reputable places |
| Market raw foods | Fine if you'll cook |

### Stomach Issues

If you get sick:
- Pharmacies sell most medications OTC
- "Sertal" for cramps
- "Imodium" available
- Stay hydrated
- Soda water (agua con gas) can help

---

## Sunday Closures

**Many restaurants closed on Sundays.** Plan accordingly.

### Usually OPEN Sundays

- Puerto Madero (all)
- Palermo Soho (tourist-facing)
- Hotel restaurants
- Some chains (McDonald's, etc.)
- Chinatown (Belgrano)

### Usually CLOSED Sundays

- Traditional parrillas
- Neighborhood restaurants
- Many bakeries (afternoon)
- Locals' favorites

### Best Sunday Strategy

1. Brunch at Palermo spot
2. Lunch at San Telmo (market day)
3. Dinner at Puerto Madero or Palermo Soho
4. Or cook at home

---

## Delivery Apps

| App | Coverage | Notes |
|-----|----------|-------|
| Rappi | Wide | Most popular |
| PedidosYa | Wide | Good coverage |
| Uber Eats | Good | Reliable |
| Glovo | Some areas | Less common |

**Tip:** Delivery is cheap. Use apps for convenience.
