# Buenos Aires Food & Dining Overview

## The Scene

Buenos Aires is a carnivore's paradise and one of the world's great food cities. The cuisine reflects the city's immigrant heritage: Italian influence dominates (pasta, pizza), Spanish traditions persist (tapas, jamon), and the Argentine parrilla (grill) culture is sacred.

**Key characteristics:**
- **Beef obsession** - World's best grass-fed beef, consumed daily
- **Italian influence** - 60%+ of population has Italian ancestry
- **Late dining** - Dinner at 9-11pm is normal
- **Wine culture** - Malbec flows freely and cheaply
- **Cafe tradition** - Historic cafes are cultural institutions
- **Closed Sundays** - Many restaurants closed, plan ahead

## Price Ranges (USD at Blue Rate)

| Category | Per Person | Notes |
|----------|------------|-------|
| **Budget** | $5-10 | Empanadas, pizza, quick lunch spots |
| **Casual** | $10-20 | Neighborhood parrillas, pasta places |
| **Mid-Range** | $20-40 | Good parrillas, trendy spots |
| **Upscale** | $40-80 | Top restaurants, tasting menus |
| **Luxury** | $80-150+ | Tegui, Aramburu, closed-door experiences |

**Typical costs (blue rate):**
- Empanada: $1-1.50 each
- Pizza slice: $2-3
- Milanesa with fries: $8-12
- Bife de chorizo (steak): $15-25
- Bottle of good Malbec (restaurant): $10-20
- Coffee + medialunas: $3-5

## What to Expect

### Strengths
- **Beef** - Unquestionably world-class. Grass-fed, no hormones.
- **Wine** - Excellent Malbec, Torrontes at incredible prices
- **Italian food** - Authentic pasta, pizza (fugazzeta!)
- **Empanadas** - Regional varieties, cheap, everywhere
- **Cafe culture** - Historic cafes, long conversations
- **Value** - Dollar earners eat like kings

### Weaknesses
- **Vegetables** - Afterthought in traditional cuisine
- **Spice** - Virtually none in Argentine food
- **Seafood** - Despite coast, not a seafood city
- **Asian food** - Improving but still limited
- **Ethnic variety** - Less diverse than NYC/London

## The Classics

### Must-Try Argentine Dishes

| Dish | What It Is | Where |
|------|------------|-------|
| **Asado** | Mixed grill BBQ | Any parrilla |
| **Bife de chorizo** | Sirloin steak | Parrilla |
| **Empanadas** | Stuffed pastries | Everywhere |
| **Milanesa napolitana** | Breaded cutlet with ham, cheese | Casual restaurants |
| **Provoleta** | Grilled provolone cheese | Parrilla (starter) |
| **Choripan** | Chorizo sandwich | Street/stadiums |
| **Pizza argentina** | Thick, cheesy, unique style | Pizzerias |
| **Fugazzeta** | Onion pizza with cheese | Pizzerias |
| **Faina** | Chickpea flatbread | With pizza |
| **Dulce de leche** | Caramelized milk | Everything |
| **Alfajores** | Cookie sandwiches | Bakeries |
| **Facturas** | Argentine pastries | Panaderias |
| **Medialunas** | Croissants (sweet/plain) | Cafes |

### Steak Cuts Guide

| Cut (Argentine) | US Equivalent | Notes |
|-----------------|---------------|-------|
| Bife de chorizo | Sirloin strip | Most popular |
| Ojo de bife | Ribeye | Marbled |
| Bife de lomo | Tenderloin | Lean, tender |
| Entrana | Skirt steak | Flavorful |
| Vacio | Flank | Textured |
| Asado de tira | Short ribs | Traditional |
| Molleja | Sweetbreads | Offal, delicious |

### Doneness (Puntos)

| Spanish | English | Notes |
|---------|---------|-------|
| Jugoso | Rare | Red center |
| A punto | Medium rare | Pink center (recommended) |
| Cocido | Well done | Gray throughout |

**Tip:** Argentine beef is often cooked more than expected. Specify "muy jugoso" if you want truly rare.

## Wine Guide

### Argentine Varietals

| Wine | Profile | Pairing |
|------|---------|---------|
| **Malbec** | Full-bodied, plum, spice | Beef, lamb |
| **Torrontes** | Aromatic white, floral | Fish, appetizers |
| **Bonarda** | Fruity, lighter red | Pizza, pasta |
| **Cabernet Sauvignon** | Bold, structured | Steak |
| **Chardonnay** | Various styles | Chicken, fish |

### Wine Regions

| Region | Known For | Notes |
|--------|-----------|-------|
| Mendoza | Malbec | 70% of production |
| Salta | Torrontes, high-altitude Malbec | Unique terroir |
| Patagonia | Pinot Noir | Cooler climate |
| San Juan | Bonarda, Syrah | Value wines |

### Pricing (at Blue Rate)

| Where | Bottle Cost |
|-------|-------------|
| Supermarket (good wine) | $5-15 |
| Restaurant (mid-range) | $10-25 |
| Restaurant (premium) | $30-100+ |
| Wine bar by glass | $3-8 |

## Meal Times

| Meal | Time | Notes |
|------|------|-------|
| Desayuno (breakfast) | 7-10am | Light: coffee + medialunas |
| Almuerzo (lunch) | 12:30-3pm | Main meal for some, quick for workers |
| Merienda (afternoon tea) | 5-7pm | Coffee + facturas tradition |
| Cena (dinner) | 9-11pm | Main social meal |

**Key insight:** If you arrive at a restaurant at 7pm, you'll be alone or with tourists. Locals eat after 9pm.

## Tipping & Payment

- **Propina (tip):** 10% expected at sit-down restaurants
- **Cubierto:** Cover charge (~$1-2) at some restaurants
- **Cards:** Widely accepted, but cash often gets better treatment (blue rate)
- **Blue dollar:** Many restaurants accept USD at competitive rate
- **Splitting bills:** Not common practice, groups usually split mentally

## Reservations

| Venue Type | Reservation? |
|------------|--------------|
| Casual parrilla | Not needed |
| Popular restaurants | Weekend nights yes |
| Top restaurants | Essential, 1-2 weeks |
| Closed-door/puerta cerrada | Essential, book online |
| Sunday | Many closed-check first |

**Booking platforms:**
- Mesa App (local)
- The Fork
- Direct WhatsApp (many restaurants)
- Instagram DM (trendy spots)

## Dietary Restrictions

### Vegetarian

Improving but still challenging in traditional restaurants.

**Options:**
- Provoleta (grilled cheese)
- Empanadas de verdura/humita
- Pasta dishes
- Vegetarian-focused restaurants in Palermo

**Warning:** "Sin carne" might still include chicken or fish in local understanding.

### Vegan

Growing scene, especially Palermo.

**Dedicated restaurants:**
- Buenos Aires Verde
- Artemisia
- Hierbabuena
- Various in Palermo

### Celiac/Gluten-Free

Moderate awareness. Empanadas and milanesas are out. Steak is fine.

**Tips:**
- Parrillas are generally safe (stick to meat + salad)
- Ask about marinades
- Bring celiac card in Spanish

### Kosher

Small but established community.
- Once neighborhood has kosher restaurants
- Some Belgrano options

### Halal

Very limited options. Research specific restaurants.

## Seasonal Considerations

| Season | Dining Notes |
|--------|--------------|
| Summer (Dec-Feb) | Outdoor terraces busy, many locals leave in January |
| Fall (Mar-May) | Best weather for outdoor dining |
| Winter (Jun-Aug) | Indoor seating premium, hearty dishes |
| Spring (Sep-Nov) | Jacarandas bloom, perfect terrace weather |

## Sunday Reality

**Many restaurants closed.** Especially:
- Traditional parrillas (family day)
- Neighborhood spots
- Bakeries (morning only)

**Usually open:**
- Puerto Madero restaurants
- Palermo Soho (tourist-focused)
- Hotel restaurants
- Some chains

**Plan ahead for Sundays.**
