# Buenos Aires: Argentine Cuisine Deep Dive

## The Parrilla Experience

### What Is a Parrilla?

A parrilla is both the grill itself and the restaurant specializing in grilled meats. Every neighborhood has multiple parrillas, from humble corner spots to legendary institutions.

### Traditional Parrilla Meal

**Order progression:**
1. **Provoleta** - Grilled provolone cheese (starter)
2. **Empanadas** - As appetizer while meat cooks
3. **Achuras** - Organ meats/offal (for adventurous)
4. **Main cuts** - Your steak or mixed grill
5. **Papas fritas/Ensalada mixta** - Simple sides

### The Cuts (Detailed)

| Cut | Character | Best Preparation |
|-----|-----------|------------------|
| **Bife de chorizo** | Classic sirloin, good fat cap | A punto (medium rare) |
| **Ojo de bife** | Ribeye, most marbled | Jugoso |
| **Entrana** | Skirt, intense flavor | Hot and fast |
| **Vacio** | Flank, chewy texture | Slow grilled |
| **Tapa de asado** | Like flap meat, tender | A punto |
| **Cuadril** | Rump, lean | Don't overcook |

### Achuras (Offal)

Adventurous eaters should try:

| Achura | What It Is | Taste Profile |
|--------|------------|---------------|
| **Molleja** | Sweetbreads | Crispy, creamy, delicate |
| **Chinchulin** | Small intestine | Chewy, charred |
| **Rinon** | Kidney | Strong, iron-rich |
| **Morcilla** | Blood sausage | Sweet, earthy |
| **Chorizo** | Fresh sausage | Garlicky, juicy |

### Legendary Parrillas

| Restaurant | Location | Price | Notes |
|------------|----------|-------|-------|
| **Don Julio** | Palermo | $$$$ | Often rated BA's best |
| **La Cabrera** | Palermo | $$$$ | Massive portions |
| **El Pobre Luis** | Belgrano | $$$ | Local institution |
| **La Brigada** | San Telmo | $$$$ | Historic, cellar |
| **Parrilla Pena** | Recoleta | $$$ | Traditional |
| **Lo de Jesus** | Chacarita | $$ | Locals' favorite |
| **El Obrero** | La Boca | $$ | Authentic, cash only |
| **La Dorita** | Palermo | $$ | Value parrilla |

### Parrilla Etiquette

- **Don't rush.** Argentine meals last hours.
- **Bread is for sopping up juices,** not eating before food arrives.
- **Share cuts.** Order different ones for the table.
- **Chimichurri:** Use sparingly on good meat-it's not ketchup.
- **Don't ask for A1 sauce.** It doesn't exist here.

---

## Pizza Argentina

### It's Not Italian Pizza

Argentine pizza is its own thing:
- **Thicker crust** than Italian
- **Mountains of cheese** (mozzarella)
- **Fugazzeta** - Onion pizza, uniquely Argentine
- **Faina** - Chickpea flatbread, eaten ON the pizza

### Classic Pizzerias

| Pizzeria | Location | Specialty | Notes |
|----------|----------|-----------|-------|
| **Guerrin** | Corrientes | All classics | Standing at counter |
| **El Cuartito** | Centro | Nostalgic vibes | Celebrity photos |
| **Banchero** | La Boca | Fugazzeta inventor | Historic |
| **Las Cuartetas** | Corrientes | Late night | 24 hours weekends |
| **Pizzeria Angelin** | Villa Crespo | Local favorite | Less tourist |
| **La Mezzetta** | Almagro | Thick, cheesy | Neighborhood legend |
| **Kentucky** | Multiple | Classic chain | Consistent |

### Pizza Types

| Type | Description |
|------|-------------|
| **Muzzarella** | Basic cheese (note spelling) |
| **Fugazzeta** | Onion with cheese |
| **Fugazza** | Onion without cheese |
| **Napolitana** | Tomato, garlic, cheese |
| **Calabresa** | With calabrese sausage |
| **De cancha** | "Stadium style" - simple |
| **Canchera** | Muzzarella + ham |
| **Especial** | Ham + red pepper |

### The Faina Tradition

- Order faina (farinata) alongside your pizza
- Stack it ON TOP of pizza slice
- Eat together
- Must try: pizza + faina combo

---

## Empanadas

### Regional Varieties

| Style | Region | Characteristics |
|-------|--------|-----------------|
| **Tucumana** | Tucuman | Hand-diced beef, spiced |
| **Saltena** | Salta | Potatoes, peas, often sweet |
| **Criolla** | Buenos Aires | Ground beef, olives, egg |
| **Mendocina** | Mendoza | Baked, softer dough |

### Fillings

| Filling | Contents |
|---------|----------|
| **Carne** | Beef (various cuts) |
| **Pollo** | Chicken |
| **Jamon y queso** | Ham and cheese |
| **Humita** | Creamed corn |
| **Verdura** | Spinach/chard, vegetarian |
| **Carne picante** | Spiced beef |
| **Roquefort** | Blue cheese |
| **Caprese** | Tomato, basil, cheese |

### Best Empanada Spots

| Place | Location | Specialty |
|-------|----------|-----------|
| **El Sanjuanino** | Recoleta/Multiple | Classic, affordable |
| **La Cocina** | Palermo | Variety |
| **La Americana** | Centro | Historic, huge |
| **Cumana** | Recoleta | Regional varieties |
| **Lo de Andres** | Chacarita | Salta style |

### Empanada Intelligence

- **Al horno** = baked (most common)
- **Fritas** = fried (crispier)
- **Repulgue** = crimped edge pattern (identifies filling)
- Order by **docena** (dozen) for best price

---

## Milanesas

### The Argentine Schnitzel

Breaded and fried cutlet, usually beef or chicken.

### Variations

| Type | Description |
|------|-------------|
| **Milanesa simple** | Basic breaded cutlet |
| **Napolitana** | Topped with tomato, ham, cheese |
| **A la pizza** | With mozzarella on top |
| **A caballo** | With fried eggs on top |
| **Al plato** | Served flat on plate |
| **Sandwich de mila** | In bread |

### Where to Eat Milanesas

| Place | Location | Notes |
|-------|----------|-------|
| **El Club de la Milanesa** | Multiple | Specialty chain |
| **La Choza** | Palermo | Various sizes |
| **El Obrero** | La Boca | Huge portions |
| Any neighborhood restaurant | Everywhere | It's a staple |

### Pro Tip

Order "milanesa completa" = comes with fries and salad.

---

## Classic Cafes & Breakfast

### Historic Cafes (Cafes Notables)

| Cafe | Location | Opened | Notes |
|------|----------|--------|-------|
| **Cafe Tortoni** | Centro | 1858 | Most famous, touristy |
| **La Biela** | Recoleta | 1850 | Opposite cemetery |
| **Las Violetas** | Almagro | 1884 | Stunning interior |
| **El Gato Negro** | Centro | 1927 | Spices, coffee |
| **London City** | Centro | 1954 | Historic |
| **Cafe de los Angelitos** | Congreso | 1890s | Tango history |

### Breakfast/Merienda Staples

| Item | Description |
|------|-------------|
| **Medialunas** | Argentine croissants (sweet or plain) |
| **Facturas** | Assorted pastries |
| **Tostadas** | Toast with butter/jam |
| **Cafe con leche** | Coffee with steamed milk |
| **Submarino** | Hot milk with chocolate bar |
| **Cortado** | Espresso "cut" with milk |
| **Lagrima** | Milk with splash of coffee |

### Modern Specialty Coffee

BA has a growing specialty coffee scene:

| Shop | Location | Notes |
|------|----------|-------|
| **LAB Tostadores** | Palermo | Roasters |
| **Cuervo Cafe** | Palermo | Quality pour-overs |
| **Coffee Town** | Multiple | Consistent specialty |
| **Lattente** | Recoleta | Good espresso |
| **All Saints Cafe** | Palermo | Brunch + coffee |

---

## Dulce de Leche Everything

### What Is It?

Caramelized milk/cream. National obsession. On everything:
- Alfajores (cookie sandwiches)
- Facturas (pastries)
- Ice cream (helado)
- Crepes (panqueques)
- Toast
- Eaten from jar (don't judge)

### Best Dulce de Leche Products

| Product | Where |
|---------|-------|
| **Alfajores Havanna** | Chain stores |
| **Alfajores Cachafaz** | Supermarkets |
| **Helado de dulce de leche** | Any heladeria |
| **Vacalin** | Supermarket brand |
| **La Salamandra** | Artisan |

---

## Regional Specialties

### From the Northwest

| Dish | Description |
|------|-------------|
| **Locro** | Hearty corn/bean stew (winter, patriotic holidays) |
| **Humita** | Creamed corn in husk |
| **Tamales** | Corn dough with meat |
| **Empanadas saltenas** | Juicy, slightly sweet |

### From Patagonia

| Item | Description |
|------|-------------|
| **Cordero patagonico** | Lamb, spit-roasted |
| **Trucha** | Trout |
| **Chocolate** | Bariloche famous for it |
| **Berries** | Wild berries everywhere |

### Where to Find Regional Food in BA

| Region | Restaurant | Location |
|--------|------------|----------|
| Northwest | Cumana | Recoleta |
| Northwest | Lo de Andres | Chacarita |
| Patagonia | Patagonia Sur | La Boca |
| Various | Sarkis (Armenian) | Palermo |
