# Buenos Aires: International & Fine Dining

## The Fine Dining Scene

Buenos Aires has emerged as a serious culinary destination. The combination of excellent ingredients, trained chefs, and favorable exchange rates makes it a fine dining value.

### Top-Tier Restaurants

| Restaurant | Cuisine | Price | Notes |
|------------|---------|-------|-------|
| **Aramburu** | Modern Argentine | $$$$$ | Tasting menu only, 18 courses |
| **Tegui** | Contemporary | $$$$$ | German Martitegui's flagship |
| **Chila** | Modern Argentine | $$$$$ | Puerto Madero, water views |
| **Don Julio** | Parrilla | $$$$ | Possibly world's best steak |
| **Proper** | Farm to table | $$$$ | Seasonal, local |
| **Anafe** | Modern Argentine | $$$$ | Villa Crespo gem |
| **Narda Comedor** | Argentine comfort | $$$ | Narda Lepes |
| **Elena** | Steakhouse | $$$$$ | Four Seasons, refined |

### Closed-Door Restaurants (Puertas Cerradas)

Intimate dining in chefs' homes. Book ahead.

| Restaurant | Cuisine | Price | Notes |
|------------|---------|-------|-------|
| **Casa SaltShaker** | Eclectic | $$$$ | Dan Perlman, legendary |
| **Cocina Sunae** | Asian fusion | $$$$ | Korean/Japanese |
| **Casa Coupage** | French-Argentine | $$$$ | Wine pairing focus |
| **Treintasillas** | Modern | $$$ | Emerging chefs |
| **iLatina** | Pan-Latin | $$$$ | Multiple countries |

**How to book:** Usually via website or Instagram, 1-2 weeks ahead.

---

## Italian Cuisine

Given 60%+ of Argentines have Italian ancestry, Italian food is everywhere-and often excellent.

### Traditional Italian

| Restaurant | Specialty | Location |
|------------|-----------|----------|
| **Broccolino** | Pastas | Multiple |
| **Il Ballo del Mattone** | Roman | San Telmo |
| **La Parolaccia** | Pastas | Puerto Madero |
| **Cucina Paradiso** | Regional | Palermo |
| **Sottovoce** | Classic | Puerto Madero |
| **Spiagge di Napoli** | Neapolitan | Recoleta |

### Fresh Pasta (Pasta Fresca)

Every neighborhood has **fabricas de pastas**-shops making fresh pasta daily.

| Type | Description |
|------|-------------|
| **Sorrentinos** | Large stuffed pasta (Argentine invention) |
| **Ravioles** | Stuffed pasta |
| **Tallarines** | Fettuccine |
| **Noquis** | Gnocchi (tradition: eat on 29th of month) |
| **Canelones** | Cannelloni |

### The 29th Tradition

On the 29th of every month, Argentines eat noquis (gnocchi). Legend says it brings money. Leave a coin under your plate.

---

## Spanish Cuisine

Strong Spanish influence, especially in seafood and tapas.

| Restaurant | Type | Location | Notes |
|------------|------|----------|-------|
| **Oviedo** | Seafood | Recoleta | BA's best Spanish |
| **Sagardi** | Basque | Multiple | Pintxos |
| **El Boliche de Alberto** | Traditional | Palermo | Old school |
| **El Club Espanol** | Institution | Centro | Historic |
| **Mercat Villa Crespo** | Tapas | Villa Crespo | Modern |

---

## Asian Cuisine

Growing but still limited compared to major cities.

### Japanese

| Restaurant | Type | Price | Notes |
|------------|------|-------|-------|
| **Osaka** | Nikkei (Japanese-Peruvian) | $$$$ | Multiple locations |
| **Tomo Izakaya** | Izakaya | $$$ | Casual, good |
| **Nicky NY Sushi** | Sushi | $$$$ | Higher end |
| **Sushi Pop** | Rolls | $$ | Casual chain |
| **Ichisou** | Authentic | $$$ | Japanese expats |

### Chinese

| Restaurant | Location | Notes |
|------------|----------|-------|
| **Chinatown (Barrio Chino)** | Belgrano | Multiple options |
| **Lai Lai** | Belgrano | Traditional |
| **Asia de Cuba** | Various | Fusion |

### Korean

Limited options:
- **Bi Won** (Flores)
- **Moo** (Palermo)
- **Cocina Sunae** (closed-door, Korean-Japanese)

### Thai/Vietnamese/Indian

Scarce. A few options in Palermo:
- **Gran Dabbang** (Asian fusion, excellent)
- **Green Bamboo** (Vietnamese)
- **Tandoor** (Indian, limited)

---

## Middle Eastern & Armenian

Large Armenian community, excellent food.

| Restaurant | Cuisine | Location | Notes |
|------------|---------|----------|-------|
| **Sarkis** | Armenian/Lebanese | Palermo | Institution, huge portions |
| **Club Sirio** | Syrian/Lebanese | San Telmo | Social club, authentic |
| **Babilonia** | Middle Eastern | Palermo | Modern |
| **Al Karawan** | Lebanese | Belgrano | Family run |

### Must-Try

- Shawarma
- Lahmajun (Armenian pizza)
- Hummus, babaganoush
- Baklava

---

## Mexican & Latin American

### Mexican

Better than expected, growing scene:

| Restaurant | Style | Location |
|------------|-------|----------|
| **La Fabrica del Taco** | Street tacos | Multiple |
| **Comedor Nikkai** | Modern Mexican | Palermo |
| **Maria Felix** | Cantina | Palermo |
| **Maiz** | Contemporary | Belgrano |

### Peruvian

Strong presence:

| Restaurant | Notes |
|------------|-------|
| **Chan Chan** | Affordable ceviche |
| **Status** | Classic |
| **Osaka** | Nikkei |
| **La Mar** | Celebrity chef |
| **Sipan** | Casual |

### Venezuelan

Growing community:
- **Arepa Cafe** (Palermo)
- **Guacuco** (Multiple)

---

## Brunch Culture

Sunday brunch is a growing phenomenon, especially in Palermo.

### Best Brunch Spots

| Restaurant | Location | Style | Price |
|------------|----------|-------|-------|
| **Oui Oui** | Palermo | French | $$$ |
| **Ninina** | Palermo | Bakery/brunch | $$ |
| **Le Pain Quotidien** | Multiple | Belgian chain | $$$ |
| **Malvon** | Multiple | Classic | $$ |
| **Pain et Vin** | Palermo | French | $$$ |
| **All Saints** | Palermo | American-ish | $$ |
| **Cuervo Cafe** | Palermo | Coffee focus | $$ |

### What to Order

| Item | Description |
|------|-------------|
| **Eggs Benedict** | Growing popularity |
| **Avocado toast** | Ubiquitous |
| **Pancakes** | American style |
| **Tostadas** | Toast with toppings |
| **Shakshuka** | Middle Eastern influence |
| **Smoothie bowls** | Health-conscious |

---

## Wine Bars & Natural Wine

### Wine Bars

| Bar | Location | Specialty |
|-----|----------|-----------|
| **Pain et Vin** | Palermo | French wines too |
| **Aldo's** | Palermo | Extensive by glass |
| **Vico Wine Bar** | Palermo | Small plates |
| **Gran Bar Danzon** | Retiro | Classic, upscale |
| **878** | Palermo Hollywood | Cocktails + wine |

### Natural Wine

Growing movement:
- **Anafe** (restaurant with natural wine focus)
- **Lo de Joaquin Alberdi** (shop + bar)
- Various small producers from Mendoza

---

## Cocktail Scene

### Best Cocktail Bars

| Bar | Location | Style |
|-----|----------|-------|
| **Floreria Atlantico** | Retiro | World's 50 Best |
| **Presidente Bar** | Centro | Classic |
| **Victoria Brown** | Palermo | Speakeasy |
| **Frank's** | Palermo | Speakeasy |
| **Uptown** | Recoleta | Hotel bar |
| **Nicky NY** | Palermo | NYC style |
| **878** | Palermo Hollywood | Mixology |
| **Verne** | Palermo | Creative |

### Argentine Cocktails

| Cocktail | Ingredients |
|----------|-------------|
| **Fernet con Coca** | Fernet Branca + Coca-Cola |
| **Cynar** | Artichoke amaro (popular here) |
| **Clerico** | White wine sangria |
| **Hesperidina** | Local bitter, orange |

### The Fernet Phenomenon

Fernet Branca is consumed more in Argentina than anywhere else. Mixed with Coca-Cola, it's the national drink among young people.

---

## Vegetarian & Vegan

### Dedicated Restaurants

| Restaurant | Location | Notes |
|------------|----------|-------|
| **Buenos Aires Verde** | Palermo | Pioneer |
| **Artemisia** | Palermo | Vegan, beautiful |
| **Hierbabuena** | Villa Crespo | Natural |
| **Bio** | Multiple | Organic chain |
| **Krishna** | Palermo | Hare Krishna, cheap |
| **Sacro** | Palermo | Modern vegan |

### Vegetarian-Friendly Mainstream

| Restaurant | Good Options |
|------------|--------------|
| **Sarkis** | Hummus, falafel, vegetables |
| **Pizza places** | Vegetable toppings |
| **Osaka** | Vegetable sushi |
| **Any pasta place** | Vegetable pastas |

### Tips for Vegetarians

1. "Sin carne" - but clarify chicken/fish also excluded
2. Provoleta at parrillas is safe
3. Empanadas de verdura/humita
4. Tartas (quiches) common
5. Salads exist but not exciting
